/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.IRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public final class VertexArray
extends GLObject
implements IRenderer {
    private static final int NATIVE_BUFFER_SIZE = 0x600000;
    private final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x1800000);
    private final IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
    private final FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
    private final ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
    private int[] rawBuffer;
    private int rawBufferIndex;
    private int rawBufferSize = 0;
    private int vertexCount;
    private float textureU;
    private float textureV;
    private int color;
    private int normal;
    private int brightness;
    private int drawMode;
    private boolean hasTexture;
    private boolean hasColor;
    private boolean hasNormals;
    private boolean hasBrightness;
    private boolean isColorDisabled;
    private boolean isDrawing;

    public VertexArray(int id, int size) {
        super(id);
    }

    public void render(boolean compile) {
        int offs = 0;
        while (offs < this.vertexCount) {
            int vtc = Math.min(this.vertexCount - offs, 196608);
            if (compile) {
                this.intBuffer.clear();
                this.intBuffer.put(this.rawBuffer, offs << 3, vtc << 3);
                this.byteBuffer.position(0);
                this.byteBuffer.limit(vtc << 5);
            }
            offs += vtc;
            if (this.hasTexture) {
                this.floatBuffer.position(3);
                GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.floatBuffer);
                GL11.glEnableClientState((int)32888);
            }
            if (this.hasColor) {
                this.byteBuffer.position(20);
                GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.byteBuffer);
                GL11.glEnableClientState((int)32886);
            }
            if (this.hasNormals) {
                this.byteBuffer.position(24);
                GL11.glNormalPointer((int)32, (ByteBuffer)this.byteBuffer);
                GL11.glEnableClientState((int)32885);
            }
            if (this.hasBrightness) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                this.shortBuffer.position(14);
                GL11.glTexCoordPointer((int)2, (int)32, (ShortBuffer)this.shortBuffer);
                GL11.glEnableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            this.floatBuffer.position(0);
            GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.floatBuffer);
            GL11.glEnableClientState((int)32884);
            GL11.glDrawArrays((int)this.drawMode, (int)0, (int)vtc);
            GL11.glDisableClientState((int)32884);
            if (this.hasTexture) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasColor) {
                GL11.glDisableClientState((int)32886);
            }
            if (this.hasNormals) {
                GL11.glDisableClientState((int)32885);
            }
            if (!this.hasBrightness) continue;
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glDisableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
    }

    @Override
    public int draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        this.render(true);
        if (this.rawBufferSize > 131072 && this.rawBufferIndex < this.rawBufferSize << 3) {
            this.rawBufferSize = 65536;
            this.rawBuffer = new int[this.rawBufferSize];
        }
        int i = this.rawBufferIndex << 2;
        return i;
    }

    private void reset() {
        this.vertexCount = 0;
        this.byteBuffer.clear();
        this.rawBufferIndex = 0;
    }

    @Override
    public void startDrawing(int par1) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = par1;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasBrightness = false;
        this.isColorDisabled = false;
    }

    public void setTextureUV(float par1, float par3) {
        this.hasTexture = true;
        this.textureU = par1;
        this.textureV = par3;
    }

    @Override
    public void setBrightness(int par1) {
        this.hasBrightness = true;
        this.brightness = par1;
    }

    @Override
    public void setColor(int r, int g, int b, int a) {
        if (!this.isColorDisabled) {
            int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
            int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
            int n3 = b > 255 ? 255 : (b = b < 0 ? 0 : b);
            a = a > 255 ? 255 : (a < 0 ? 0 : a);
            this.hasColor = true;
            this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
        }
    }

    @Override
    public void addVertexWithUV(float par1, float par3, float par5, float par7, float par9) {
        this.setTextureUV(par7, par9);
        this.addVertex(par1, par3, par5);
    }

    public void addVertex(float par1, float par3, float par5) {
        if (this.rawBufferIndex >= this.rawBufferSize - 32) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 65536;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits(par1);
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits(par3);
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits(par5);
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits(this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits(this.textureV);
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 5] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 6] = this.normal;
        }
        if (this.hasBrightness) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.brightness;
        }
        this.rawBufferIndex += 8;
        ++this.vertexCount;
    }

    public void setColorOpaque_I(int par1) {
        this.setColorRGBA_I(par1, 255);
    }

    public void setColorRGBA_I(int par1, int par2) {
        int k = par1 >> 16 & 0xFF;
        int l = par1 >> 8 & 0xFF;
        int i1 = par1 & 0xFF;
        this.setColor(k, l, i1, par2);
    }

    public void disableColor() {
        this.isColorDisabled = true;
    }

    @Override
    public void setNormal(float par1, float par2, float par3) {
        this.hasNormals = true;
        int b0 = (int)(par1 * 127.0f);
        int b1 = (int)(par2 * 127.0f);
        int b2 = (int)(par3 * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }
}

