/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.IRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public final class VertexArray2
extends GLObject
implements IRenderer {
    private static final int BUF_INIT_SIZE = 32768;
    private boolean initialized = false;
    private ByteBuffer byteBuffer;
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private ShortBuffer shortBuffer;
    private final List<Integer> rawBuf = new ArrayList<Integer>();
    private int rawBufferSize = 32768;
    private int[] rawBuffer = new int[this.rawBufferSize];
    private int rawBufferIndex;
    private int vertexCount;
    private int drawMode;
    private boolean isDrawing;
    private float textureU;
    private float textureV;
    private int color;
    private int normal;
    private int brightness;
    private boolean hasTexture;
    private boolean hasColor;
    private boolean hasNormals;
    private boolean hasBrightness;

    public VertexArray2(int id) {
        super(id);
    }

    private void setupVertexArray() {
        int sizeInt = this.vertexCount * 8;
        if (!this.initialized) {
            this.initBuffer(sizeInt);
        }
        try {
            this.intBuffer.clear();
            int rem = this.intBuffer.remaining();
            if (sizeInt > rem) {
                NGTLog.debug("[VertexArray2] SizeOver(%d > %d)", sizeInt, rem);
                this.initBuffer(sizeInt);
            }
            this.intBuffer.put(this.rawBuffer, 0, sizeInt);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(sizeInt);
        }
        catch (BufferOverflowException e) {
            NGTLog.debug("[VertexArray2] Overflow : IntBuf(%d), RawBuf(%d), SizeInt(%d)", this.intBuffer.remaining(), this.rawBuffer.length, sizeInt);
            throw e;
        }
        this.rawBufferSize = 32768;
        this.rawBuffer = new int[this.rawBufferSize];
        this.rawBufferIndex = 0;
    }

    private void initBuffer(int sizeInt) {
        this.initialized = true;
        int sizeByte = sizeInt * 4;
        this.byteBuffer = GLAllocation.func_74524_c((int)sizeByte);
        this.intBuffer = this.byteBuffer.asIntBuffer();
        this.floatBuffer = this.byteBuffer.asFloatBuffer();
        this.shortBuffer = this.byteBuffer.asShortBuffer();
        NGTLog.debug("[VertexArray2] CreateBuf(%d KB)", sizeByte >> 10);
    }

    public void render() {
        if (!this.initialized) {
            return;
        }
        if (this.hasTexture) {
            this.floatBuffer.position(3);
            GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.floatBuffer);
            GL11.glEnableClientState((int)32888);
        }
        if (this.hasColor) {
            this.byteBuffer.position(20);
            GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.byteBuffer);
            GL11.glEnableClientState((int)32886);
        }
        if (this.hasNormals) {
            this.byteBuffer.position(24);
            GL11.glNormalPointer((int)32, (ByteBuffer)this.byteBuffer);
            GL11.glEnableClientState((int)32885);
        }
        if (this.hasBrightness) {
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            this.shortBuffer.position(14);
            GL11.glTexCoordPointer((int)2, (int)32, (ShortBuffer)this.shortBuffer);
            GL11.glEnableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
        this.floatBuffer.position(0);
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.floatBuffer);
        GL11.glEnableClientState((int)32884);
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
        GL11.glDisableClientState((int)32884);
        if (this.hasTexture) {
            GL11.glDisableClientState((int)32888);
        }
        if (this.hasColor) {
            GL11.glDisableClientState((int)32886);
        }
        if (this.hasNormals) {
            GL11.glDisableClientState((int)32885);
        }
        if (this.hasBrightness) {
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glDisableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
    }

    public void cancel() {
        this.isDrawing = false;
        this.rawBufferSize = 32768;
        this.rawBuffer = new int[this.rawBufferSize];
        this.rawBufferIndex = 0;
    }

    @Override
    public int draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        this.setupVertexArray();
        return this.rawBufferIndex << 2;
    }

    private void reset() {
        this.vertexCount = 0;
        this.rawBufferIndex = 0;
    }

    @Override
    public void startDrawing(int par1) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = par1;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasBrightness = false;
    }

    public void setTextureUV(float par1, float par3) {
        this.hasTexture = true;
        this.textureU = par1;
        this.textureV = par3;
    }

    @Override
    public void setBrightness(int par1) {
        this.hasBrightness = true;
        this.brightness = par1;
    }

    @Override
    public void setColor(int r, int g, int b, int a) {
        int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
        int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
        int n3 = b > 255 ? 255 : (b = b < 0 ? 0 : b);
        a = a > 255 ? 255 : (a < 0 ? 0 : a);
        this.hasColor = true;
        this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
    }

    @Override
    public void addVertexWithUV(float par1, float par3, float par5, float par7, float par9) {
        this.setTextureUV(par7, par9);
        this.addVertex(par1, par3, par5);
    }

    public void addVertex(float par1, float par3, float par5) {
        if (this.rawBufferIndex >= this.rawBufferSize - 32) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 32768;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits(par1);
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits(par3);
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits(par5);
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits(this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits(this.textureV);
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 5] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 6] = this.normal;
        }
        if (this.hasBrightness) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.brightness;
        }
        this.rawBufferIndex += 8;
        ++this.vertexCount;
    }

    public void setColorOpaque_I(int par1) {
        this.setColorRGBA_I(par1, 255);
    }

    public void setColorRGBA_I(int par1, int par2) {
        int k = par1 >> 16 & 0xFF;
        int l = par1 >> 8 & 0xFF;
        int i1 = par1 & 0xFF;
        this.setColor(k, l, i1, par2);
    }

    @Override
    public void setNormal(float par1, float par2, float par3) {
        this.hasNormals = true;
        int b0 = (int)(par1 * 127.0f);
        int b1 = (int)(par2 * 127.0f);
        int b2 = (int)(par3 * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }
}

