/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.media;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.ResourceLocationCustom;

public class GIF {
    protected final List<BufferedImage> images = new ArrayList<BufferedImage>();
    protected int width;
    protected int height;
    protected int frameNum;
    protected int frameRate;
    private static final long INTERVAL = 3600000L;

    private GIF() {
    }

    public static GIF load(String source) {
        InputStream stream = null;
        if (source.startsWith("http")) {
            try {
                stream = new URL(source).openStream();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            stream = NGTFileLoader.getInputStream(new ResourceLocationCustom(source));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return GIF.load(stream);
    }

    public static GIF load(InputStream stream) {
        ArrayList<BufferedImage> tempList = new ArrayList<BufferedImage>();
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        if (reader == null) {
            return null;
        }
        try {
            reader.setInput(ImageIO.createImageInputStream(stream));
            int count = reader.getNumImages(true);
            for (int i = 0; i < count; ++i) {
                tempList.add(reader.read(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
        if (tempList == null || tempList.isEmpty()) {
            return null;
        }
        GIF gif = new GIF();
        BufferedImage firstImg = (BufferedImage)tempList.get(0);
        int width = firstImg.getWidth();
        int height = firstImg.getHeight();
        BufferedImage imgTemp = new BufferedImage(width, height, 2);
        Graphics graphics = imgTemp.getGraphics();
        for (int i = 0; i < tempList.size(); ++i) {
            graphics.drawImage((Image)tempList.get(i), 0, 0, null);
            BufferedImage currentImg = new BufferedImage(width, height, 2);
            currentImg.setData(imgTemp.getData());
            gif.images.add(currentImg);
        }
        int delayTime = 500;
        try {
            IIOMetadata imageMetaData = reader.getImageMetadata(0);
            String metaFormatName = imageMetaData.getNativeMetadataFormatName();
            IIOMetadataNode root = (IIOMetadataNode)imageMetaData.getAsTree(metaFormatName);
            IIOMetadataNode gceNode = GIF.getNode(root, "GraphicControlExtension");
            delayTime = Integer.valueOf(gceNode.getAttribute("delayTime"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        gif.width = width;
        gif.height = height;
        gif.frameNum = gif.images.size();
        gif.frameRate = delayTime * 10;
        return gif;
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    public BufferedImage getImage(int index) {
        return this.images.get(index);
    }

    public int getCurrentFrameIndex() {
        long t = System.currentTimeMillis() % 3600000L;
        return (int)t / this.frameRate % this.frameNum;
    }
}

