/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.media;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.media.MediaBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class ImageBase
extends MediaBase {
    private ByteBuffer buffer;
    private int[] intBuffer;
    private float[] uvBuf = new float[]{0.0f, 0.0f, 1.0f, 1.0f};

    @Nullable
    public abstract BufferedImage getImage();

    public abstract int getTextureId();

    public void setUV(float minU, float minV, float maxU, float maxV) {
        this.uvBuf[0] = minU;
        this.uvBuf[1] = minV;
        this.uvBuf[2] = maxU;
        this.uvBuf[3] = maxV;
    }

    @Override
    public void render(float width, float height, boolean fitAspectRatio) {
        BufferedImage image = this.getImage();
        if (image != null) {
            this.renderImage(width, height, fitAspectRatio, image);
        }
    }

    @Override
    public void exit() {
    }

    protected void renderImage(float width, float height, boolean fitAspectRatio, BufferedImage image) {
        GlStateManager.func_179144_i((int)this.getTextureId());
        float minU = this.uvBuf[0];
        float maxU = this.uvBuf[2];
        float minV = this.uvBuf[1];
        float maxV = this.uvBuf[3];
        float hw = width * 0.5f;
        float hh = height * 0.5f;
        float depth = 0.0f;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0f - hw, 0.0f + hh, depth, minU, minV);
        tessellator.addVertexWithUV(0.0f - hw, 0.0f - hh, depth, minU, maxV);
        tessellator.addVertexWithUV(0.0f + hw, 0.0f - hh, depth, maxU, maxV);
        tessellator.addVertexWithUV(0.0f + hw, 0.0f + hh, depth, maxU, minV);
        tessellator.draw();
    }

    protected void uploadTexture(int id, BufferedImage image) {
        this.uploadTextureGL(id, image);
    }

    private void uploadTextureGL(int id, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (this.intBuffer == null) {
            this.intBuffer = new int[width * height];
            TextureUtil.func_110991_a((int)id, (int)width, (int)height);
        }
        switch (image.getType()) {
            case 2: {
                this.readAsIntARGB(image);
                break;
            }
            case 1: {
                this.readAsIntRGB(image);
                break;
            }
            case 13: {
                this.readAsByteIndexed(image);
                break;
            }
            case 0: {
                this.readAsCustom(image);
                break;
            }
            default: {
                NGTLog.debug("Unsupported type : " + image.getType());
                return;
            }
        }
        TextureUtil.func_110988_a((int)id, (int[])this.intBuffer, (int)width, (int)height);
    }

    @Deprecated
    private void uploadTextureGL2(int id, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        GlStateManager.func_179144_i((int)id);
        if (this.buffer == null) {
            this.buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
            this.buffer.order(ByteOrder.nativeOrder());
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
        }
        this.buffer.clear();
        switch (image.getType()) {
            case 2: {
                this.readAsIntARGB(image);
                break;
            }
            case 1: {
                this.readAsIntRGB(image);
                break;
            }
            case 13: {
                this.readAsByteIndexed(image);
                break;
            }
            default: {
                this.readAsIntARGB(image);
            }
        }
        this.buffer.flip();
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)this.buffer);
    }

    private void readAsIntARGB(BufferedImage image) {
        DataBuffer dataBuf = image.getRaster().getDataBuffer();
        for (int i = 0; i < dataBuf.getSize(); ++i) {
            int color = dataBuf.getElem(i);
            byte a = (byte)(color >> 24 & 0xFF);
            byte r = (byte)(color >> 16 & 0xFF);
            byte g = (byte)(color >> 8 & 0xFF);
            byte b = (byte)(color & 0xFF);
            this.intBuffer[i] = color;
        }
    }

    private void readAsIntRGB(BufferedImage image) {
        DataBufferInt dataBuf = (DataBufferInt)image.getRaster().getDataBuffer();
        this.intBuffer = dataBuf.getData();
    }

    private void readAsByteIndexed(BufferedImage image) {
        IndexColorModel model = (IndexColorModel)image.getColorModel();
        DataBufferByte dataBuf = (DataBufferByte)image.getRaster().getDataBuffer();
        for (int i = 0; i < dataBuf.getSize(); ++i) {
            int color;
            int index = dataBuf.getElem(i);
            this.intBuffer[i] = color = model.getRGB(index);
        }
    }

    private void readAsCustom(BufferedImage image) {
        DataBufferByte dataBuf = (DataBufferByte)image.getRaster().getDataBuffer();
        for (int i = 0; i < dataBuf.getSize(); i += 3) {
            int r = dataBuf.getElem(i);
            int g = dataBuf.getElem(i + 1);
            int b = dataBuf.getElem(i + 2);
            this.intBuffer[i / 3] = 0xFF000000 | r << 16 | g << 8 | b;
        }
    }
}

