/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.ResourceLocationCustom;
import jp.ngt.ngtlib.renderer.model.EncryptedModel;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.ngtlib.renderer.model.MqoModel;
import jp.ngt.ngtlib.renderer.model.MqozModel;
import jp.ngt.ngtlib.renderer.model.ObjModel;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ModelLoader {
    public static PolygonModel loadModel(String path, VecAccuracy par1, Object ... args) {
        return ModelLoader.loadModel(new ResourceLocationCustom("minecraft", path), par1, args);
    }

    public static PolygonModel loadModel(ResourceLocation resource, VecAccuracy par1, Object ... args) {
        String fileName = resource.toString();
        try {
            InputStream is = NGTFileLoader.getInputStream(resource);
            if (FileType.OBJ.match(resource.func_110623_a())) {
                String mtlFileName = resource.func_110623_a().replaceAll(".obj", ".mtl");
                ResourceLocation mtlFile = new ResourceLocation(resource.func_110624_b(), mtlFileName);
                InputStream is2 = null;
                try {
                    is2 = NGTFileLoader.getInputStream(mtlFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ModelLoader.loadModel(new InputStream[]{is, is2}, fileName, par1, args);
            }
            return ModelLoader.loadModel(new InputStream[]{is}, fileName, par1, args);
        }
        catch (IOException e) {
            throw new ModelFormatException("Failed to load model : " + fileName, e);
        }
    }

    public static PolygonModel loadModel(File file, VecAccuracy par1, Object ... args) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            if (FileType.OBJ.match(file.getName())) {
                String mtlFileName = file.getName().replaceAll(".obj", ".mtl");
                File mtlFile = new File(file.getParentFile(), mtlFileName);
                BufferedInputStream is2 = null;
                try {
                    is2 = new BufferedInputStream(new FileInputStream(mtlFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ModelLoader.loadModel(new InputStream[]{is, is2}, file.getName(), par1, args);
            }
            return ModelLoader.loadModel(new InputStream[]{is}, file.getName(), par1, args);
        }
        catch (IOException e) {
            throw new ModelFormatException("Failed to load model : " + file.getName(), e);
        }
    }

    public static PolygonModel loadModel(InputStream[] is, String name, VecAccuracy par1, Object ... args) {
        if (FileType.OBJ.match(name)) {
            return new ObjModel(is, name, par1);
        }
        if (FileType.MQO.match(name)) {
            if (args.length > 0) {
                return new MqoModel(is, name, (Integer)args[0], par1);
            }
            return new MqoModel(is, name, 4, par1);
        }
        if (FileType.MQOZ.match(name)) {
            return new MqozModel(is, name, 4, par1);
        }
        if (FileType.NPM.match(name)) {
            EncryptedModel em = EncryptedModel.getInstance(is[0], (byte[])args[1]);
            return em.getModel(name, par1, args);
        }
        return null;
    }
}

