/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.Material;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.ngtlib.renderer.model.PolygonModel;
import jp.ngt.ngtlib.renderer.model.TextureCoordinate;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.renderer.model.Vertex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MqoModel
extends PolygonModel {
    private static final Pattern GROUP_PATTERN = Pattern.compile("\"(.+?)\"");
    private static final Pattern VERTEX_INDEX_PATTERN = Pattern.compile("V\\((.+?)\\)");
    private static final Pattern UV_PATTERN = Pattern.compile("UV\\((.+?)\\)");
    private static final Pattern MATERIAL_PATTERN = Pattern.compile("M\\((.+?)\\)");
    private static final byte Type_Object = 0;
    private static final byte Type_Vertex = 1;
    private static final byte Type_Face = 2;
    private static final byte Type_Material = 3;
    private static final byte Type_Thumbnail = 4;
    private Map<String, Material> materials;
    private ArrayList<Vertex> currentVertices;
    private Map<Vertex, Vertex> mirrorVertex;
    private byte currentType = (byte)-1;
    private byte mirrorType = (byte)-1;

    protected MqoModel(InputStream[] is, String name, int mode, VecAccuracy par3) throws ModelFormatException {
        super(is, name, mode, par3);
    }

    @Override
    protected void init(InputStream[] is) throws ModelFormatException {
        this.materials = new HashMap<String, Material>();
        this.currentVertices = new ArrayList(256);
        this.mirrorVertex = new HashMap<Vertex, Vertex>(256);
        super.init(is);
    }

    @Override
    protected void parseLine(String currentLine, int lineCount) {
        if (currentLine.isEmpty()) {
            return;
        }
        if (this.currentType >= 0) {
            if (currentLine.startsWith("}")) {
                this.currentType = (byte)-1;
            } else if (this.currentType == 2) {
                Face face;
                if (this.currentGroupObject == null) {
                    this.currentGroupObject = new GroupObject("Default", this.drawMode);
                }
                if ((face = this.parseFace(currentLine, lineCount)) != null) {
                    this.currentGroupObject.faces.add(face);
                    if (this.mirrorType >= 0) {
                        Face mirror = face.getMirror(this.mirrorType, this.mirrorVertex, this.accuracy);
                        this.currentGroupObject.faces.add(mirror);
                    }
                }
            } else if (this.currentType == 1) {
                Vertex vertex = this.parseVertex(currentLine, lineCount);
                if (vertex != null) {
                    this.currentVertices.add(vertex);
                    this.calcSizeBox(vertex);
                }
            } else {
                if (this.currentType == 4) {
                    return;
                }
                if (this.currentType == 3) {
                    this.parseMaterial(currentLine, lineCount);
                }
            }
        } else if (currentLine.startsWith("vertex ")) {
            this.currentType = 1;
            this.vertices.addAll(this.currentVertices);
            this.currentVertices.clear();
        } else if (currentLine.startsWith("face ")) {
            this.currentType = (byte)2;
        } else if (currentLine.startsWith("Material ")) {
            this.currentType = (byte)3;
        } else if (currentLine.startsWith("Object ")) {
            GroupObject group = this.parseGroupObject(currentLine, lineCount);
            if (group != null && this.currentGroupObject != null) {
                this.groupObjects.add(this.currentGroupObject);
            }
            this.currentGroupObject = group;
            this.mirrorType = (byte)-1;
            this.mirrorVertex.clear();
        } else if (currentLine.startsWith("mirror_axis ")) {
            String[] sa = this.split(currentLine, ' ');
            int axis = Integer.parseInt(sa[1]);
            this.mirrorType = (byte)(axis == 1 ? 0 : (axis == 2 ? 1 : 2));
        } else if (currentLine.startsWith("facet ")) {
            float angle;
            String[] sa = this.split(currentLine, ' ');
            this.currentGroupObject.smoothingAngle = angle = this.getFloat(sa[1]);
        } else if (currentLine.startsWith("Thumbnail ")) {
            this.currentType = (byte)4;
        }
    }

    @Override
    protected void postInit() {
        if (this.currentGroupObject != null) {
            this.groupObjects.add(this.currentGroupObject);
        }
        this.vertices.addAll(this.currentVertices);
        this.currentVertices.clear();
        this.mirrorVertex.clear();
    }

    private void parseMaterial(String line, int lineCount) throws ModelFormatException {
        String[] tokens = this.split(line, ' ');
        if (tokens.length <= 1) {
            throw new ModelFormatException("Error parsing material ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "'");
        }
        String matName = tokens[0].replaceAll("\"", "");
        Material material = new Material((byte)this.materials.size(), null);
        this.materials.put(matName, material);
    }

    private Vertex parseVertex(String line, int lineCount) throws ModelFormatException {
        String[] tokens = this.split(line, ' ');
        try {
            if (tokens.length == 2) {
                return Vertex.create(this.getCorrectValue(tokens[0]), this.getCorrectValue(tokens[1]), 0.0f, this.accuracy);
            }
            if (tokens.length == 3) {
                return Vertex.create(this.getCorrectValue(tokens[0]), this.getCorrectValue(tokens[1]), this.getCorrectValue(tokens[2]), this.accuracy);
            }
        }
        catch (NumberFormatException e) {
            throw new ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
        }
        return null;
    }

    private float getCorrectValue(String s) {
        return this.getFloat(s) * 0.01f;
    }

    @Nullable
    private Face parseFace(String line, int lineCount) throws ModelFormatException {
        String[] tokens = this.split(line, ' ');
        String mat = this.getMaterial(line);
        int matId = mat.length() == 0 ? 0 : Integer.parseInt(mat);
        int vertexCount = Integer.parseInt(tokens[0]);
        if (vertexCount == 4 && this.drawMode == 7) {
            return this.parseFaceQuads(line, (byte)matId, lineCount);
        }
        return vertexCount < 3 ? null : this.parsePolygon(line, (byte)matId, lineCount, vertexCount);
    }

    private Face parseFaceQuads(String line, byte matId, int lineCount) {
        Face face = new Face(4, matId);
        String vertexIndex = this.getVertexIndex(line);
        String[] vertexes = this.split(vertexIndex, ' ');
        String uv = this.getUV(line);
        String[] uvs = uv.length() == 0 ? null : this.split(uv, ' ');
        for (int i = 0; i < 4; ++i) {
            Vertex vertex = this.currentVertices.get(Integer.parseInt(vertexes[i]));
            float u = uvs == null ? 0.0f : this.getFloat(uvs[i * 2]);
            float v = uvs == null ? 0.0f : this.getFloat(uvs[i * 2 + 1]);
            TextureCoordinate tex = TextureCoordinate.create(u, v, this.accuracy);
            face.addVertex(3 - i, vertex, tex);
        }
        face.calculateFaceNormal(this.accuracy);
        return face;
    }

    private Face parsePolygon(String line, byte matId, int lineCount, int vertexCount) {
        if (this.drawMode != 4) {
            String msg = String.format("Error parsing face ('%s', line %d) in file '%s'", line, lineCount, this.fileName);
            throw new ModelFormatException(msg);
        }
        int size = (vertexCount - 2) * 3;
        Face face = new Face(size, matId);
        String vertexIndex = this.getVertexIndex(line);
        String[] vertexes = this.split(vertexIndex, ' ');
        String uv = this.getUV(line);
        String[] uvs = uv.length() == 0 ? null : this.split(uv, ' ');
        for (int i = 0; i < size; ++i) {
            int index = i % 3 == 0 ? 0 : i / 3 + i % 3;
            index = (vertexCount - index) % vertexCount;
            Vertex vertex = this.currentVertices.get(Integer.parseInt(vertexes[index]));
            float u = uvs == null ? 0.0f : this.getFloat(uvs[index * 2]);
            float v = uvs == null ? 0.0f : this.getFloat(uvs[index * 2 + 1]);
            TextureCoordinate tex = TextureCoordinate.create(u, v, this.accuracy);
            face.addVertex(i, vertex, tex);
        }
        face.calculateFaceNormal(this.accuracy);
        return face;
    }

    private GroupObject parseGroupObject(String line, int lineCount) throws ModelFormatException {
        String s = this.getGroupObjectName(line);
        if (s != null && s.length() > 0) {
            return new GroupObject(s, this.drawMode);
        }
        throw new ModelFormatException("Error parsing object ('" + line + "', line " + lineCount + ") in file '" + this.fileName + "'");
    }

    private String getVertexIndex(String line) {
        return this.getMatchedString(VERTEX_INDEX_PATTERN.matcher(line));
    }

    private String getUV(String line) {
        return this.getMatchedString(UV_PATTERN.matcher(line));
    }

    private String getMaterial(String line) {
        return this.getMatchedString(MATERIAL_PATTERN.matcher(line));
    }

    private String getGroupObjectName(String line) {
        return this.getMatchedString(GROUP_PATTERN.matcher(line));
    }

    private String getMatchedString(Matcher matcher) {
        try {
            matcher.find();
            return matcher.group(1);
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    @Override
    public FileType getType() {
        return FileType.MQO;
    }

    @Override
    public Map<String, Material> getMaterials() {
        return this.materials;
    }
}

