/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.Material;
import jp.ngt.ngtlib.renderer.model.ModelFormatException;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class NGTOModel
implements IModelNGT {
    public static final String GROUP_NAME = "default";
    private final NGTObject ngto;
    private final float scale;
    private GLObject[] glLists;
    private NGTWorld world;
    private final float[] sizeBox = new float[6];
    private final ArrayList<GroupObject> parts = new ArrayList();
    private final Map<String, Material> materials = new HashMap<String, Material>();

    public NGTOModel(ResourceLocation par1, float par2) {
        this.ngto = this.loadModel(par1);
        if (this.ngto == null) {
            throw new ModelFormatException("Can't load NGTO");
        }
        this.materials.put(GROUP_NAME, new Material(0, TextureMap.field_110575_b));
        this.scale = par2;
        NGTOModel.calcSizeBox(this.ngto, this.scale, this.sizeBox);
    }

    private NGTObject loadModel(ResourceLocation par1) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(par1);
            return NGTObject.load(res.func_110527_b());
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model", e);
        }
    }

    public static final void calcSizeBox(NGTObject ngto, float scale, float[] sizeBox) {
        float hX = (float)ngto.xSize * 0.5f;
        float hZ = (float)ngto.zSize * 0.5f;
        sizeBox[0] = -hX * scale;
        sizeBox[1] = 0.0f;
        sizeBox[2] = -hZ * scale;
        sizeBox[3] = hX * scale;
        sizeBox[4] = (float)ngto.ySize * scale;
        sizeBox[5] = hZ * scale;
    }

    @Override
    public float[] getSize() {
        return this.sizeBox;
    }

    @Override
    public void renderAll(boolean smoothing) {
        if (this.world == null) {
            if (NGTUtil.getClientWorld() == null) {
                return;
            }
            this.world = new NGTWorld(NGTUtil.getClientWorld(), this.ngto);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        float x = (float)this.ngto.xSize * 0.5f;
        float z = (float)this.ngto.zSize * 0.5f;
        GL11.glTranslatef((float)(-x), (float)0.0f, (float)(-z));
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == -1) {
            pass = 0;
        }
        NGTObjectRenderer.INSTANCE.renderTileEntities(this.world, 0.0f, pass);
        NGTObjectRenderer.INSTANCE.renderEntities(this.world, 0.0f, pass);
        this.renderBlocks(pass);
        GL11.glPopMatrix();
    }

    @Override
    public void renderOnly(boolean smoothing, String ... groupNames) {
        if (groupNames.length == 1 && groupNames[0].equals(GROUP_NAME)) {
            this.renderAll(smoothing);
        }
    }

    @Override
    public void renderPart(boolean smoothing, String partName) {
        if (partName.equals(GROUP_NAME)) {
            this.renderAll(smoothing);
        }
    }

    private void renderBlocks(int pass) {
        boolean smoothing;
        if (this.glLists == null) {
            this.glLists = new GLObject[2];
        }
        NGTUtilClient.getMinecraft().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        boolean bl = smoothing = NGTUtilClient.getMinecraft().field_71474_y.field_74348_k != 0;
        if (smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (!GLHelper.isValid(this.glLists[pass])) {
            this.glLists[pass] = GLHelper.generateGLList(this.glLists[pass]);
            GLHelper.startCompile(this.glLists[pass]);
            NGTObjectRenderer.INSTANCE.renderNGTObject(this.world, this.ngto, true, 0, pass);
            GLHelper.endCompile();
        } else {
            GLHelper.callList(this.glLists[pass]);
        }
        if (smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.enableLighting();
        NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
    }

    @Override
    public int getDrawMode() {
        return 0;
    }

    public ArrayList<GroupObject> getGroupObjects() {
        return this.parts;
    }

    @Override
    public Map<String, Material> getMaterials() {
        return this.materials;
    }

    @Override
    public FileType getType() {
        return FileType.NGTO;
    }
}

