/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTZ;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.Material;
import jp.ngt.ngtlib.renderer.model.NGTOModel;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class NGTZModel
implements IModelNGT {
    private final List<NGTOParts> objects = new ArrayList<NGTOParts>();
    private final float scale;
    private final ArrayList<GroupObject> parts = new ArrayList();
    private final Map<String, Material> materials = new HashMap<String, Material>();
    private final float[] sizeBox = new float[6];

    public NGTZModel(ResourceLocation par1, float par2) {
        Map<String, NGTObject> objs = new NGTZ(par1).getObjects();
        this.scale = par2;
        for (Map.Entry<String, NGTObject> set : objs.entrySet()) {
            NGTOParts parts = new NGTOParts(set.getKey(), set.getValue());
            this.objects.add(parts);
            NGTOModel.calcSizeBox(parts.ngto, this.scale, this.sizeBox);
        }
        this.materials.put("default", new Material(0, TextureMap.field_110575_b));
    }

    @Override
    public float[] getSize() {
        return this.sizeBox;
    }

    @Override
    public void renderAll(boolean smoothing) {
        for (NGTOParts obj : this.objects) {
            obj.render(this.scale);
        }
    }

    @Override
    public void renderOnly(boolean smoothing, String ... groupNames) {
        for (NGTOParts obj : this.objects) {
            for (String s : groupNames) {
                if (!s.equals(obj.name)) continue;
                obj.render(this.scale);
            }
        }
    }

    @Override
    public void renderPart(boolean smoothing, String partName) {
        for (NGTOParts obj : this.objects) {
            if (!partName.equals(obj.name)) continue;
            obj.render(this.scale);
        }
    }

    @Override
    public int getDrawMode() {
        return 0;
    }

    public ArrayList<GroupObject> getGroupObjects() {
        return this.parts;
    }

    @Override
    public Map<String, Material> getMaterials() {
        return this.materials;
    }

    @Override
    public FileType getType() {
        return FileType.NGTZ;
    }

    private class NGTOParts {
        private final String name;
        private final NGTObject ngto;
        private GLObject[] glLists;
        private NGTWorld world;

        public NGTOParts(String par1, NGTObject par2) {
            this.name = par1;
            this.ngto = par2;
        }

        public void render(float scale) {
            if (this.world == null) {
                if (NGTUtil.getClientWorld() == null) {
                    return;
                }
                this.world = new NGTWorld(NGTUtil.getClientWorld(), this.ngto);
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            float x = (float)this.ngto.xSize * 0.5f;
            float z = (float)this.ngto.zSize * 0.5f;
            GL11.glTranslatef((float)(-x), (float)0.0f, (float)(-z));
            int pass = MinecraftForgeClient.getRenderPass();
            if (pass == -1) {
                pass = 0;
            }
            NGTObjectRenderer.INSTANCE.renderTileEntities(this.world, 0.0f, pass);
            NGTObjectRenderer.INSTANCE.renderEntities(this.world, 0.0f, pass);
            this.renderBlocks(pass);
            GL11.glPopMatrix();
        }

        private void renderBlocks(int pass) {
            boolean smoothing;
            if (this.glLists == null) {
                this.glLists = new GLObject[2];
            }
            NGTUtilClient.getMinecraft().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            boolean bl = smoothing = NGTUtilClient.getMinecraft().field_71474_y.field_74348_k != 0;
            if (smoothing) {
                GL11.glShadeModel((int)7425);
            }
            if (!GLHelper.isValid(this.glLists[pass])) {
                this.glLists[pass] = GLHelper.generateGLList(this.glLists[pass]);
                GLHelper.startCompile(this.glLists[pass]);
                NGTObjectRenderer.INSTANCE.renderNGTObject(this.world, this.ngto, true, 0, pass);
                GLHelper.endCompile();
            } else {
                GLHelper.callList(this.glLists[pass]);
            }
            if (smoothing) {
                GL11.glShadeModel((int)7424);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLHelper.enableLighting();
            NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
        }
    }
}

