/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.renderer.model;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class Vertex
implements Comparable<Vertex> {
    private static final float ACCURACY = 1.0E-4f;

    public static Vertex create(Vec3 vec, VecAccuracy accuracy) {
        return Vertex.create((float)vec.getX(), (float)vec.getY(), (float)vec.getZ(), accuracy);
    }

    public static Vertex create(float x, float y, float z, VecAccuracy accuracy) {
        switch (accuracy) {
            case LOW: {
                return new VertexShort(x, y, z);
            }
            case MEDIUM: {
                return new VertexFloat(x, y, z);
            }
        }
        return new VertexFloat(x, y, z);
    }

    public Vec3 toVec() {
        return PooledVec3.create(this.getX(), this.getY(), this.getZ());
    }

    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public abstract void setVec(float var1, float var2, float var3);

    public Vertex add(Vertex vertex) {
        this.setVec(this.getX() + vertex.getX(), this.getY() + vertex.getY(), this.getZ() + vertex.getZ());
        return this;
    }

    public Vertex expand(float par1) {
        this.setVec(this.getX() * par1, this.getY() * par1, this.getZ() * par1);
        return this;
    }

    public Vertex copy(VecAccuracy par1) {
        return Vertex.create(this.getX(), this.getY(), this.getZ(), par1);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Vertex) {
            Vertex v = (Vertex)object;
            return Math.abs(this.getX() - v.getX()) < 1.0E-4f && Math.abs(this.getY() - v.getY()) < 1.0E-4f && Math.abs(this.getZ() - v.getZ()) < 1.0E-4f;
        }
        return false;
    }

    public int hashCode() {
        int ix = Float.floatToRawIntBits(this.getX());
        int iy = Float.floatToRawIntBits(this.getY());
        int iz = Float.floatToRawIntBits(this.getZ());
        return (ix & 0xFF) << 16 | (iy & 0xFF) << 8 | iz & 0xFF;
    }

    @Override
    public int compareTo(Vertex arg) {
        if (this == arg) {
            return 0;
        }
        float myF = 0.0f;
        float argF = 0.0f;
        if (this.getX() != arg.getX()) {
            myF = this.getX();
            argF = arg.getX();
        } else if (this.getY() != arg.getY()) {
            myF = this.getY();
            argF = arg.getY();
        } else if (this.getZ() != arg.getZ()) {
            myF = this.getZ();
            argF = arg.getZ();
        } else {
            return 0;
        }
        return (int)(myF * 10.0f - argF * 10.0f);
    }

    private static final class VertexShort
    extends Vertex {
        private short x;
        private short y;
        private short z;

        public VertexShort(float x, float y, float z) {
            this.setVec(x, y, z);
        }

        @Override
        public float getX() {
            return this.decode(this.x);
        }

        @Override
        public float getY() {
            return this.decode(this.y);
        }

        @Override
        public float getZ() {
            return this.decode(this.z);
        }

        @Override
        public void setVec(float p1, float p2, float p3) {
            this.x = this.encode(p1);
            this.y = this.encode(p2);
            this.z = this.encode(p3);
        }

        private short encode(float par1) {
            return (short)NGTMath.floor(par1 * 2000.0f);
        }

        private float decode(short par1) {
            return (float)par1 * 5.0E-4f;
        }
    }

    private static final class VertexFloat
    extends Vertex {
        private float x;
        private float y;
        private float z;

        public VertexFloat(float x, float y, float z) {
            this.setVec(x, y, z);
        }

        @Override
        public float getX() {
            return this.x;
        }

        @Override
        public float getY() {
            return this.y;
        }

        @Override
        public float getZ() {
            return this.z;
        }

        @Override
        public void setVec(float p1, float p2, float p3) {
            this.x = p1;
            this.y = p2;
            this.z = p3;
        }
    }
}

