/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.codec.binary.Base64;

public class NGTCertificate {
    private static boolean KEY_REGISTERED;

    public static boolean canUse() {
        return KEY_REGISTERED;
    }

    public static boolean checkPlayerData(String player) {
        File keyFile = NGTCertificate.getKeyFile();
        if (keyFile.exists()) {
            List<String> list;
            try {
                list = NGTText.readText(keyFile, "");
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (list.size() >= 2) {
                byte[] ba = Base64.decodeBase64((String)list.get(1));
                String s = new String(ba);
                if (player.equals(s) || list.size() == 3 && list.get(2) != null && list.get(2).equals("develop_mode")) {
                    KEY_REGISTERED = true;
                    return true;
                }
                NGTLog.debug("not matched player data : " + s);
            } else {
                NGTLog.debug("illegal file");
            }
        }
        return false;
    }

    public static boolean registerKey(EntityPlayer player, String key) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            String string;
            URL url = new URL("https://dl.dropboxusercontent.com/s/tukcqsaylqfhx7j/key.ngt");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((string = br.readLine()) != null) {
                strings.add(string);
            }
            br.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.0", new Object[0]);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.1", new Object[0]);
            return false;
        }
        if (strings.size() > 0) {
            String[] sa = strings.toArray(new String[strings.size()]);
            if (sa[0] == null || sa[0].equals("unavailable")) {
                NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.2", new Object[0]);
                return false;
            }
            if (sa[0].equals("available")) {
                NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.3", new Object[0]);
                return true;
            }
            if (sa[0].equals(key)) {
                NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.4", new Object[0]);
                return true;
            }
        }
        NGTLog.sendChatMessage((ICommandSender)player, "message.regKey.5", new Object[0]);
        return false;
    }

    public static void writePlayerData(String player) {
        File keyFile = NGTCertificate.getKeyFile();
        if (keyFile.exists()) {
            keyFile.delete();
        }
        String s1 = Base64.encodeBase64String((byte[])NGTCore.metadata.version.getBytes());
        String s2 = Base64.encodeBase64String((byte[])player.getBytes());
        NGTText.writeToText(keyFile, s1 + "\n" + s2);
        KEY_REGISTERED = true;
        NGTCore.proxy.removeGuiWarning();
    }

    private static File getKeyFile() {
        File modsDir = NGTFileLoader.getModsDir().get(0);
        File ngtDir = new File(modsDir, "ngt");
        if (!ngtDir.exists()) {
            ngtDir.mkdir();
        }
        return new File(ngtDir, "data.ngt");
    }
}

