/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.util.IMod;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NGTRegHandler {
    public static final NGTRegHandler INSTANCE = new NGTRegHandler();
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Item> items = new ArrayList<Item>();

    private NGTRegHandler() {
    }

    private static void checkName(String name) {
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name contains ':' -> " + name);
        }
        String lower = name.toLowerCase();
        if (!lower.equals(name)) {
            throw new IllegalArgumentException("Name has upper case letter ':' -> " + name);
        }
    }

    public static <T extends Block> T register(T block, String name, String unlocalizedName, CreativeTabs tab, String modID) {
        return NGTRegHandler.register(block, name, unlocalizedName, tab, null, modID);
    }

    public static <T extends Block> T register(T block, String name, String unlocalizedName, CreativeTabs tab, Class<? extends ItemBlock> itemClass, String modID) {
        NGTRegHandler.checkName(name);
        NGTRegHandler.INSTANCE.blocks.add(block);
        block.setRegistryName(modID, name);
        block.func_149663_c(unlocalizedName);
        if (tab != null) {
            block.func_149647_a(tab);
        }
        ItemBlock item = null;
        if (itemClass != null) {
            try {
                Constructor<? extends ItemBlock> constructor = itemClass.getConstructor(Block.class);
                item = constructor.newInstance(block);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return block;
            }
        } else {
            item = new ItemBlock(block);
        }
        ForgeRegistries.BLOCKS.register(block);
        NGTRegHandler.register(item, name, unlocalizedName, null, modID);
        return block;
    }

    public static <T extends Item> T register(T item, String name, String unlocalizedName, CreativeTabs tab, String modID) {
        NGTRegHandler.checkName(name);
        NGTRegHandler.INSTANCE.items.add(item);
        item.setRegistryName(modID, name);
        item.func_77655_b(unlocalizedName);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    public static void register(Class<? extends Entity> clazz, String regName, String name, int id, int range, int freq, boolean velUpdate, IMod mod) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(mod.getId(), regName), clazz, (String)name, (int)id, (Object)mod, (int)range, (int)freq, (boolean)velUpdate);
    }
}

