/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.util.HashMap;
import java.util.List;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.renderer.BasicRenderFactory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class NGTUtilClient {
    private static byte HAS_SHADER = (byte)-1;

    public static Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(ResourceLocation par1) {
        NGTUtilClient.getMinecraft().func_110434_K().func_110577_a(par1);
    }

    public static int getLightValue(World world, int x, int y, int z) {
        if (world.func_175668_a(new BlockPos(x, 0, z), false)) {
            int block;
            BlockPos pos = new BlockPos(x, y, z);
            int sky = world.func_175642_b(EnumSkyBlock.SKY, pos);
            return sky > (block = world.func_175642_b(EnumSkyBlock.BLOCK, pos)) ? sky : block;
        }
        return 0;
    }

    public static boolean usingShader() {
        if (HAS_SHADER < 0) {
            HAS_SHADER = 0;
            List list = CoreModManager.getReparseableCoremods();
            for (String name : list) {
                if (!name.contains(NGTCore.shaderModName)) continue;
                HAS_SHADER = 1;
                break;
            }
        }
        return HAS_SHADER == 1;
    }

    public static void registerItemModel(Block block, int meta, String domain, String path) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(domain + ":" + path, "inventory"));
    }

    public static <T extends Entity> void registerEntityRender(Class<T> entityClass, Class<? extends Render<? super T>> renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new BasicRenderFactory(renderer));
    }

    public static TextureAtlasSprite getIcon(String name) {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        return texturemap.func_110572_b(name);
    }

    public static void registerBuildinModel(Block block, boolean noItem) {
        ModelLoader.setCustomStateMapper((Block)block, par1 -> new HashMap());
        if (noItem) {
            NGTUtilClient.registerNoModelBlockAsItem(block);
        }
    }

    public static void registerNoModelBlockAsItem(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
    }
}

