/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.ngtlib.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.PackInfo;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class VersionChecker {
    private static final VersionChecker checker = new VersionChecker();
    private List<PackInfo> checkList = new ArrayList<PackInfo>();
    private List<String[]> updateList = new ArrayList<String[]>();
    private boolean finished;

    public static void addToCheckList(PackInfo par1) {
        VersionChecker.checker.checkList.add(par1);
    }

    public static void checkVersion() {
        VersionCheckThread thread = checker.new VersionCheckThread();
        thread.start();
    }

    public static void showUpdateMessage(INetHandlerPlayClient handler) {
        if (VersionChecker.checker.finished) {
            for (String[] sa : VersionChecker.checker.updateList) {
                TextComponentTranslation component = new TextComponentTranslation("message.version", new Object[]{TextFormatting.AQUA + sa[0]});
                component.func_150258_a(" : " + TextFormatting.GREEN + sa[1]);
                if (sa[2] != null && !sa[2].isEmpty()) {
                    TextComponentTranslation component2 = new TextComponentTranslation("  \u00a76\u00a7nDownload here", new Object[0]);
                    component2.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, sa[2])));
                    component.func_150257_a((ITextComponent)component2);
                }
                NGTLog.showChatMessage((ITextComponent)component);
            }
        }
    }

    public class VersionCheckThread
    extends Thread {
        public VersionCheckThread() {
            super("NGT Version Check");
        }

        @Override
        public void run() {
            ArrayList<String> strings = new ArrayList<String>();
            HashMap<String, String> latestVerMap = new HashMap<String, String>();
            for (PackInfo info : checker.checkList) {
                String ver;
                if (latestVerMap.containsKey(info.name) && !info.version.equals(ver = (String)latestVerMap.get(info.name))) {
                    checker.updateList.add(new String[]{info.name, ver, info.homepage});
                    continue;
                }
                String location = info.updateURL;
                if (location == null || location.length() == 0) continue;
                try {
                    URL url = new URL(location);
                    List<String> sList = NGTText.readTextL(url.openStream(), "");
                    strings.addAll(sList);
                }
                catch (MalformedURLException e) {
                    NGTLog.debug("URL:" + location);
                    e.printStackTrace();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                String[] sa1 = strings.toArray(new String[strings.size()]);
                strings.clear();
                for (String s : sa1) {
                    String[] sa2 = s.split(":");
                    if (sa2.length != 2) continue;
                    latestVerMap.put(sa2[0], sa2[1]);
                    if (!info.name.equals(sa2[0]) || info.version.equals(sa2[1])) continue;
                    checker.updateList.add(new String[]{info.name, sa2[1], info.homepage});
                }
            }
            checker.finished = true;
        }
    }
}

