/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.modelpack.RTMResourceManager;
import jp.ngt.rtm.sound.SoundObj;
import net.minecraft.block.SoundType;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.MetadataSerializer;

public final class RTMSound {
    public static final List<String> ALL_OGG_FILES = new ArrayList<String>();
    public static final String EMPTY = "rtm:sounds/none.ogg";
    public static final String LEVER = "rtm:sounds/train/lever.ogg";
    public static final String ATS = "rtm:sounds/train/ats.ogg";
    public static final String ATS_BELL = "rtm:sounds/train/ats_bell.ogg";
    public static final String CP_FIN = "rtm:sounds/train/cp_fin.ogg";
    public static final String JOINT = "rtm:sounds/train/joint.ogg";
    public static final String JOINT_REVERB = "rtm:sounds/train/joint_reverb.ogg";
    public static final String GUN = "rtm:sounds/item/gun.ogg";
    public static final SoundObj BLOCK_METAL = new SoundObj("rtm:block.metal");
    public static final SoundType SOUND_METAL2 = new SoundType(1.0f, 1.0f, BLOCK_METAL.getSound(), BLOCK_METAL.getSound(), BLOCK_METAL.getSound(), BLOCK_METAL.getSound(), BLOCK_METAL.getSound()){
        private float[] pitches = new float[]{0.875f, 0.9375f, 1.0f, 1.0625f, 1.125f};

        public float func_185847_b() {
            return this.pitches[NGTMath.RANDOM.nextInt(this.pitches.length)];
        }
    };

    public static void init() {
    }

    public static void registerSoundDomains() {
        NGTLog.debug((String)"[RTMSound] Register sound domains");
        SimpleReloadableResourceManager rm = (SimpleReloadableResourceManager)NGTUtilClient.getMinecraft().func_110442_L();
        Set domains = rm.func_135055_a();
        ArrayList<File> newDomains = new ArrayList<File>();
        List oggFiles = NGTFileLoader.findFile(file -> file.getName().endsWith(".ogg"));
        ALL_OGG_FILES.clear();
        for (File file2 : oggFiles) {
            File domain = RTMSound.getDomain(file2);
            if (domain == null) continue;
            if (!domains.contains(domain.getName())) {
                newDomains.add(domain);
                domains.add(domain.getName());
            }
            String path = file2.getAbsolutePath();
            String name = path.substring(path.indexOf(domain.getName()) + domain.getName().length() + 1);
            name = name.replace("\\", "/");
            ALL_OGG_FILES.add(domain.getName() + ":" + name);
        }
        Map rmMap = RTMSound.getDomainResourceManagers(rm);
        for (File domain : newDomains) {
            RTMResourceManager rrm = new RTMResourceManager(RTMSound.getMetadataSerializer(rm), domain);
            rmMap.put(domain.getName(), rrm);
            NGTLog.debug((String)("[RTMSound] Add new domain : " + domain.getName()));
        }
    }

    private static File getDomain(File file) {
        if (!file.getAbsolutePath().contains("sounds")) {
            return null;
        }
        while (!file.getName().equals("sounds")) {
            if ((file = file.getParentFile()) != null) continue;
            return null;
        }
        return file.getParentFile();
    }

    private static MetadataSerializer getMetadataSerializer(SimpleReloadableResourceManager par1) {
        return (MetadataSerializer)NGTUtil.getField(SimpleReloadableResourceManager.class, (Object)par1, (String[])new String[]{"rmMetadataSerializer", "field_110547_c"});
    }

    private static Map getDomainResourceManagers(SimpleReloadableResourceManager par1) {
        return (Map)NGTUtil.getField(SimpleReloadableResourceManager.class, (Object)par1, (String[])new String[]{"domainResourceManagers", "field_110548_a"});
    }
}

