/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import java.util.Random;
import jp.ngt.ngtlib.block.BlockCustomWithMeta;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMFluid;
import jp.ngt.rtm.RTMMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFireBrick
extends BlockCustomWithMeta {
    private boolean changeColor;

    public BlockFireBrick(boolean randomTick) {
        super(RTMMaterial.fireproof);
        this.changeColor = randomTick;
        this.func_149675_a(randomTick);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.changeColor ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world.field_72995_K || !(placer instanceof EntityPlayer) || this == RTMBlock.fireBrick || this == RTMBlock.hotStoveBrick) {
            // empty if block
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this == RTMBlock.hotStoveBrick) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int meta = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
            int n = 16 - meta;
            for (int i = 0; i < 6; ++i) {
                int x0 = x + BlockUtil.field_01[i][0];
                int y0 = y + BlockUtil.field_01[i][1];
                int z0 = z + BlockUtil.field_01[i][2];
                Block block = BlockUtil.getBlock((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
                if (block == Blocks.field_150350_a) {
                    if (meta <= 0 || world.field_73012_v.nextInt(n) != 0) continue;
                    BlockUtil.setBlock((World)world, (int)x0, (int)y0, (int)z0, (Block)RTMFluid.furnaceFire, (int)15, (int)2);
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)this, (int)0, (int)2);
                    break;
                }
                if (block == RTMFluid.exhaustGas) {
                    int m0 = BlockUtil.getMetadata((IBlockAccess)world, (int)x0, (int)y0, (int)z0);
                    if (meta >= 15 || m0 <= 0) continue;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)this, (int)(meta + 1), (int)2);
                    BlockUtil.setBlock((World)world, (int)x0, (int)y0, (int)z0, (Block)RTMFluid.exhaustGas, (int)(m0 - 1), (int)2);
                    break;
                }
                if (block != Blocks.field_150353_l || meta >= 15) continue;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)this, (int)(meta + 1), (int)2);
                break;
            }
        }
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }
}

