/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.block.BlockArgHolder;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.block.BlockMachineBase;
import jp.ngt.rtm.block.tileentity.TileEntityTurnstile;
import jp.ngt.rtm.item.ItemInstalledObject;
import jp.ngt.rtm.item.ItemTicket;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTurnstile
extends BlockMachineBase {
    private static final float MAX_Y = 1.5f;

    public BlockTurnstile() {
        super(Material.field_151576_e);
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityTurnstile();
    }

    protected ItemStack getItem(int damage) {
        return new ItemStack(RTMItem.installedObject, 1, (int)ItemInstalledObject.IstlObjType.TURNSTILE.id);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int meta = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
        return BlockTurnstile.canThrough(world, pos) ? field_185506_k : this.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        this.setAABB(this.func_180646_a(state, (IBlockAccess)world, pos));
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        this.setAABB(field_185505_j);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = BlockUtil.getMetadata((IBlockAccess)world, (BlockPos)pos) & 3;
        if (meta != 2 && meta != 0) {
            return new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        int meta = BlockUtil.getMetadata((IBlockAccess)world, (BlockPos)pos) & 3;
        if (meta != 2 && meta != 0) {
            return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
        }
        return side == EnumFacing.EAST || side == EnumFacing.WEST;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return BlockTurnstile.canThrough(world, pos);
    }

    @Override
    public boolean onBlockActivated(BlockArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack;
        int z;
        int y;
        World world = holder.getWorld();
        BlockPos pos = holder.getBlockPos();
        EntityPlayer player = holder.getPlayer();
        int x = pos.func_177958_n();
        if (!this.clickMachine(world, x, y = pos.func_177956_o(), z = pos.func_177952_p(), player) && (itemStack = player.func_184614_ca()) != null && itemStack.func_77973_b() instanceof ItemTicket) {
            this.openGate(world, x, y, z, player);
            if (((ItemTicket)itemStack.func_77973_b()).ticketType != 2) {
                ItemStack itemStack2 = ItemTicket.consumeTicket(itemStack);
                if (!world.field_72995_K && itemStack2 != null) {
                    BlockTurnstile.func_180635_a((World)world, (BlockPos)new BlockPos(x, y + 1, z), (ItemStack)itemStack2);
                }
            }
        }
        return true;
    }

    public void openGate(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityTurnstile tile = (TileEntityTurnstile)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (!tile.canThrough()) {
            tile.setCount(30);
            tile.onActivate();
        }
    }

    public static boolean canThrough(IBlockAccess world, BlockPos pos) {
        TileEntityTurnstile tile = (TileEntityTurnstile)BlockUtil.getTileEntity((IBlockAccess)world, (BlockPos)pos);
        return tile != null ? tile.canThrough() : false;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockTurnstile.canThrough(world, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
    }
}

