/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import jp.ngt.rtm.block.tileentity.TileEntityMovingMachine;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMovingMachine
extends TileEntitySpecialRenderer<TileEntityMovingMachine> {
    private void renderMovingMachine(TileEntityMovingMachine tileEntity, double x, double y, double z, float p5) {
        if (!tileEntity.isCore && tileEntity.hasPair()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GLHelper.disableLighting();
        GLHelper.setLightmapMaxBrightness();
        GL11.glDisable((int)3553);
        if (tileEntity.guideVisibility) {
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawing(1);
            tessellator.setColorRGBA_I(0xFF0000, 255);
            tessellator.addVertex(0.0f, 0.0f, 0.0f);
            tessellator.addVertex((float)tileEntity.pairBlockX, (float)tileEntity.pairBlockY, (float)tileEntity.pairBlockZ);
            tessellator.draw();
        }
        double dx = tileEntity.prevPosX + (tileEntity.posX - tileEntity.prevPosX) * (double)p5;
        double dy = tileEntity.prevPosY + (tileEntity.posY - tileEntity.prevPosY) * (double)p5;
        double dz = tileEntity.prevPosZ + (tileEntity.posZ - tileEntity.prevPosZ) * (double)p5;
        GL11.glTranslatef((float)((float)(dx + 0.5)), (float)((float)(dy + 0.5)), (float)((float)(dz + 0.5)));
        if (tileEntity.guideVisibility) {
            NGTRenderer.renderFrame((float)tileEntity.offsetX, (float)tileEntity.offsetY, (float)tileEntity.offsetZ, (float)tileEntity.width, (float)tileEntity.height, (float)tileEntity.depth, (int)65295, (int)255);
        }
        GL11.glEnable((int)3553);
        GLHelper.enableLighting();
        if (this.setupBrightness(tileEntity)) {
            // empty if block
        }
        this.renderBlocks(tileEntity, p5);
        GL11.glDisable((int)2884);
        GL11.glPopMatrix();
    }

    private boolean setupBrightness(TileEntityMovingMachine tileEntity) {
        int x = NGTMath.floor((double)((double)tileEntity.func_174877_v().func_177958_n() + tileEntity.posX));
        int y = NGTMath.floor((double)((double)tileEntity.func_174877_v().func_177956_o() + tileEntity.posY));
        int z = NGTMath.floor((double)((double)tileEntity.func_174877_v().func_177952_p() + tileEntity.posZ));
        if (BlockUtil.isAir((IBlockAccess)this.func_178459_a(), (int)x, (int)y, (int)z)) {
            int i = tileEntity.func_145831_w().func_175671_l(new BlockPos(x, y, z));
            GLHelper.setBrightness((int)i);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    private void renderBlocks(TileEntityMovingMachine tile, float p2) {
        int pass;
        if (tile.dummyWorld == null || tile.blocksObject == null) {
            return;
        }
        if (tile.glLists == null) {
            tile.glLists = new GLObject[2];
        }
        if ((pass = MinecraftForgeClient.getRenderPass()) == -1) {
            pass = 0;
        }
        NGTWorld world = (NGTWorld)tile.dummyWorld;
        NGTObjectRenderer.INSTANCE.renderTileEntities(world, p2, pass);
        GLHelper.disableLighting();
        this.func_147499_a(TextureMap.field_110575_b);
        if (!GLHelper.isValid((GLObject)tile.glLists[pass])) {
            tile.glLists[pass] = GLHelper.generateGLList((GLObject)tile.glLists[pass]);
            GLHelper.startCompile((GLObject)tile.glLists[pass]);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)world, tile.blocksObject, false, 0, pass);
            GLHelper.endCompile();
        } else {
            GLHelper.callList((GLObject)tile.glLists[pass]);
        }
        GLHelper.enableLighting();
    }

    public void render(TileEntityMovingMachine tileEntity, double p2, double p3, double p4, float p5, int p6, float alpha) {
        this.renderMovingMachine(tileEntity, p2, p3, p4, p5);
    }
}

