/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEffect
extends TileEntityCustom
implements ITickable {
    public static final int Phase1 = 40;
    public static final int Phase2 = 400;
    public static final int Phase3 = 800;
    public static final float Scale = 20.0f;
    public static final float Slope1 = 0.03125f;
    public static final float Slope2 = 0.015625f;
    public static final float Radius = 2.0f;
    public static final float MaxDistance = 128.0f;
    public static final DamageSource nuclearDamage = new DamageSource("nuclear").func_76361_j();
    public int tickCount;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tickCount = nbt.func_74762_e("count");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("count", this.tickCount);
        return nbt;
    }

    public void func_73660_a() {
        if (this.shouldUpdateAsAtomicBomb()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.tickCount > 800) {
                    this.field_145850_b.func_175698_g(this.func_174877_v());
                } else if (this.tickCount > 40 && this.tickCount % 3 == 0) {
                    float f0 = this.tickCount - 40;
                    double flameSize = this.getSigmoid(f0, 0.03125f) * 20.0 * 2.0;
                    double blastSize = this.getLinear(f0);
                    this.doExplosion(flameSize, blastSize);
                }
            }
            ++this.tickCount;
        }
    }

    public boolean shouldUpdateAsAtomicBomb() {
        return this.func_145832_p() == 2;
    }

    private void doExplosion(double flameSize, double blastSize) {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        double tileX = (double)x + 0.5;
        double tileY = (double)y + 0.5;
        double tileZ = (double)z + 0.5;
        if (blastSize > 128.0) {
            blastSize = 128.0;
        }
        double d0 = flameSize * flameSize;
        double d1 = blastSize * blastSize;
        if (this.tickCount < 400 && this.field_145850_b.func_82736_K().func_82766_b("mobGriefing")) {
            int i0 = (int)blastSize;
            int i1 = (int)(blastSize * 2.0);
            int i2 = (int)d0;
            int i3 = (int)d1;
            int i0y = i0;
            int i1y = i1;
            if (y - i0y < 0) {
                i0y = y;
            }
            if (y - i0y + i1y >= 256) {
                i1y = 256 - y + i0y;
            }
            for (int i = 0; i < i1; ++i) {
                for (int j = 0; j < i1y; ++j) {
                    for (int k = 0; k < i1; ++k) {
                        IBlockState state;
                        Block block;
                        int z1;
                        int y1;
                        int x1;
                        int x0 = i - i0;
                        int y0 = j - i0y;
                        int z0 = k - i0;
                        int i4 = x0 * x0 + y0 * y0 + z0 * z0;
                        int flag = 0;
                        if (i4 <= i2) {
                            flag = 1;
                        } else if (i4 <= i3) {
                            flag = 2;
                        }
                        if (flag <= 0 || !this.isChunksExist(x1 = x0 + x, y1 = y0 + y, z1 = z0 + z) || (block = (state = BlockUtil.getBlockState((IBlockAccess)this.func_145831_w(), (int)x1, (int)y1, (int)z1)).func_177230_c()) == Blocks.field_150350_a) continue;
                        float hardness = state.func_185887_b(this.field_145850_b, this.func_174877_v());
                        if (flag == 1) {
                            if (!(hardness >= 0.0f) || !(hardness < 500.0f)) continue;
                            this.setBlock(x1, y1, z1, Blocks.field_150350_a);
                            continue;
                        }
                        if (hardness >= 0.0f && hardness < 0.5f) {
                            if (block == Blocks.field_150480_ab) continue;
                            this.setBlock(x1, y1, z1, Blocks.field_150350_a);
                            if (state.func_185904_a() != Material.field_151585_k && state.func_185904_a() != Material.field_151584_j) continue;
                            this.setBlock(x1, y1, z1, (Block)Blocks.field_150480_ab);
                            continue;
                        }
                        if (block != Blocks.field_150349_c && block != Blocks.field_150458_ak && block != Blocks.field_150391_bh) continue;
                        this.setBlock(x1, y1, z1, Blocks.field_150346_d);
                    }
                }
            }
        }
        double time = (double)(800 - this.tickCount) / 760.0;
        List list = this.field_145850_b.func_72839_b(null, this.getAABB(tileX, tileY, tileZ, blastSize));
        for (Entity entity : list) {
            double distanceSq = entity.func_70092_e(tileX, tileY, tileZ);
            if (!(distanceSq < d1)) continue;
            double dx = entity.field_70165_t - tileX;
            double dy = entity.field_70163_u + (double)entity.func_70047_e() - tileY;
            double dz = entity.field_70161_v - tileZ;
            Vec3 vec3 = PooledVec3.create((double)dx, (double)dy, (double)dz);
            double density = NGTMath.pow((double)0.5, (int)this.getBlockDensity(tileX, tileY, tileZ, vec3));
            double distance = Math.sqrt(distanceSq);
            double d4 = 1.0 - distance / 128.0;
            double d5 = time * density * d4;
            double acceleration = d5 / distance * 2.5;
            float damage = (float)d5 * 10.0f;
            if (damage >= 0.25f) {
                if (distanceSq < d0) {
                    entity.func_70097_a(DamageSource.field_76372_a, damage * 2.0f);
                    entity.func_70015_d(5);
                } else {
                    entity.func_70097_a(nuclearDamage, damage);
                }
            }
            if (!(acceleration > 0.0) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) continue;
            entity.field_70133_I = true;
            entity.field_70159_w += dx * acceleration;
            entity.field_70181_x += dy * acceleration * (double)1.2f;
            entity.field_70179_y += dz * acceleration;
        }
    }

    public double getSigmoid(float x, float a) {
        return (1.0 / (1.0 + Math.pow(Math.E, -x * a)) - 0.5) * 2.0;
    }

    public double getLinear(float x) {
        return x * 0.015625f * 20.0f * 2.0f;
    }

    private AxisAlignedBB getAABB(double x, double y, double z, double size) {
        double minY = y - size;
        double maxY = y + size;
        if (minY < 0.0) {
            minY = 0.0;
        }
        if (maxY > 256.0) {
            maxY = 256.0;
        }
        return new AxisAlignedBB(x - size, minY, z - size, x + size, maxY, z + size);
    }

    private boolean isChunksExist(int x, int y, int z) {
        if (y >= 0 && y < 256) {
            return this.func_145831_w().func_175667_e(new BlockPos(x, y, z));
        }
        return false;
    }

    private int getBlockDensity(double posX, double posY, double posZ, Vec3 par2) {
        Vec3 vec3 = par2.normalize();
        double x0 = vec3.getX();
        double y0 = vec3.getY();
        double z0 = vec3.getZ();
        int i0 = 0;
        while (vec3.length() < par2.length()) {
            int z;
            int y;
            int x = NGTMath.floor((double)(posX + vec3.getX()));
            BlockPos pos = new BlockPos(x, y = NGTMath.floor((double)(posY + vec3.getY())), z = NGTMath.floor((double)(posZ + vec3.getZ())));
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.func_185496_a(state, (IBlockAccess)this.func_145831_w(), pos) != null && block.func_176209_a(state, false)) {
                ++i0;
            }
            vec3 = vec3.add(x0, y0, z0);
        }
        return i0;
    }

    private boolean setBlock(int x, int y, int z, Block block) {
        return BlockUtil.setBlock((World)this.func_145831_w(), (int)x, (int)y, (int)z, (Block)block, (int)0, (int)2);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return this.shouldUpdateAsAtomicBomb() ? Double.POSITIVE_INFINITY : 1024.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

