/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.Mat3;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tileentity.MechanismType;
import jp.ngt.rtm.entity.vehicle.EntityLift;
import jp.ngt.rtm.entity.vehicle.LiftMotion;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.cfg.MechanismConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetMechanism;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicle;
import jp.ngt.rtm.modelpack.modelset.ModelSetWire;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMechanism
extends TileEntityCustom
implements IResourceSelector,
ITickable {
    private static TileEntityMechanism SELECT_TARGET;
    private ResourceState<ModelSetMechanism> state = new ResourceState(RTMResource.MECHANISM, this);
    private ResourceState<ModelSetWire> wireState = new ResourceState(RTMResource.WIRE, this);
    protected EnumFacing side = EnumFacing.UP;
    protected byte dir;
    private BlockPos pulleySource;
    public boolean invertWirePos;
    protected final float[] outputSpeeds = new float[5];
    protected float inputSpeed;
    protected final EnumFacing[][] indexConverter = new EnumFacing[2][6];
    public boolean isPowered;
    protected BlockPos inputSource;
    private boolean needUpdate = true;
    public Vec3 wirePosDst = Vec3.ZERO;
    public Vec3 wirePosSrc = Vec3.ZERO;
    public Vec3 wirePosDstOpposite = Vec3.ZERO;
    private TileEntityMechanism dstMecha;
    private TileEntityMechanism srcMecha;
    public float totalDistance;
    public float distanceOffset;
    public float wirePosAngle;
    public final float[] rotations = new float[6];
    public long prevTime;
    public float wireMove = 0.0f;
    private Vec3 normal;

    public void func_145839_a(NBTTagCompound nbt) {
        boolean isPulley;
        super.func_145839_a(nbt);
        this.state.readFromNBT(nbt.func_74775_l("state"));
        this.side = EnumFacing.func_82600_a((int)nbt.func_74771_c("side"));
        this.dir = nbt.func_74771_c("dir");
        boolean bl = isPulley = this.getType() == MechanismType.PULLEY;
        if (isPulley) {
            int[] pos = nbt.func_74759_k("source");
            if (pos.length == 3) {
                this.pulleySource = new BlockPos(pos[0], pos[1], pos[2]);
            }
            this.invertWirePos = nbt.func_74767_n("invert");
            this.wireState.readFromNBT(nbt.func_74775_l("wire_state"));
        }
        this.needUpdate = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("state", (NBTBase)this.state.writeToNBT());
        nbt.func_74774_a("side", (byte)this.side.func_176745_a());
        nbt.func_74774_a("dir", this.dir);
        if (this.getType() == MechanismType.PULLEY) {
            if (this.pulleySource != null) {
                int[] pos = new int[]{this.pulleySource.func_177958_n(), this.pulleySource.func_177956_o(), this.pulleySource.func_177952_p()};
                nbt.func_74783_a("source", pos);
            }
            nbt.func_74757_a("invert", this.invertWirePos);
            nbt.func_74782_a("wire_state", (NBTBase)this.wireState.writeToNBT());
        }
        return nbt;
    }

    public void func_73660_a() {
        if (this.needUpdate) {
            this.calcIndex();
            this.needUpdate = false;
            if (this.getType() == MechanismType.PULLEY) {
                this.needUpdate = !this.calcWirePos();
            }
        }
        this.updateSpeed();
    }

    private void updateSpeed() {
        MechanismConfig cfg = (MechanismConfig)this.getResourceState().getResourceSet().getConfig();
        MechanismType type = this.getType();
        boolean powered = false;
        if (cfg.useRedstonePower) {
            powered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        }
        this.isPowered = powered;
        this.inputSpeed = this.getInput(type);
        this.setOutputs(type, this.inputSpeed, powered);
    }

    private float getInput(MechanismType type) {
        float speed;
        MechanismConfig cfg = (MechanismConfig)this.getResourceState().getResourceSet().getConfig();
        if (type == MechanismType.POWER) {
            return cfg.maxSpeed;
        }
        if (type == MechanismType.GEAR) {
            float speed2;
            if (cfg.radius > 0.0f && (speed2 = this.getGearInput()) != 0.0f) {
                return speed2;
            }
        } else if (type == MechanismType.PULLEY && cfg.radius > 0.0f && (speed = this.getPulleyInput()) != 0.0f) {
            return speed;
        }
        return this.getBackInput();
    }

    private float getBackInput() {
        BlockPos pos = this.func_174877_v();
        pos = pos.func_177972_a(this.side.func_176734_d());
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        if (tileEntity instanceof TileEntityMechanism) {
            return ((TileEntityMechanism)tileEntity).getOutput(this.side);
        }
        return 0.0f;
    }

    private float getGearInput() {
        BlockPos pos = this.func_174877_v();
        this.inputSource = null;
        for (int i = 0; i < 4; ++i) {
            float ratio;
            float sideOutput;
            EnumFacing facing = this.indexConverter[0][i + 2];
            BlockPos sidePos = pos.func_177972_a(facing);
            TileEntity tileEntity = this.func_145831_w().func_175625_s(sidePos);
            if (!(tileEntity instanceof TileEntityMechanism)) continue;
            TileEntityMechanism sideMecha = (TileEntityMechanism)tileEntity;
            MechanismType sideType = this.getType();
            if (sideType != MechanismType.GEAR || sideMecha.inputSource != null && sideMecha.inputSource.equals((Object)pos) || this.side.func_176740_k() != sideMecha.side.func_176740_k() || (sideOutput = sideMecha.getOutputRaw(1)) == 0.0f || !((ratio = this.calcGearRatio(sideMecha, this)) > 0.0f)) continue;
            this.inputSource = sidePos;
            return -sideOutput * ratio;
        }
        return 0.0f;
    }

    private float getPulleyInput() {
        TileEntity tileEntity;
        this.inputSource = null;
        if (this.pulleySource != null && !this.isConnectedToPlayer() && (tileEntity = this.func_145831_w().func_175625_s(this.pulleySource)) instanceof TileEntityMechanism) {
            float ratio;
            TileEntityMechanism source = (TileEntityMechanism)tileEntity;
            if (source.inputSource != null && source.inputSource.equals((Object)this.func_174877_v())) {
                return 0.0f;
            }
            float speed = source.getOutputRaw(1);
            if (speed != 0.0f && (ratio = this.calcGearRatio(source, this)) > 0.0f) {
                this.inputSource = this.pulleySource;
                return speed * ratio;
            }
        }
        return 0.0f;
    }

    private float calcGearRatio(TileEntityMechanism src, TileEntityMechanism dst) {
        float srcR = ((MechanismConfig)src.getResourceState().getResourceSet().getConfig()).radius;
        float dstR = ((MechanismConfig)dst.getResourceState().getResourceSet().getConfig()).radius;
        return srcR > 0.0f && dstR > 0.0f ? srcR / dstR : 0.0f;
    }

    private void setOutputs(MechanismType type, float speed, boolean powered) {
        MechanismConfig cfg = (MechanismConfig)this.getResourceState().getResourceSet().getConfig();
        float[] ratio = powered ? cfg.transmissionRatioON : cfg.transmissionRatioOFF;
        for (int i = 0; i < this.outputSpeeds.length; ++i) {
            float output;
            if (type == MechanismType.POWER) {
                float target = speed * ratio[i];
                float acceleration = cfg.acceleration;
                float currentSpeed = this.outputSpeeds[i];
                if (currentSpeed < target) {
                    if ((currentSpeed += acceleration) > target) {
                        currentSpeed = target;
                    }
                } else if (currentSpeed > target && (currentSpeed -= acceleration) < target) {
                    currentSpeed = target;
                }
                output = currentSpeed;
            } else {
                output = speed * ratio[i];
                if (this.invertWirePos) {
                    output *= -1.0f;
                }
            }
            this.outputSpeeds[i] = output;
        }
    }

    public float getOutput(EnumFacing facing) {
        int index = this.convertFace(facing).func_176745_a();
        return this.getOutputRaw(index);
    }

    public float getOutputRaw(int index) {
        float speed = 0.0f;
        switch (index) {
            case 0: {
                speed = this.inputSpeed;
                break;
            }
            case 1: {
                speed = this.outputSpeeds[0];
                break;
            }
            case 2: {
                speed = this.outputSpeeds[3];
                break;
            }
            case 3: {
                speed = this.outputSpeeds[1];
                break;
            }
            case 4: {
                speed = this.outputSpeeds[2];
                break;
            }
            case 5: {
                speed = this.outputSpeeds[4];
            }
        }
        return speed;
    }

    public EnumFacing convertFace(EnumFacing face) {
        EnumFacing facing = this.indexConverter[1][face.func_176745_a()];
        return facing == null ? EnumFacing.UP : facing;
    }

    private void calcIndex() {
        Mat3 mat = Mat3.IDENTITY;
        switch (this.side) {
            case DOWN: {
                mat = mat.rotateAroundX(180.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                mat = mat.rotateAroundX(90.0f);
                mat = mat.rotateAroundZ(180.0f);
                break;
            }
            case SOUTH: {
                mat = mat.rotateAroundX(90.0f);
                break;
            }
            case WEST: {
                mat = mat.rotateAroundX(90.0f);
                mat = mat.rotateAroundZ(90.0f);
                break;
            }
            case EAST: {
                mat = mat.rotateAroundX(90.0f);
                mat = mat.rotateAroundZ(-90.0f);
            }
        }
        mat = mat.rotateAroundY((float)this.dir * 90.0f);
        for (int i = 0; i < 6; ++i) {
            Vec3 vec = null;
            switch (i) {
                case 0: 
                case 1: {
                    vec = mat.getY();
                    break;
                }
                case 2: 
                case 3: {
                    vec = mat.getZ();
                    break;
                }
                case 4: 
                case 5: {
                    vec = mat.getX();
                }
            }
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)vec.getX()), (float)((float)vec.getY()), (float)((float)vec.getZ()));
            if (i % 2 == 0) {
                facing = facing.func_176734_d();
            }
            this.indexConverter[0][i] = facing;
            this.indexConverter[1][facing.func_176745_a()] = EnumFacing.func_82600_a((int)i);
        }
    }

    private boolean calcWirePos() {
        Vec3 spfNrm;
        double len0;
        Vec3 v0;
        float srcInvert;
        if (this.isConnectedToPlayer() || this.pulleySource == null) {
            return true;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.pulleySource);
        if (!(tileEntity instanceof TileEntityMechanism)) {
            return false;
        }
        TileEntityMechanism source = (TileEntityMechanism)tileEntity;
        EnumFacing dstSide = this.side;
        EnumFacing srcSide = source.side;
        Vec3 dstNormal = this.getPulleyNormal();
        Vec3 srcNormal = source.getPulleyNormal();
        float dstR = ((MechanismConfig)this.getResourceState().getResourceSet().getConfig()).radius;
        float srcR = ((MechanismConfig)source.getResourceState().getResourceSet().getConfig()).radius;
        double dx = source.getX() - this.getX();
        double dy = source.getY() - this.getY();
        double dz = source.getZ() - this.getZ();
        Vec3 srcPos = new Vec3((double)(source.getX() - this.getX()), (double)(source.getY() - this.getY()), (double)(source.getZ() - this.getZ()));
        float dstInvert = this.invertWirePos ? 1.0f : -1.0f;
        float f = srcInvert = source.invertWirePos ? 1.0f : -1.0f;
        if (dstSide.func_176740_k() == srcSide.func_176740_k()) {
            v0 = new Vec3(srcPos.getX() * dstNormal.getX(), srcPos.getY() * dstNormal.getY(), srcPos.getZ() * dstNormal.getZ());
            Vec3 srcPosFix = srcPos.sub(v0);
            len0 = srcPosFix.length();
            float ang0 = (float)NGTMath.toDegrees((double)Math.acos((double)(dstR - srcR) / len0));
            spfNrm = srcPosFix.normalize();
            Vec3 dstRV = spfNrm.rotateAroundVec(dstNormal, ang0 * dstInvert).multi((double)dstR);
            Vec3 srcRV = spfNrm.rotateAroundVec(srcNormal, ang0 * srcInvert).multi((double)srcR);
            this.wirePosDst = dstRV;
            this.wirePosSrc = srcRV.add(srcPos);
            source.wirePosDstOpposite = srcRV;
        } else {
            v0 = new Vec3(srcPos.getX() * dstNormal.getX(), srcPos.getY() * dstNormal.getY(), srcPos.getZ() * dstNormal.getZ());
            Vec3 srcPosFix = srcPos.sub(v0);
            len0 = srcPosFix.length();
            float ang0 = (float)NGTMath.toDegrees((double)Math.acos((double)dstR / len0));
            spfNrm = srcPosFix.normalize();
            Vec3 dstRV = spfNrm.rotateAroundVec(dstNormal, ang0 * dstInvert).multi((double)dstR);
            Vec3 v1 = new Vec3(srcPos.getX() * srcNormal.getX(), srcPos.getY() * srcNormal.getY(), srcPos.getZ() * srcNormal.getZ());
            Vec3 dstPosFix = srcPos.sub(v1);
            double len1 = dstPosFix.length();
            float ang1 = (float)NGTMath.toDegrees((double)Math.acos((double)srcR / len1));
            Vec3 dpfNrm = dstPosFix.normalize();
            Vec3 srcRV = dpfNrm.rotateAroundVec(srcNormal, ang1 * srcInvert).multi((double)srcR);
            this.wirePosDst = dstRV;
            this.wirePosSrc = srcRV.add(srcPos);
            source.wirePosDstOpposite = srcRV;
        }
        double circumference = Math.PI * 2 * (double)((MechanismConfig)this.getResourceState().getResourceSet().getConfig()).radius;
        float totalAngle = this.wirePosDst.getAngle360(this.wirePosDstOpposite, this.getPulleyNormal()) + 180.0f;
        double len02 = circumference * (double)(Math.abs(totalAngle) / 360.0f);
        double len1 = this.wirePosDst.sub(this.wirePosSrc).length();
        this.distanceOffset = (float)(-len1);
        this.totalDistance = (float)(len02 + len1);
        this.srcMecha = source;
        source.dstMecha = this;
        EnumFacing faceZ = this.indexConverter[0][EnumFacing.SOUTH.func_176745_a()];
        Vec3 vecZ = new Vec3((double)faceZ.func_82601_c(), (double)faceZ.func_96559_d(), (double)faceZ.func_82599_e());
        this.wirePosAngle = vecZ.getAngle360(this.wirePosDst, this.getPulleyNormal());
        return true;
    }

    public Vec3 getPulleyNormal() {
        if (this.normal == null) {
            this.normal = new Vec3((double)this.side.func_82601_c(), (double)this.side.func_96559_d(), (double)this.side.func_82599_e());
        }
        return this.normal;
    }

    public boolean isConnectedToPlayer() {
        return this.pulleySource != null && this.pulleySource.func_177956_o() == 0;
    }

    public void onRightClick(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            Item heldItem = player.func_184614_ca().func_77973_b();
            if (heldItem == RTMItem.itemWire && this.getType() == MechanismType.PULLEY) {
                if (SELECT_TARGET == null) {
                    SELECT_TARGET = this;
                    this.setInputSource(new BlockPos(player.func_145782_y(), 0, 0), player.func_184614_ca());
                    NGTLog.sendChatMessageToAll((String)"Select target pulley.", (Object[])new Object[0]);
                } else {
                    SELECT_TARGET.setInputSource(this.func_174877_v(), player.func_184614_ca());
                    NGTLog.sendChatMessageToAll((String)String.format("Set target pulley (%s)", TileEntityMechanism.SELECT_TARGET.pulleySource.toString()), (Object[])new Object[0]);
                    SELECT_TARGET = null;
                }
            } else {
                if (this.getType() == MechanismType.PULLEY) {
                    this.invertWirePos ^= true;
                    if (this.dstMecha != null) {
                        this.dstMecha.sendPacket();
                    }
                    if (this.srcMecha != null) {
                        this.srcMecha.sendPacket();
                    }
                } else {
                    this.dir = (byte)((this.dir + 1) % 4);
                }
                this.needUpdate = true;
                this.sendPacket();
            }
        }
    }

    private void setInputSource(BlockPos pos, ItemStack item) {
        ResourceState state = ((ItemWithModel)item.func_77973_b()).getModelState(item);
        this.wireState.readFromNBT(state.writeToNBT());
        this.pulleySource = pos;
        this.needUpdate = true;
        this.sendPacket();
    }

    public BlockPos getPulleySource() {
        return this.pulleySource;
    }

    public void setSide(int par1) {
        this.side = EnumFacing.func_82600_a((int)par1);
        this.needUpdate = true;
    }

    public LiftMotion getMotion(EntityLift lift, double moveDistance, int timeDif) {
        float pitch;
        float yaw;
        Vec3 pos;
        double circumference;
        double moveR = (double)this.getOutputRaw(0) * ((double)timeDif / 60000.0);
        if ((moveDistance -= moveR * (circumference = Math.PI * 2 * (double)((MechanismConfig)this.getResourceState().getResourceSet().getConfig()).radius)) < 0.0) {
            if (moveDistance < (double)this.distanceOffset && this.srcMecha != null && this.srcMecha != this) {
                double move2 = (double)(this.srcMecha.totalDistance + this.srcMecha.distanceOffset) + (moveDistance - (double)this.distanceOffset);
                return this.srcMecha.getMotion(lift, move2, 0);
            }
            double moveAbs = moveDistance - (double)this.distanceOffset;
            Vec3 moveVec = this.wirePosDst.sub(this.wirePosSrc).multi(moveAbs / (double)(-this.distanceOffset));
            pos = moveVec.add(this.wirePosSrc);
            yaw = moveVec.getYaw();
            pitch = moveVec.getPitch();
        } else if (moveDistance > 0.0) {
            double arcLen = this.totalDistance + this.distanceOffset;
            if (moveDistance > arcLen && this.dstMecha != null && this.dstMecha != this) {
                double move2 = (double)this.dstMecha.distanceOffset + (moveDistance - arcLen);
                return this.dstMecha.getMotion(lift, move2, 0);
            }
            double moveAngle = 360.0 * (moveDistance / circumference);
            pos = this.wirePosDst.rotateAroundVec(this.getPulleyNormal(), (float)(-moveAngle));
            Vec3 moveVec = pos.rotateAroundVec(this.getPulleyNormal(), -90.0f);
            yaw = moveVec.getYaw();
            pitch = moveVec.getPitch();
        } else {
            pos = this.wirePosDst;
            Vec3 moveVec = pos.rotateAroundVec(this.getPulleyNormal(), -90.0f);
            yaw = moveVec.getYaw();
            pitch = moveVec.getPitch();
        }
        float[] gripPos = ((VehicleConfig)((ModelSetVehicle)lift.getResourceState().getResourceSet()).getConfig()).gripPos;
        pos = pos.add((double)this.getX() + 0.5 - (double)gripPos[0], (double)this.getY() + 0.5 - (double)gripPos[1], (double)this.getZ() + 0.5 - (double)gripPos[2]);
        return new LiftMotion(pos, yaw, pitch, (float)moveDistance, this);
    }

    public ResourceState<ModelSetWire> getWireState() {
        return this.wireState;
    }

    public MechanismType getType() {
        return ((MechanismConfig)this.getResourceState().getResourceSet().getConfig()).type;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public ResourceState<ModelSetMechanism> getResourceState() {
        return this.state;
    }

    @Override
    public void updateResourceState() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.sendPacket();
            this.func_70296_d();
            BlockUtil.markBlockForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }
}

