/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTOUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.world.NGTWorld;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.EntityMMBoundingBox;
import jp.ngt.rtm.entity.vehicle.EntityCar;
import jp.ngt.rtm.entity.vehicle.EntityPlane;
import jp.ngt.rtm.entity.vehicle.EntityShip;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.VehicleNGTO;
import jp.ngt.rtm.network.PacketMoveMM;
import jp.ngt.rtm.network.PacketNotice;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMovingMachine
extends TileEntityCustom
implements ITickable {
    public boolean guideVisibility = true;
    public int width;
    public int height;
    public int depth;
    public int offsetX;
    public int offsetY;
    public int offsetZ;
    public VehicleNGTO vngto = new VehicleNGTO(null, 0.5f, 0.5f, 0.5f, 1.0f);
    public float speed = 0.0625f;
    public int pairBlockX;
    public int pairBlockY;
    public int pairBlockZ;
    public boolean isCore;
    public double posX;
    public double posY;
    public double posZ;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public byte moveDir;
    private double motionX;
    private double motionY;
    private double motionZ;
    private List<EntityMMBoundingBox> bbList = new ArrayList<EntityMMBoundingBox>();
    private int[] bbIds;
    public NGTObject blocksObject;
    @SideOnly(value=Side.CLIENT)
    public World dummyWorld;
    @SideOnly(value=Side.CLIENT)
    public GLObject[] glLists;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isCore = nbt.func_74767_n("IsCore");
        int[] ia0 = nbt.func_74759_k("Range");
        this.width = ia0[0];
        this.height = ia0[1];
        this.depth = ia0[2];
        int[] ia2 = nbt.func_74759_k("Offset");
        this.offsetX = ia2[0];
        this.offsetY = ia2[1];
        this.offsetZ = ia2[2];
        this.vngto = VehicleNGTO.readFromNBT(nbt.func_74775_l("VNGTO"), true);
        int[] ia1 = nbt.func_74759_k("PairBlock");
        this.pairBlockX = ia1[0];
        this.pairBlockY = ia1[1];
        this.pairBlockZ = ia1[2];
        this.speed = nbt.func_74760_g("Speed");
        this.posX = nbt.func_74769_h("PosX");
        this.posY = nbt.func_74769_h("PosY");
        this.posZ = nbt.func_74769_h("PosZ");
        this.moveDir = nbt.func_74771_c("MoveDir");
        this.guideVisibility = nbt.func_74767_n("GuideVisibility");
        if (this.field_145850_b == null && this.moveDir != 0 && nbt.func_74764_b("NGTO")) {
            this.blocksObject = NGTObject.readFromNBT((NBTTagCompound)nbt.func_74775_l("NGTO"));
            this.moveDir = (byte)-2;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.func_145831_w() == null || !this.func_145831_w().field_72995_K) {
            this.sendPacket();
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("IsCore", this.isCore);
        nbt.func_74783_a("Range", new int[]{this.width, this.height, this.depth});
        nbt.func_74783_a("Offset", new int[]{this.offsetX, this.offsetY, this.offsetZ});
        nbt.func_74782_a("VNGTO", (NBTBase)this.vngto.writeToNBT());
        nbt.func_74783_a("PairBlock", new int[]{this.pairBlockX, this.pairBlockY, this.pairBlockZ});
        nbt.func_74776_a("Speed", this.speed);
        nbt.func_74780_a("PosX", this.posX);
        nbt.func_74780_a("PosY", this.posY);
        nbt.func_74780_a("PosZ", this.posZ);
        nbt.func_74774_a("MoveDir", this.moveDir);
        nbt.func_74757_a("GuideVisibility", this.guideVisibility);
        if (this.moveDir != 0 && this.blocksObject != null) {
            nbt.func_74782_a("NGTO", (NBTBase)this.blocksObject.writeToNBT());
        }
        return nbt;
    }

    public void func_73660_a() {
        if (!this.isCore) {
            return;
        }
        if (this.moveDir == 1 || this.moveDir == -1) {
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            boolean flag = false;
            if (this.moveDir == 1) {
                if (Math.abs(this.posX) > (double)Math.abs(this.pairBlockX)) {
                    this.posX = this.pairBlockX;
                    flag = true;
                }
                if (Math.abs(this.posY) > (double)Math.abs(this.pairBlockY)) {
                    this.posY = this.pairBlockY;
                    flag = true;
                }
                if (Math.abs(this.posZ) > (double)Math.abs(this.pairBlockZ)) {
                    this.posZ = this.pairBlockZ;
                    flag = true;
                }
            } else {
                if (Math.abs((double)this.pairBlockX - this.posX) > (double)Math.abs(this.pairBlockX)) {
                    this.posX = 0.0;
                    flag = true;
                }
                if (Math.abs((double)this.pairBlockY - this.posY) > (double)Math.abs(this.pairBlockY)) {
                    this.posY = 0.0;
                    flag = true;
                }
                if (Math.abs((double)this.pairBlockZ - this.posZ) > (double)Math.abs(this.pairBlockZ)) {
                    this.posZ = 0.0;
                    flag = true;
                }
            }
            this.moveEntities();
            if (flag && !this.field_145850_b.field_72995_K) {
                this.setMovement((byte)0);
            }
        } else if (this.moveDir == -2) {
            this.moveDir = 0;
            this.editBlock(1);
            this.onBlockChanged();
        }
    }

    private void moveEntities() {
        if (!this.field_145850_b.field_72995_K) {
            double mX = this.posX - this.prevPosX;
            double mY = this.posY - this.prevPosY;
            double mZ = this.posZ - this.prevPosZ;
            for (int pass = 0; pass < 2; ++pass) {
                block5: for (int i = 0; i < this.bbList.size(); ++i) {
                    EntityMMBoundingBox entity = this.bbList.get(i);
                    switch (pass) {
                        case 0: {
                            entity.func_70107_b(entity.field_70165_t + mX, entity.field_70163_u + mY, entity.field_70161_v + mZ);
                            continue block5;
                        }
                        case 1: {
                            entity.moveMM(mX, mY, mZ);
                        }
                    }
                }
            }
            if (this.bbIds != null) {
                RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketMoveMM(this.bbIds, mX, mY, mZ));
            }
        }
    }

    public void onBlockChanged() {
        boolean be;
        if (!this.hasPair()) {
            return;
        }
        if (!this.isCore) {
            this.getCore().onBlockChanged();
        }
        byte md = 0;
        boolean bs = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        boolean bl = be = this.field_145850_b.func_175687_A(this.func_174877_v().func_177982_a(this.pairBlockX, this.pairBlockY, this.pairBlockZ)) > 0;
        md = be && !bs ? (byte)1 : (bs && !be ? (byte)-1 : 0);
        if (this.moveDir != md) {
            this.setMovement(md);
        }
    }

    public void setMovement(byte par1) {
        this.moveDir = par1;
        if (par1 == 0) {
            this.motionZ = 0.0;
            this.motionY = 0.0;
            this.motionX = 0.0;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.editBlock(1);
        } else {
            Vec3 vec = PooledVec3.create((double)this.pairBlockX, (double)this.pairBlockY, (double)this.pairBlockZ).normalize();
            double d0 = par1 == 1 ? 1.0 : -1.0;
            this.motionX = vec.getX() * (double)this.speed * d0;
            this.motionY = vec.getY() * (double)this.speed * d0;
            this.motionZ = vec.getZ() * (double)this.speed * d0;
            this.editBlock(0);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendPacket();
            this.func_70296_d();
            String s = "MM," + par1;
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, s, (TileEntity)this));
        }
    }

    private void editBlock(int mode) {
        if (mode == 1 && this.blocksObject == null) {
            return;
        }
        ArrayList list = new ArrayList();
        ArrayList aabbList = new ArrayList();
        int x0 = this.func_174877_v().func_177958_n() + (int)this.posX + 1;
        int y0 = this.func_174877_v().func_177956_o() + (int)this.posY + 1;
        int z0 = this.func_174877_v().func_177952_p() + (int)this.posZ + 1;
        AABBInt box = new AABBInt(this.width, this.height, this.depth);
        int pass = 0;
        while (pass < 2) {
            int passF = pass++;
            box.repeat((i, j, k, count) -> {
                int x = x0 + i;
                int y = y0 + j;
                int z = z0 + k;
                if (mode == 0) {
                    if (passF == 0) {
                        list.add(this.getBlockSet(x, y, z));
                        if (!this.field_145850_b.field_72995_K) {
                            BlockPos pos = new BlockPos(x, y, z);
                            IBlockState state = this.field_145850_b.func_180495_p(pos);
                            Block block = state.func_177230_c();
                            int meta = block.func_176201_c(state);
                            AxisAlignedBB aabb = null;
                            if (block instanceof BlockLargeRailBase) {
                                aabbList.clear();
                                block.func_185477_a(state, this.field_145850_b, pos, new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0), aabbList, null, false);
                                if (!aabbList.isEmpty()) {
                                    aabb = (AxisAlignedBB)aabbList.get(0);
                                }
                            } else {
                                aabb = block.func_185496_a(state, (IBlockAccess)this.field_145850_b, pos);
                            }
                            if (block.func_176209_a(state, false) && aabb != null) {
                                aabb = aabb.func_72317_d((double)(-x), (double)(-y), (double)(-z));
                                boolean b = BlockUtil.getBlock((IBlockAccess)this.func_145831_w(), (int)x, (int)(y + 1), (int)z) == Blocks.field_150350_a;
                                EntityMMBoundingBox entity = new EntityMMBoundingBox(this.field_145850_b, this, b);
                                entity.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
                                entity.setAABB(aabb);
                                this.field_145850_b.func_72838_d((Entity)entity);
                                this.bbList.add(entity);
                            }
                        }
                    } else if (!this.field_145850_b.field_72995_K) {
                        BlockUtil.setAir((World)this.func_145831_w(), (int)x, (int)y, (int)z);
                    }
                } else if (passF == 0 && !this.field_145850_b.field_72995_K) {
                    BlockSet set = (BlockSet)this.blocksObject.blockList.get(count);
                    this.setBlockSet(set, x, y, z);
                }
            });
        }
        if (!this.field_145850_b.field_72995_K && mode == 1) {
            for (EntityMMBoundingBox entity : this.bbList) {
                entity.func_70106_y();
            }
            this.bbList.clear();
            this.bbIds = null;
        }
        if (mode == 0) {
            this.blocksObject = NGTObject.createNGTO(list, (int)this.width, (int)this.height, (int)this.depth, (int)x0, (int)y0, (int)z0);
            if (this.field_145850_b.field_72995_K) {
                this.setNewDummyWorld();
            } else {
                int size = this.bbList.size();
                this.bbIds = new int[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    this.bbIds[i2] = this.bbList.get(i2).func_145782_y();
                }
            }
        } else {
            this.blocksObject = null;
            if (this.field_145850_b.field_72995_K && this.glLists != null) {
                GLHelper.deleteGLList((GLObject)this.glLists[0]);
                GLHelper.deleteGLList((GLObject)this.glLists[1]);
                this.glLists = null;
                this.dummyWorld = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setNewDummyWorld() {
        int x = this.func_174877_v().func_177958_n() + 1 + (int)this.posX;
        int y = this.func_174877_v().func_177956_o() + 1 + (int)this.posY;
        int z = this.func_174877_v().func_177952_p() + 1 + (int)this.posZ;
        this.dummyWorld = new NGTWorld(NGTUtil.getClientWorld(), this.blocksObject, x, y, z);
    }

    private BlockSet getBlockSet(int x, int y, int z) {
        return BlockSet.getBlockSet((World)this.func_145831_w(), (int)x, (int)y, (int)z, (boolean)false);
    }

    private void setBlockSet(BlockSet set, int x, int y, int z) {
        TileEntity tile;
        BlockPos pos = new BlockPos(x, y, z);
        BlockUtil.setBlock((World)this.func_145831_w(), (BlockPos)pos, (Block)set.block, (int)set.metadata, (int)3);
        if (set.block.hasTileEntity(this.func_145831_w().func_180495_p(pos)) && (tile = this.field_145850_b.func_175625_s(pos)) != null) {
            int prevX = 0;
            int prevY = 0;
            int prevZ = 0;
            if (set.nbt != null) {
                NBTTagCompound nbt0 = set.nbt.func_74737_b();
                prevX = nbt0.func_74762_e("x");
                prevY = nbt0.func_74762_e("y");
                prevZ = nbt0.func_74762_e("z");
                nbt0.func_74768_a("x", x);
                nbt0.func_74768_a("y", y);
                nbt0.func_74768_a("z", z);
                tile.func_145839_a(nbt0);
            }
            if (tile instanceof TileEntityCustom) {
                ((TileEntityCustom)tile).setPos(x, y, z, prevX, prevY, prevZ);
            } else {
                tile.func_174878_a(pos);
            }
        }
    }

    public void setData(int p1, int p2, int p3, int ox, int oy, int oz, float p4, boolean p5) {
        this.width = p1;
        this.height = p2;
        this.depth = p3;
        this.offsetX = ox;
        this.offsetY = oy;
        this.offsetZ = oz;
        this.speed = p4;
        this.guideVisibility = p5;
        this.sendPacket();
        this.func_70296_d();
    }

    public boolean hasPair() {
        return this.pairBlockX != 0 || this.pairBlockY != 0 || this.pairBlockZ != 0;
    }

    public TileEntityMovingMachine getPair() {
        BlockPos pos = this.func_174877_v().func_177982_a(this.pairBlockX, this.pairBlockY, this.pairBlockZ);
        return (TileEntityMovingMachine)this.field_145850_b.func_175625_s(pos);
    }

    public void setPair(TileEntityMovingMachine par1) {
        this.pairBlockX = par1.func_174877_v().func_177958_n() - this.func_174877_v().func_177958_n();
        this.pairBlockY = par1.func_174877_v().func_177956_o() - this.func_174877_v().func_177956_o();
        this.pairBlockZ = par1.func_174877_v().func_177952_p() - this.func_174877_v().func_177952_p();
        this.sendPacket();
        this.func_70296_d();
    }

    public void searchMM(int x, int y, int z) {
        int range = 128;
        for (int i = -range; i < range; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = -range; k < range; ++k) {
                    TileEntityMovingMachine tile;
                    BlockPos pos;
                    if (i == 0 && j == y && k == 0 || this.field_145850_b.func_180495_p(pos = new BlockPos(x + i, j, z + k)).func_177230_c() != RTMBlock.movingMachine || (tile = (TileEntityMovingMachine)this.field_145850_b.func_175625_s(pos)).hasPair()) continue;
                    this.isCore = true;
                    this.setPair(tile);
                    tile.setPair(this);
                    return;
                }
            }
        }
    }

    public TileEntityMovingMachine getCore() {
        return this.isCore || !this.hasPair() ? this : this.getPair();
    }

    public void reset(boolean par1) {
        TileEntityMovingMachine tile;
        if (par1 && this.hasPair() && (tile = this.getPair()) != null) {
            tile.reset(false);
        }
        this.isCore = false;
        this.pairBlockZ = 0;
        this.pairBlockY = 0;
        this.pairBlockX = 0;
        this.posZ = 0.0;
        this.posY = 0.0;
        this.posX = 0.0;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.sendPacket();
        this.func_70296_d();
    }

    public void generateVehicle(EntityPlayer player) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        int startX = this.getX() + 1 + this.offsetX;
        int startY = this.getY() + 1 + this.offsetY;
        int startZ = this.getZ() + 1 + this.offsetZ;
        NGTObject ngto = NGTOUtil.copyBlocks((World)this.func_145831_w(), (int)startX, (int)startY, (int)startZ, (int)this.width, (int)this.height, (int)this.depth);
        AABBInt box = new AABBInt(this.width, this.height, this.depth);
        box.repeat((i, j, k, c) -> this.func_145831_w().func_175698_g(new BlockPos(startX + i, startY + j, startZ + k)));
        EntityVehicle vehicle = null;
        switch (this.vngto.type) {
            case 0: {
                vehicle = new EntityCar(this.func_145831_w());
                break;
            }
            case 1: {
                vehicle = new EntityShip(this.func_145831_w());
                break;
            }
            case 2: {
                vehicle = new EntityPlane(this.func_145831_w());
                break;
            }
            default: {
                vehicle = new EntityCar(this.func_145831_w());
            }
        }
        vehicle.func_70634_a((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
        this.func_145831_w().func_72838_d((Entity)vehicle);
        VehicleNGTO obj = new VehicleNGTO(ngto, this.vngto.offsetX, this.vngto.offsetY, this.vngto.offsetZ, this.vngto.scale);
        obj.riderPosX = this.vngto.riderPosX;
        obj.riderPosY = this.vngto.riderPosY;
        obj.riderPosZ = this.vngto.riderPosZ;
        vehicle.setNGTO(obj);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

