/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.util.ColorUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPaint
extends TileEntityCustom {
    private int[][] colors = new int[6][256];
    private int[][] alphas = new int[6][256];
    private boolean[] hasColor = new boolean[6];

    public void func_145839_a(NBTTagCompound nbt) {
        byte[] ba2;
        byte[] ba;
        super.func_145839_a(nbt);
        int[] ia = nbt.func_74759_k("Colors");
        if (ia.length == 1536) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.colors[i][j] = ia[i * 256 + j];
                }
            }
        }
        if ((ba = nbt.func_74770_j("Alphas")).length == 1536) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.alphas[i][j] = ba[i * 256 + j] + 128;
                }
            }
        }
        if ((ba2 = nbt.func_74770_j("HasColor")).length == 6) {
            for (int i = 0; i < 6; ++i) {
                this.hasColor[i] = ba2[i] == 1;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        int[] ia = new int[1536];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 256; ++j) {
                ia[i * 256 + j] = this.colors[i][j];
            }
        }
        nbt.func_74783_a("Colors", ia);
        byte[] ba = new byte[1536];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 256; ++j) {
                ba[i * 256 + j] = (byte)(this.alphas[i][j] - 128);
            }
        }
        nbt.func_74773_a("Alphas", ba);
        byte[] ba2 = new byte[6];
        for (int i = 0; i < 6; ++i) {
            ba2[i] = (byte)(this.hasColor[i] ? 1 : 0);
        }
        nbt.func_74773_a("HasColor", ba2);
        return nbt;
    }

    public void setColor(int color, int alpha, int p1, int p2, int dir) {
        if (p1 < 0 || p1 >= 16 || p2 < 0 || p2 >= 16) {
            return;
        }
        int index = p1 * 16 + p2;
        int c0 = this.colors[dir][index];
        int a0 = this.alphas[dir][index];
        int[] ca = ColorUtil.alphaBlending((int)color, (int)alpha, (int)c0, (int)a0);
        this.colors[dir][index] = ca[0];
        this.alphas[dir][index] = ca[1];
        this.hasColor[dir] = true;
    }

    public void clearColor(int p1, int p2, int dir) {
        if (p1 < 0 || p1 >= 16 || p2 < 0 || p2 >= 16) {
            return;
        }
        int index = p1 * 16 + p2;
        this.colors[dir][index] = 0;
        this.alphas[dir][index] = 0;
    }

    public boolean hasColor(int dir) {
        return this.hasColor[dir];
    }

    public int getColor(int p1, int p2, int dir) {
        return this.colors[dir][p1 * 16 + p2];
    }

    public int getAlpha(int p1, int p2, int dir) {
        return this.alphas[dir][p1 * 16 + p2];
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = false;
            block0: for (int i = 0; i < 6; ++i) {
                if (!this.hasColor(i)) continue;
                this.hasColor[i] = false;
                for (int j = 0; j < 256; ++j) {
                    if (this.alphas[i][j] == 0) continue;
                    this.hasColor[i] = true;
                    flag = true;
                    continue block0;
                }
            }
            if (flag) {
                this.sendPacket();
            } else {
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

