/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tt;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ngt.rtm.block.tt.TimeTableManager;

public class TimeTable {
    public final String fileName;
    public String name;
    public String description;
    public boolean useRealTime;
    public final Map<Pattern, Integer> textColorMap = new HashMap<Pattern, Integer>();
    public TTEntry[][] ttData;
    public String[] trainName;
    public final BiMap<String, Integer> trainAxis = HashBiMap.create();
    public final BiMap<String, Integer> stationAxis = HashBiMap.create();
    public final List<String> colNames = new ArrayList<String>();

    public TimeTable(String name, String[][] csv) {
        this.fileName = name;
        this.loadCSV(csv);
    }

    private void loadCSV(String[][] csv) {
        TTSection currentSection = TTSection.Config;
        int sectionCount = 0;
        ArrayList<List<String>> idListTemp = new ArrayList<List<String>>();
        HashMap<String, TTEntry> entryMapTemp = new HashMap<String, TTEntry>();
        for (String[] sa : csv) {
            if (sa == null || sa.length == 0) continue;
            String firstStr = sa[0];
            if (!firstStr.startsWith("#")) {
                if (firstStr.startsWith("<")) {
                    TTSection section = TTSection.get(firstStr);
                    if (section != null) {
                        currentSection = section;
                        sectionCount = 0;
                    }
                } else if (currentSection == TTSection.Config) {
                    if (firstStr.startsWith("name")) {
                        this.name = this.parseString(firstStr);
                    } else if (firstStr.startsWith("description")) {
                        this.description = this.parseString(firstStr);
                    } else if (firstStr.startsWith("useRealTime")) {
                        this.useRealTime = Boolean.valueOf(this.parseString(firstStr));
                    }
                } else if (currentSection == TTSection.Color) {
                    String[] sa2 = firstStr.split("=");
                    String key = sa2[0];
                    int color = Integer.decode(sa2[1]);
                    this.textColorMap.put(Pattern.compile(key), color);
                } else if (currentSection == TTSection.TimeTable) {
                    if (sectionCount == 1) {
                        for (int i = 1; i < sa.length; ++i) {
                            this.trainAxis.put((Object)sa[i], (Object)(i - 1));
                            TimeTableManager.INSTANCE.addTTAndTrain(sa[i], this);
                        }
                    } else if (sectionCount == 2) {
                        this.trainName = new String[sa.length - 1];
                        for (int i = 1; i < sa.length; ++i) {
                            this.trainName[i - 1] = sa[i];
                        }
                    } else {
                        int row = sectionCount - 3;
                        this.stationAxis.put((Object)sa[0], (Object)row);
                        ArrayList<String> list = new ArrayList<String>();
                        idListTemp.add(list);
                        for (int i = 1; i < sa.length; ++i) {
                            list.add(sa[i]);
                        }
                    }
                } else if (currentSection == TTSection.Entry) {
                    if (sectionCount == 1) {
                        for (String s : sa) {
                            this.colNames.add(s);
                        }
                    } else {
                        entryMapTemp.put(sa[0], new TTEntry(sa));
                    }
                }
            }
            ++sectionCount;
        }
        this.convertData(idListTemp, entryMapTemp);
    }

    private void convertData(List<List<String>> ids, Map<String, TTEntry> entries) {
        this.ttData = new TTEntry[ids.size()][];
        for (int i = 0; i < ids.size(); ++i) {
            List<String> list = ids.get(i);
            this.ttData[i] = new TTEntry[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                this.ttData[i][j] = entries.get(list.get(j));
            }
        }
    }

    private String parseString(String str) {
        return str.split("=")[1];
    }

    public static enum TTSection {
        Config,
        Color,
        TimeTable,
        Entry;


        public static TTSection get(String str) {
            for (TTSection type : TTSection.values()) {
                if (!str.contains(type.toString())) continue;
                return type;
            }
            return null;
        }
    }

    public class TTEntry {
        public final String[] data;
        public final int arrivalTime;
        public final int departureTime;
        public final byte trackNum;

        public TTEntry(String[] entry) {
            this.data = entry;
            this.arrivalTime = this.convertTime(entry[1]);
            this.departureTime = this.convertTime(entry[2]);
            this.trackNum = Byte.valueOf(entry[3]);
        }

        private int convertTime(String s) {
            String[] sa = s.split(":");
            byte hour = Byte.valueOf(sa[0]);
            byte minute = Byte.valueOf(sa[1]);
            return (hour * 60 + minute) * 60;
        }
    }
}

