/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.TileEntityConnectorBase;
import jp.ngt.rtm.modelpack.cfg.ConnectorConfig;
import jp.ngt.rtm.modelpack.cfg.WireConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetConnector;
import jp.ngt.rtm.modelpack.modelset.ModelSetWire;
import jp.ngt.rtm.render.RenderPass;
import jp.ngt.rtm.render.WirePartsRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderElectricalWiring
extends TileEntitySpecialRenderer<TileEntityConnectorBase> {
    public static final RenderElectricalWiring INSTANCE = new RenderElectricalWiring();

    private RenderElectricalWiring() {
    }

    protected void renderElectricalWiring(TileEntityConnectorBase tileEntity, double par2, double par4, double par6, float par8) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        int pass = MinecraftForgeClient.getRenderPass();
        this.renderConnector(tileEntity, par2, par4, par6, par8, pass);
        this.renderAllWire(tileEntity, par2, par4, par6, par8, pass);
        GL11.glPopMatrix();
    }

    protected void renderConnector(TileEntityConnectorBase tileEntity, double par2, double par4, double par6, float par8, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4 + 0.5f), (float)((float)par6 + 0.5f));
        ModelSetConnector modelSet = tileEntity.getResourceState().getResourceSet();
        ConnectorConfig cfg = (ConnectorConfig)modelSet.getConfig();
        int meta = tileEntity.func_145832_p() % 6;
        switch (meta) {
            case 0: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        modelSet.modelObj.render(tileEntity, cfg, pass, par8);
        GL11.glPopMatrix();
    }

    protected void renderAllWire(TileEntityConnectorBase tileEntity, double par2, double par4, double par6, float par8, int pass) {
        Vec3 vec = tileEntity.getWirePos();
        if (vec == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(par2 + 0.5 + vec.getX())), (float)((float)(par4 + 0.5 + vec.getY())), (float)((float)(par6 + 0.5 + vec.getZ())));
        for (Connection connection : tileEntity.getConnnectionList()) {
            if (!connection.type.isVisible || !connection.isRoot) continue;
            this.renderWire(tileEntity, connection, par8, pass);
        }
        GL11.glPopMatrix();
    }

    private void renderWire(TileEntityConnectorBase tileEntity, Connection connection, float par8, int pass) {
        ModelSetWire modelSet = connection.getResourceState().getResourceSet();
        if (modelSet.isDummy()) {
            return;
        }
        if (((WireConfig)modelSet.getConfig()).doCulling) {
            GL11.glEnable((int)2884);
        } else {
            GL11.glDisable((int)2884);
        }
        if (((WireConfig)modelSet.getConfig()).smoothing) {
            GL11.glShadeModel((int)7425);
        }
        Vec3 vec = this.getConnectedTarget(tileEntity, connection, par8);
        WirePartsRenderer renderer = (WirePartsRenderer)modelSet.modelObj.renderer;
        if (pass == 0) {
            renderer.renderWire(tileEntity, connection, vec, par8, RenderPass.NORMAL);
        } else if (pass == 1) {
            if (modelSet.modelObj.light) {
                GLHelper.disableLighting();
                GLHelper.setLightmapMaxBrightness();
                renderer.renderWire(tileEntity, connection, vec, par8, RenderPass.LIGHT);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GLHelper.enableLighting();
            }
            if (modelSet.modelObj.alphaBlend) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                renderer.renderWire(tileEntity, connection, vec, par8, RenderPass.TRANSPARENT);
                GL11.glDisable((int)3042);
            }
        }
        if (((WireConfig)modelSet.getConfig()).smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)2884);
    }

    public Vec3 getConnectedTarget(TileEntityConnectorBase tileEntity, Connection connection, float par8) {
        Vec3 posMain = tileEntity.getWirePos();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float thisX = (float)tileEntity.func_174877_v().func_177958_n() + 0.5f + (float)posMain.getX();
        float thisY = (float)tileEntity.func_174877_v().func_177956_o() + 0.5f + (float)posMain.getY();
        float thisZ = (float)tileEntity.func_174877_v().func_177952_p() + 0.5f + (float)posMain.getZ();
        if (connection.type == Connection.ConnectionType.TO_ENTITY) {
            x = (float)connection.x + 0.5f - thisX;
            y = (float)connection.y - thisY;
            z = (float)connection.z + 0.5f - thisZ;
        } else if (connection.type == Connection.ConnectionType.TO_PLAYER) {
            EntityPlayer entity = connection.getPlayer(tileEntity.func_145831_w());
            if (entity != null) {
                double d6;
                float f9 = entity.func_70678_g(par8);
                float f10 = NGTMath.getSin((float)((float)(Math.sqrt(f9) * Math.PI)));
                Vec3 vec3 = PooledVec3.create((double)-0.46, (double)-0.2, (double)0.65);
                vec3 = vec3.rotateAroundX(-(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * par8));
                vec3 = vec3.rotateAroundY(-(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * par8));
                vec3 = vec3.rotateAroundY(f10 * 0.5f);
                vec3 = vec3.rotateAroundX(-f10 * 0.7f);
                double x0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)par8 + vec3.getX();
                double y0 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)par8 + vec3.getY();
                double z0 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)par8 + vec3.getZ();
                double d = d6 = entity == Minecraft.func_71410_x().field_71439_g ? 0.0 : (double)entity.func_70047_e();
                if (NGTUtilClient.getMinecraft().func_175598_ae().field_78733_k.field_74320_O > 0 || entity != Minecraft.func_71410_x().field_71439_g) {
                    float f11 = (entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * par8) * (float)Math.PI / 180.0f;
                    double d7 = NGTMath.getSin((float)f11);
                    double d9 = NGTMath.getCos((float)f11);
                    x0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)par8 - d9 * 0.35 - d7 * 0.85;
                    y0 = entity.field_70167_r + d6 + (entity.field_70163_u - entity.field_70167_r) * (double)par8 - 0.45;
                    z0 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)par8 - d7 * 0.35 + d9 * 0.85;
                }
                x = (float)(x0 - (double)thisX);
                y = (float)(y0 - (double)thisY);
                z = (float)(z0 - (double)thisZ);
            }
        } else {
            Vec3 posTarget;
            TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)this.func_178459_a(), (int)connection.x, (int)connection.y, (int)connection.z);
            if (tile instanceof TileEntityConnectorBase && (posTarget = ((TileEntityConnectorBase)tile).getWirePos()) != null) {
                x = (float)connection.x + 0.5f + (float)posTarget.getX() - thisX;
                y = (float)connection.y + 0.5f + (float)posTarget.getY() - thisY;
                z = (float)connection.z + 0.5f + (float)posTarget.getZ() - thisZ;
            }
        }
        return PooledVec3.create((double)x, (double)y, (double)z);
    }

    public void render(TileEntityConnectorBase tileentity, double d0, double d1, double d2, float f, int par9, float alpha) {
        this.renderElectricalWiring(tileentity, d0, d1, d2, f);
    }

    public boolean isGlobalRenderer(TileEntityConnectorBase tileentity) {
        return true;
    }
}

