/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.IProvideElectricity;
import jp.ngt.rtm.electric.TileEntityConnectorBase;

public abstract class TileEntityConnector
extends TileEntityConnectorBase {
    private int prevOutputSignal = -1;

    @Override
    public void onGetElectricity(int x, int y, int z, int level, int counter) {
        if (this.getSubType() == RTMResource.CONNECTOR_INPUT) {
            super.onGetElectricity(x, y, z, level, counter);
        }
    }

    @Override
    protected void sendElectricity(Connection connection, int level, int counter) {
        if (this.getSubType() == RTMResource.CONNECTOR_INPUT && connection.type == Connection.ConnectionType.DIRECT) {
            IProvideElectricity provider = connection.getIProvideElectricity(this.field_145850_b);
            if (provider != null) {
                provider.setElectricity(this.getX(), this.getY(), this.getZ(), level);
            }
        } else {
            super.sendElectricity(connection, level, counter);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.getSubType() == RTMResource.CONNECTOR_OUTPUT) {
            this.checkSignalOutput();
        }
    }

    private void checkSignalOutput() {
        int level;
        Connection connection = this.getBlockConnection();
        if (connection == null) {
            return;
        }
        IProvideElectricity provider = connection.getIProvideElectricity(this.field_145850_b);
        if (provider != null && (level = provider.getElectricity()) != this.prevOutputSignal) {
            this.sendElectricityToAll(level);
            this.prevOutputSignal = level;
        }
    }

    private Connection getBlockConnection() {
        for (Connection connection : this.connections) {
            if (connection.type != Connection.ConnectionType.DIRECT) continue;
            return connection;
        }
        return null;
    }
}

