/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.electric.TileEntityElectricalWiring;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.ConnectorConfig;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetConnector;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityConnectorBase
extends TileEntityElectricalWiring
implements IResourceSelector {
    private ResourceState<ModelSetConnector> state = new ResourceState(this.getSubType(), this);
    private Vec3 wirePos = Vec3.ZERO;
    private String modelName = "";

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getResourceState().readFromNBT(nbt.func_74775_l("State"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("State", (NBTBase)this.getResourceState().writeToNBT());
        return nbt;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.checkWireUpdate();
    }

    private final void checkWireUpdate() {
        ModelSetConnector set = this.getResourceState().getResourceSet();
        if (!set.isDummy() && !((ResourceConfig)((ResourceSet)set).getConfig()).getName().equals(this.modelName)) {
            this.updateWirePos();
            this.modelName = ((ResourceConfig)((ResourceSet)set).getConfig()).getName();
        }
    }

    public Vec3 getWirePos() {
        return this.wirePos;
    }

    public void updateWirePos() {
        ConnectorConfig cfg = (ConnectorConfig)this.getResourceState().getResourceSet().getConfig();
        Vec3 vec = PooledVec3.create((double)cfg.wirePos[0], (double)cfg.wirePos[1], (double)cfg.wirePos[2]);
        int meta = this.func_145832_p();
        switch (meta) {
            case 0: {
                vec = vec.rotateAroundZ(180.0f);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                vec = vec.rotateAroundX(-90.0f);
                vec = vec.rotateAroundY(180.0f);
                break;
            }
            case 3: {
                vec = vec.rotateAroundX(-90.0f);
                break;
            }
            case 4: {
                vec = vec.rotateAroundX(-90.0f);
                vec = vec.rotateAroundY(-90.0f);
                break;
            }
            case 5: {
                vec = vec.rotateAroundX(-90.0f);
                vec = vec.rotateAroundY(90.0f);
            }
        }
        this.wirePos = vec;
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.getX(), this.getY(), this.getZ()};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        this.updateResourceState();
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int rangeXZ = 32;
        int rangeY = 16;
        AxisAlignedBB bb = new AxisAlignedBB((double)(this.getX() - 32), (double)(this.getY() - 16), (double)(this.getZ() - 32), (double)(this.getX() + 32), (double)(this.getY() + 16), (double)(this.getZ() + 32));
        return bb;
    }

    @Override
    public void updateResourceState() {
        this.updateWirePos();
        this.sendPacket();
        this.func_70296_d();
        BlockUtil.markBlockForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    public ResourceState<ModelSetConnector> getResourceState() {
        return this.state;
    }

    protected abstract ResourceType getSubType();
}

