/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.IBlockConnective;
import jp.ngt.rtm.electric.TileEntityDummyEW;
import jp.ngt.rtm.electric.WireManager;
import jp.ngt.rtm.entity.EntityElectricalWiring;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.network.PacketWire;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileEntityElectricalWiring
extends TileEntityCustom
implements ITickable {
    protected List<Connection> connections = new ArrayList<Connection>();
    public boolean isActivated;
    private int signal;
    private int prevSignal = -1;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        List<Connection> prevConnections = this.connections;
        this.connections = new ArrayList<Connection>();
        this.connections.addAll(Connection.readListFromNBT(nbt));
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            for (Connection connection : this.connections) {
                if (!prevConnections.contains(connection)) {
                    WireManager.INSTANCE.addWire(this, connection);
                }
                prevConnections.remove(connection);
            }
            for (Connection connection : prevConnections) {
                WireManager.INSTANCE.removeWire(this, connection);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.isBlockTile()) {
            super.func_189515_b(nbt);
        } else {
            nbt.func_74768_a("x", this.getX());
            nbt.func_74768_a("y", this.getY());
            nbt.func_74768_a("z", this.getZ());
        }
        Connection.writeListToNBT(nbt, this.connections);
        return nbt;
    }

    protected Connection getConnection(int x, int y, int z) {
        for (Connection connection : this.connections) {
            if (connection.x != x || connection.y != y || connection.z != z) continue;
            return connection;
        }
        return null;
    }

    public List<Connection> getConnnectionList() {
        return this.connections;
    }

    public boolean setConnectionTo(int x, int y, int z, Connection.ConnectionType type, ResourceState state) {
        boolean flag = false;
        if (type == Connection.ConnectionType.NONE) {
            Connection c0 = this.getConnection(x, y, z);
            if (c0 != null) {
                this.connections.remove(c0);
                TileEntityElectricalWiring tile = this.getWireTileEntity(x, y, z, c0.type);
                if (tile != null) {
                    tile.setConnectionFrom(this.getX(), this.getY(), this.getZ(), Connection.ConnectionType.NONE, null);
                }
                flag = true;
            }
        } else if (type == Connection.ConnectionType.TO_PLAYER) {
            this.connections.add(new Connection(true, x, y, z, type, state));
            flag = true;
        } else {
            Block block = BlockUtil.getBlock((IBlockAccess)this.field_145850_b, (int)x, (int)y, (int)z);
            if (type == Connection.ConnectionType.TO_ENTITY || block != null && block instanceof IBlockConnective) {
                Connection.ConnectionType type2;
                TileEntityElectricalWiring tile = this.getWireTileEntity(x, y, z, type);
                Connection.ConnectionType connectionType = type2 = type == Connection.ConnectionType.TO_ENTITY ? Connection.ConnectionType.WIRE : type;
                if (type == Connection.ConnectionType.DIRECT || tile != null && tile.setConnectionFrom(this.getX(), this.getY(), this.getZ(), type2, state)) {
                    this.connections.add(new Connection(true, x, y, z, type, state));
                    flag = true;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && flag) {
            this.func_70296_d();
            this.sendPacket();
        }
        return flag;
    }

    private boolean setConnectionFrom(int x, int y, int z, Connection.ConnectionType type, ResourceState state) {
        this.setConnection(x, y, z, type, state);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.sendPacket();
        }
        return true;
    }

    private void setConnection(int x, int y, int z, Connection.ConnectionType type, ResourceState state) {
        Connection connection = this.getConnection(x, y, z);
        if (type == Connection.ConnectionType.NONE) {
            if (connection != null) {
                this.connections.remove(connection);
            }
        } else if (connection == null) {
            this.connections.add(new Connection(false, x, y, z, type, state));
        }
    }

    public void onGetElectricity(int x, int y, int z, int level, int counter) {
        if (level == 0) {
            if (this.prevSignal < 0) {
                this.prevSignal = 0;
            }
        } else if (level > 0 && level != this.prevSignal) {
            this.prevSignal = level;
        }
    }

    protected void sendElectricity(Connection connection, int level, int counter) {
        TileEntityElectricalWiring tile = connection.getElectricalWiring(this.field_145850_b);
        if (tile != null) {
            tile.onGetElectricity(this.getX(), this.getY(), this.getZ(), level, ++counter);
        }
    }

    protected void sendElectricityToAll(int level) {
        for (Connection connection : this.connections) {
            if (connection.type == Connection.ConnectionType.NONE) continue;
            this.sendElectricity(connection, level, 0);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.isActivated) {
                Random random = this.field_145850_b.field_73012_v;
                for (int l = 0; l < 3; ++l) {
                    double d1 = (float)this.getX() + random.nextFloat();
                    double d2 = (float)this.getY() + random.nextFloat();
                    double d3 = (float)this.getZ() + random.nextFloat();
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            ArrayList<Connection> list = new ArrayList<Connection>(this.connections);
            for (Connection connection : list) {
                if (connection.isAvailable(this.field_145850_b) && connection.type != Connection.ConnectionType.NONE) continue;
                this.setConnectionTo(connection.x, connection.y, connection.z, Connection.ConnectionType.NONE, null);
            }
            if (this.prevSignal >= 0 && this.prevSignal != this.signal) {
                this.signal = this.prevSignal;
                this.sendElectricityToAll(this.signal);
            }
            this.prevSignal = -1;
        }
    }

    public static ResourceState getWireType(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack != null && itemStack.func_77973_b() == RTMItem.itemWire) {
            return ((ItemWithModel)itemStack.func_77973_b()).getModelState(itemStack);
        }
        return null;
    }

    public boolean onRightClick(EntityPlayer player) {
        boolean flag = false;
        if (this.isActivated) {
            this.isActivated = false;
            this.setConnectionTo(player.func_145782_y(), -1, 0, Connection.ConnectionType.NONE, null);
            flag = true;
        } else {
            ResourceState wireType = TileEntityElectricalWiring.getWireType(player);
            if (wireType == null) {
                if (this.disconnection()) {
                    return true;
                }
                this.isActivated = true;
                flag = true;
            } else {
                if (this.createConnection(player, wireType)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70448_g().func_190918_g(1);
                    }
                    return true;
                }
                this.isActivated = true;
                this.setConnectionTo(player.func_145782_y(), -1, 0, Connection.ConnectionType.TO_PLAYER, wireType);
                flag = true;
            }
        }
        if (flag) {
            this.sendPacket();
        }
        return flag;
    }

    private boolean disconnection() {
        Connection c0;
        TileEntityElectricalWiring tile = this.searchActiveTEEW();
        if (tile != null && (c0 = this.getConnection(tile.getX(), tile.getY(), tile.getZ())) != null) {
            tile.isActivated = false;
            this.setConnectionTo(tile.getX(), tile.getY(), tile.getZ(), Connection.ConnectionType.NONE, null);
            return true;
        }
        return false;
    }

    private boolean createConnection(EntityPlayer player, ResourceState state) {
        Connection c0;
        TileEntityElectricalWiring tile = this.searchActiveTEEW();
        if (tile != null && (c0 = this.getConnection(tile.getX(), tile.getY(), tile.getZ())) == null && state != null) {
            boolean isBlock = !(tile instanceof TileEntityDummyEW);
            Connection.ConnectionType type = isBlock ? Connection.ConnectionType.WIRE : Connection.ConnectionType.TO_ENTITY;
            tile.isActivated = false;
            boolean flag = false;
            if (this instanceof TileEntityDummyEW) {
                type = Connection.ConnectionType.TO_ENTITY;
                flag = tile.setConnectionTo(this.getX(), this.getY(), this.getZ(), type, state);
            } else {
                flag = this.setConnectionTo(tile.getX(), tile.getY(), tile.getZ(), type, state);
            }
            if (type != Connection.ConnectionType.NONE && flag) {
                tile.setConnectionTo(player.func_145782_y(), -1, 0, Connection.ConnectionType.NONE, null);
                return true;
            }
        }
        return false;
    }

    private TileEntityElectricalWiring searchActiveTEEW() {
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        int range = RTMCore.connectorSearchRange;
        int rangeD = range * 2;
        for (int i = 0; i < rangeD; ++i) {
            for (int j = 0; j < rangeD; ++j) {
                for (int k = 0; k < rangeD; ++k) {
                    TileEntityElectricalWiring tile0 = this.getWireTileEntity(x - range + i, y - range + j, z - range + k, Connection.ConnectionType.NONE, false);
                    if (i == range && j == range && k == range || tile0 == null || !tile0.isActivated) continue;
                    return tile0;
                }
            }
        }
        List list = this.field_145850_b.func_72872_a(EntityElectricalWiring.class, new AxisAlignedBB((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range)));
        if (!list.isEmpty()) {
            for (EntityElectricalWiring entity : list) {
                if (!entity.tileEW.isActivated) continue;
                return entity.tileEW;
            }
        }
        return null;
    }

    protected TileEntityElectricalWiring getWireTileEntity(int x, int y, int z, Connection.ConnectionType type) {
        return this.getWireTileEntity(x, y, z, type, true);
    }

    protected TileEntityElectricalWiring getWireTileEntity(int x, int y, int z, Connection.ConnectionType type, boolean par5) {
        TileEntity tile;
        if (par5) {
            if (type == Connection.ConnectionType.TO_ENTITY) {
                return TileEntityElectricalWiring.getWireEntity(this.field_145850_b, x, y, z);
            }
            Connection connection = this.getConnection(x, y, z);
            if (connection != null && connection.getElectricalWiring(this.field_145850_b) != null) {
                return connection.getElectricalWiring(this.field_145850_b);
            }
        }
        if ((tile = BlockUtil.getTileEntity((IBlockAccess)this.field_145850_b, (int)x, (int)y, (int)z)) instanceof TileEntityElectricalWiring) {
            return (TileEntityElectricalWiring)tile;
        }
        return null;
    }

    public static TileEntityElectricalWiring getWireEntity(World world, int x, int y, int z) {
        List list = world.func_72872_a(EntityElectricalWiring.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)));
        if (!list.isEmpty()) {
            return ((EntityElectricalWiring)list.get((int)0)).tileEW;
        }
        return null;
    }

    public boolean isBlockTile() {
        return true;
    }

    public void onBlockBreaked() {
        for (Connection connection : this.connections) {
            this.sendElectricity(connection, 0, 0);
        }
    }

    public void sendPacket() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            if (this instanceof TileEntityDummyEW) {
                EntityElectricalWiring entity = ((TileEntityDummyEW)this).entityEW;
                RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketWire(entity, this));
            } else {
                RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketWire(this));
            }
        }
    }

    public void setPos(int x, int y, int z, int prevX, int prevY, int prevZ) {
        int difX = x - prevX;
        int difY = y - prevY;
        int difZ = z - prevZ;
        for (Connection connection : this.connections) {
            connection.x += difX;
            connection.y += difY;
            connection.z += difZ;
        }
        super.setPos(x, y, z, prevX, prevY, prevZ);
    }
}

