/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.fluid;

import jp.ngt.ngtlib.util.ColorUtil;

public enum FluidType {
    PIG_IRON(16776012, 15086336, 12497840, 0, 1200.0f, 0.15f, 0.01f, -1, Type.LIQUID),
    STEEL(16776524, 15086336, 0x9090A0, 0, 1500.0f, 0.15f, 0.01f, -1, Type.LIQUID),
    COKE(14176336, 0, 0x505050, 0, 1000.0f, 0.01f, 0.005f, 6000, Type.SOLID),
    SLAG(16776012, 15086336, 8880272, 0, 1000.0f, 0.2f, 0.015f, -1, Type.LIQUID),
    IRON_ORE(16776012, 15086336, 0xA0A0A0, 0, 1200.0f, 0.01f, 0.005f, -1, Type.SOLID);

    private final int topHotColor;
    private final int bottomHotColor;
    private final int topColdColor;
    private final int bottomColdColor;
    public final float meltingPoint;
    public final float viscosity;
    public final float thermalConductivity;
    public final int life;
    public final Type type;

    private FluidType(int color1, int color2, int color3, int color4, float f1, float f2, float f3, int i1, Type t1) {
        this.topHotColor = color1;
        this.bottomHotColor = color2;
        this.topColdColor = color3;
        this.bottomColdColor = color4;
        this.meltingPoint = f1;
        this.viscosity = f2;
        this.thermalConductivity = f3 * 0.5f;
        this.life = i1;
        this.type = t1;
    }

    public int getColor(float gradation, float normalizedTemp) {
        int r = this.calcColorComponent(ColorUtil.getR((int)this.topHotColor), ColorUtil.getR((int)this.bottomHotColor), ColorUtil.getR((int)this.topColdColor), ColorUtil.getR((int)this.bottomColdColor), gradation, normalizedTemp, true);
        int g = this.calcColorComponent(ColorUtil.getG((int)this.topHotColor), ColorUtil.getG((int)this.bottomHotColor), ColorUtil.getG((int)this.topColdColor), ColorUtil.getG((int)this.bottomColdColor), gradation, normalizedTemp, true);
        int b = this.calcColorComponent(ColorUtil.getB((int)this.topHotColor), ColorUtil.getB((int)this.bottomHotColor), ColorUtil.getB((int)this.topColdColor), ColorUtil.getB((int)this.bottomColdColor), gradation, normalizedTemp, true);
        return ColorUtil.encode((int)r, (int)g, (int)b);
    }

    private int calcColorComponent(int topHot, int bottomHot, int topCold, int bottomCold, float gradation, float normalizedTemp, boolean useTemp) {
        int color;
        float top = topHot;
        float bottom = bottomHot;
        if (useTemp) {
            top = (float)(topHot - topCold) * normalizedTemp + (float)topCold;
            bottom = (float)(bottomHot - bottomCold) * normalizedTemp + (float)bottomCold;
        }
        return (color = (int)((top - bottom) * gradation + bottom)) < 0 ? 0 : (color > 255 ? 255 : color);
    }

    public static enum Type {
        GAS,
        LIQUID,
        SOLID;

    }
}

