/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.npc;

import java.util.ArrayList;
import java.util.Arrays;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.EntityBullet;
import jp.ngt.rtm.entity.ai.ScriptExecuterNPC;
import jp.ngt.rtm.entity.npc.EntityDummyPlayer;
import jp.ngt.rtm.entity.npc.EntityMotorman;
import jp.ngt.rtm.entity.npc.InventoryNPC;
import jp.ngt.rtm.entity.npc.Role;
import jp.ngt.rtm.item.ItemGun;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.cfg.NPCConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetNPC;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityNPC
extends EntityTameable
implements IResourceSelector,
IRangedAttackMob {
    private static final DataParameter<Byte> USING_ITEM = EntityDataManager.func_187226_a(EntityNPC.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<String> MENU = EntityDataManager.func_187226_a(EntityNPC.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final float MAX_HEALTH = 40.0f;
    public static final float FOLLOWING_RANGE = 64.0f;
    public static final float SPEED = 0.45f;
    public static final float ATTACK_POWER = 1.0f;
    private ResourceState<ModelSetNPC> state = new ResourceState(RTMResource.NPC, this);
    private ScriptExecuterNPC executer = new ScriptExecuterNPC();
    protected Role myRole = Role.MANNEQUIN;
    private EntityDummyPlayer playerDummy;
    protected int useItemCount;
    private boolean roleChanged;
    public InventoryNPC inventory = new InventoryNPC(this);

    public EntityNPC(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.playerDummy = new EntityDummyPlayer(world, this);
    }

    public EntityNPC(World world, EntityPlayer player) {
        this(world);
        this.func_184754_b(player.func_110124_au());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.45f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(USING_ITEM, (Object)0);
        this.func_184212_Q().func_187214_a(MENU, (Object)"");
    }

    private void syncData() {
        this.updateResourceState();
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.syncData();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.state.readFromNBT(nbt.func_74775_l("State"));
        if (this.state.version < 1) {
            String s = nbt.func_74779_i("ModelName");
            this.state.setResourceName(s);
        }
        NBTTagList nbttaglist = nbt.func_150295_c("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.setMenu(nbt.func_74779_i("menu"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("State", (NBTBase)this.state.writeToNBT());
        nbt.func_74782_a("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        nbt.func_74778_a("menu", this.getMenu());
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public double func_70033_W() {
        return 0.0;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected void func_70628_a(boolean par1, int par2) {
    }

    public void func_70071_h_() {
        if (this.inventory.isOpening) {
            return;
        }
        super.func_70071_h_();
        this.playerDummy.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.playerDummy.field_70177_z = this.field_70177_z;
        this.playerDummy.field_70125_A = this.field_70125_A;
        if (this.isUsingItem()) {
            boolean hasGun;
            ItemStack item = this.getHeldItem();
            boolean bl = hasGun = !item.func_190926_b() && item.func_77973_b() instanceof ItemGun;
            if (!hasGun || this.useItemCount > item.func_77988_m()) {
                if (!this.field_70170_p.field_72995_K) {
                    if (hasGun) {
                        item.func_77974_b(this.field_70170_p, (EntityLivingBase)this.playerDummy, this.useItemCount);
                    }
                    this.setUseItem(false);
                }
                this.useItemCount = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                item.func_77973_b().onUsingTick(item, (EntityLivingBase)this.playerDummy, this.useItemCount);
            }
            ++this.useItemCount;
        } else {
            this.useItemCount = 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.executer.execScript(this);
        }
    }

    public void func_70636_d() {
        if (this.myRole != Role.MANNEQUIN) {
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K) {
                this.healNPC();
            }
        }
        if (this.roleChanged) {
            this.roleChanged = false;
            this.myRole = Role.getRole(((NPCConfig)this.state.getResourceSet().getConfig()).role);
            this.myRole.init(this);
            this.onInventoryChanged();
        }
    }

    private void debugCurrentAI() {
        for (EntityAITasks.EntityAITaskEntry entry : this.field_70714_bg.field_75782_a) {
            if (!entry.field_188524_c) continue;
            NGTLog.debug((String)"AI:%s", (Object[])new Object[]{entry.field_75733_a.getClass().getSimpleName()});
        }
    }

    public Role getRole() {
        return this.myRole;
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.syncData();
    }

    protected void healNPC() {
        int index;
        if (this.field_70173_aa % 3 == 0 && this.func_110143_aJ() < this.func_110138_aP() && (index = this.inventory.hasItem(ItemFood.class)) >= 0) {
            ItemStack stack = this.inventory.func_70301_a(index);
            this.func_70691_i(((ItemFood)stack.func_77973_b()).func_150905_g(stack));
            stack.func_190918_g(1);
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K) {
            this.inventory.dropAllItems();
            if (source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.dropEntity();
            }
        }
    }

    protected void dropEntity() {
        int damage = this instanceof EntityMotorman ? 0 : 1;
        this.func_70099_a(new ItemStack(this.func_146068_u(), 1, damage), 0.5f);
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        Entity attacker = damageSource.func_76346_g();
        if (attacker instanceof EntityPlayer) {
            if (attacker.equals((Object)this.func_70902_q())) {
                par2 = 10000.0f;
            } else if (!((EntityPlayer)attacker).field_71075_bZ.field_75098_d && this.myRole == Role.MANNEQUIN) {
                return false;
            }
        }
        if (!this.executer.onAttackedFrom(this, attacker)) {
            return false;
        }
        return super.func_70097_a(damageSource, par2);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        float power = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        ItemStack stack = this.getHeldItem();
        DamageSource damSrc = DamageSource.func_76358_a((EntityLivingBase)this);
        if (!this.executer.attackEntity(this, target)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(stack);
            power += (float)EnchantmentHelper.func_77508_a(list, (DamageSource)damSrc);
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = target.func_70097_a(damSrc, power)) {
            int j;
            if (knockback > 0) {
                double vx = -MathHelper.func_76126_a((float)NGTMath.toRadians((float)this.field_70177_z)) * (float)knockback * 0.5f;
                double vz = MathHelper.func_76134_b((float)NGTMath.toRadians((float)this.field_70177_z)) * (float)knockback * 0.5f;
                target.func_70024_g(vx, 0.1, vz);
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(j * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float strength) {
        ItemStack item;
        if (!this.executer.attackEntity(this, (Entity)target)) {
            return;
        }
        if (!this.isUsingItem() && !(item = this.getHeldItem()).func_190926_b() && item.func_77973_b() instanceof ItemGun) {
            item.func_77957_a(this.field_70170_p, (EntityPlayer)this.playerDummy, EnumHand.MAIN_HAND);
            this.setUseItem(true);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdNPC, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
        return true;
    }

    public boolean isUsingItem() {
        return (Byte)this.func_184212_Q().func_187225_a(USING_ITEM) == 1;
    }

    public void setUseItem(boolean par1) {
        byte value = (byte)(par1 ? 1 : 0);
        this.func_184212_Q().func_187227_b(USING_ITEM, (Object)value);
    }

    public int getItemUseCount() {
        return this.useItemCount;
    }

    public String getMenu() {
        return (String)this.func_184212_Q().func_187225_a(MENU);
    }

    public void setMenu(String s) {
        this.func_184212_Q().func_187227_b(MENU, (Object)s);
    }

    protected void func_70675_k(float damage) {
        this.inventory.damageArmor((EntityLivingBase)this, damage);
    }

    public int func_70658_aO() {
        return this.inventory.getTotalArmorValue();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            return this.inventory.mainInventory[0];
        }
        if (slot == EntityEquipmentSlot.OFFHAND) {
            return ItemStack.field_190927_a;
        }
        return this.inventory.armorInventory[slot.func_188452_c() - 1];
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Arrays.asList(this.getHeldItem());
    }

    public ItemStack getHeldItem() {
        return this.inventory.mainInventory[0];
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.inventory.mainInventory[0] = stack;
        } else if (slot != EntityEquipmentSlot.OFFHAND) {
            this.inventory.armorInventory[slot.func_188452_c() - 1] = stack;
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Arrays.asList(this.inventory.armorInventory);
    }

    public String func_70005_c_() {
        return this.getResourceState().getName();
    }

    @Override
    public void updateResourceState() {
        this.roleChanged = true;
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            PacketNBT.sendToClient((Entity)this);
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_145782_y(), -1, 0};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    public boolean isMotorman() {
        return false;
    }

    public void onInventoryChanged() {
        this.myRole.onInventoryChanged(this);
        NPCConfig cfg = (NPCConfig)this.getResourceState().getResourceSet().getConfig();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)cfg.health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)cfg.speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)cfg.damage);
    }

    public EntityBullet getBullet(ItemGun.GunType type) {
        if (this.func_70638_az() == null) {
            return new EntityBullet(this.field_70170_p, (EntityLivingBase)this, type.speed, type.bulletType);
        }
        return new EntityBullet(this.field_70170_p, (EntityLivingBase)this, this.func_70638_az(), type.speed, type.bulletType);
    }

    public ResourceState<ModelSetNPC> getResourceState() {
        return this.state;
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

