/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.npc;

import java.util.Calendar;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.item.ItemGun;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetNPC;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderNPC
extends RenderBiped<EntityNPC> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rtm", "textures/motorman.png");
    private static final ResourceLocation TEX_SANTA = new ResourceLocation("rtm", "textures/motorman_santa.png");
    private static final ResourceLocation TEX_SHISHI = new ResourceLocation("rtm", "textures/motorman_shishi.png");
    private int textureType;

    public RenderNPC(RenderManager renderManager) {
        super(renderManager, new ModelBiped(0.0f, 0.0f, 64, 64), 0.5f);
        this.func_177094_a(new LayerLight(this));
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        if (month == 1 && day >= 1 && day <= 3) {
            this.textureType = 1;
        } else if (month == 12 && day >= 24 && day <= 26) {
            this.textureType = 12;
        }
    }

    public void doRender(EntityNPC entity, double x, double y, double z, float par8, float partialTick) {
        if (entity.getResourceState().getResourceSet().modelObj == null) {
            boolean usingGun;
            ItemStack heldItem = entity.getHeldItem();
            boolean hasGun = heldItem != null && heldItem.func_77973_b() instanceof ItemGun;
            boolean bl = usingGun = hasGun && entity.isUsingItem();
            if (usingGun) {
                ((ModelBiped)this.field_77045_g).field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
            super.func_76986_a((EntityLiving)entity, x, y, z, par8, partialTick);
        } else {
            this.renderCustomModel(entity, x, y, z, par8, partialTick);
        }
    }

    private void renderCustomModel(EntityNPC entity, double x, double y, double z, float par8, float partialTick) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        ModelSetNPC modelSet = entity.getResourceState().getResourceSet();
        modelSet.modelObj.render(entity, (ModelConfig)modelSet.getConfig(), 0, partialTick);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityNPC entity) {
        if (entity.isMotorman()) {
            switch (this.textureType) {
                case 1: {
                    return TEX_SHISHI;
                }
                case 12: {
                    return TEX_SANTA;
                }
            }
            return TEXTURE;
        }
        return entity.getResourceState().getResourceSet().texture;
    }

    public class LayerLight
    implements LayerRenderer<EntityNPC> {
        private final RenderNPC parentRenderer;

        public LayerLight(RenderNPC renderer) {
            this.parentRenderer = renderer;
        }

        public void doRenderLayer(EntityNPC entity, float par2, float par3, float partialTicks, float par5, float par6, float par7, float scale) {
            if (entity.isMotorman()) {
                return;
            }
            ResourceLocation tex = entity.getResourceState().getResourceSet().lightTexture;
            if (tex == null) {
                return;
            }
            this.parentRenderer.func_110776_a(tex);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((!entity.func_82150_aj() ? 1 : 0) != 0);
            int i = 61680;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.parentRenderer.func_177087_b().func_78088_a((Entity)entity, par2, par3, par5, par6, par7, scale);
            this.parentRenderer.func_177105_a((EntityLiving)entity);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

