/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.npc.macro;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.entity.npc.macro.TrainCommand;
import jp.ngt.rtm.entity.train.util.TrainState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MacroRecorder {
    private static final String MACRO_FOLDER = "rtm/train_macro";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    public static final MacroRecorder INSTANCE = new MacroRecorder();
    private List<TrainCommand> commands = new ArrayList<TrainCommand>();
    private boolean recording;
    private long startTime;

    private MacroRecorder() {
    }

    public boolean start(World world) {
        if (this.recording) {
            return false;
        }
        this.recording = true;
        this.startTime = world.func_72820_D();
        this.commands.clear();
        NGTLog.sendChatMessage((ICommandSender)NGTUtil.getClientPlayer(), (String)"Start recording", (Object[])new Object[0]);
        return true;
    }

    public boolean stop(World world) {
        if (!this.recording) {
            return false;
        }
        this.recording = false;
        this.startTime = 0L;
        this.saveToFile(NGTUtil.getClientPlayer());
        return true;
    }

    private void setCommand(World world, TrainCommand.CommandType type, Object param) {
        if (this.recording) {
            long time = world.func_72820_D() - this.startTime;
            this.commands.add(new TrainCommand(time, type, param));
        }
    }

    private void saveToFile(EntityPlayer player) {
        File saveFile = null;
        try {
            File macroFolder = this.getMacroFolder();
            String fileName = DATE_FORMAT.format(new Date()).toString();
            saveFile = new File(macroFolder, fileName + ".txt");
            saveFile.createNewFile();
            String[] texts = new String[this.commands.size()];
            for (int i = 0; i < texts.length; ++i) {
                TrainCommand command = this.commands.get(i);
                texts[i] = command.toString();
            }
            NGTText.writeToText((File)saveFile, (String[])texts);
            NGTLog.sendChatMessage((ICommandSender)player, (String)("Save macro : " + saveFile.getName()), (Object[])new Object[0]);
        }
        catch (IOException e) {
            if (saveFile != null) {
                NGTLog.sendChatMessage((ICommandSender)player, (String)("Failed to save file : " + saveFile.getAbsolutePath()), (Object[])new Object[0]);
            }
            e.printStackTrace();
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void recNotch(World world, int notch) {
        this.setCommand(world, TrainCommand.CommandType.Notch, notch);
    }

    public void recHorn(World world) {
        this.setCommand(world, TrainCommand.CommandType.Horn, "");
    }

    public void recChime(World world, String name) {
        this.setCommand(world, TrainCommand.CommandType.Chime, name);
    }

    public void recDoor(World world, TrainState state) {
        this.setCommand(world, TrainCommand.CommandType.Door, (Object)state);
    }

    public File getMacroFolder() {
        File modsFolder = (File)NGTFileLoader.getModsDir().get(0);
        File macroFolder = new File(modsFolder, MACRO_FOLDER);
        if (!macroFolder.exists()) {
            macroFolder.mkdirs();
        }
        return macroFolder;
    }
}

