/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.model.Face;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.util.ColFace;
import jp.ngt.rtm.entity.util.ColParts;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.network.PacketCollisionObj;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class CollisionObj {
    private static final float Y_LIMIT = NGTMath.sin((float)45.0f);
    private static final float PLAYER_R = 0.5f;
    private final List<ColParts> partsList = new ArrayList<ColParts>();
    private AxisAlignedBB box;
    private final List<AxisAlignedBB> aabbList = new ArrayList<AxisAlignedBB>();
    private HitResult[] hit;
    private boolean rendering;

    public CollisionObj() {
    }

    @SideOnly(value=Side.CLIENT)
    public CollisionObj(IModelNGT model, ModelConfig cfg) {
        this.initFaceList(model, cfg.collisionParts);
        this.box = this.initAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void syncCollisionObj(ResourceType type, ModelSetBase modelSet, Thread thread) {
        for (int i = 0; i < this.partsList.size(); ++i) {
            ColParts parts = this.partsList.get(i);
            for (int j = 0; j < parts.faces.size(); ++j) {
                ColFace face = parts.faces.get(j);
                byte status = (byte)(i == this.partsList.size() - 1 ? 2 : (j == parts.faces.size() - 1 ? 1 : 0));
                RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketCollisionObj(type, modelSet.getConfig().getName(), parts.name, face, status));
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addColFace(String partsName, ColFace face, byte status) {
        ColParts target = null;
        for (ColParts parts : this.partsList) {
            if (!parts.name.equals(partsName)) continue;
            target = parts;
        }
        if (target == null) {
            target = new ColParts(partsName);
            this.partsList.add(target);
        }
        target.faces.add(face);
        if (status == 1) {
            this.box = this.initAABB();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initFaceList(IModelNGT model, String[] names) {
        boolean addAll = false;
        ArrayList nameList = new ArrayList();
        if (names != null) {
            NGTUtil.addArray(nameList, (Object[])names);
            addAll = names[0].equals("-all");
        }
        for (GroupObject go : model.getGroupObjects()) {
            if (!addAll && !nameList.contains(go.name)) continue;
            ColParts parts = new ColParts(go.name);
            for (Face face : go.faces) {
                if (!(face.faceNormal.getY() > -Y_LIMIT)) continue;
                ColFace cFace = new ColFace();
                cFace.setData(face);
                parts.faces.add(cFace);
            }
            this.partsList.add(parts);
        }
    }

    private AxisAlignedBB initAABB() {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (ColParts parts : this.partsList) {
            for (ColFace face : parts.faces) {
                for (Vec3 vtx : face.vertices) {
                    minX = vtx.getX() < minX ? vtx.getX() : minX;
                    maxX = vtx.getX() > maxX ? vtx.getX() : maxX;
                    minY = vtx.getY() < minY ? vtx.getY() : minY;
                    maxY = vtx.getY() > maxY ? vtx.getY() : maxY;
                    minZ = vtx.getZ() < minZ ? vtx.getZ() : minZ;
                    maxZ = vtx.getZ() > maxZ ? vtx.getZ() : maxZ;
                }
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void applyCollison(Entity target, Entity myself, AxisAlignedBB playerAABB, List<AxisAlignedBB> boxList, List<String> exclusionParts) {
        double px = target.field_70165_t;
        double py = target.field_70163_u;
        double pz = target.field_70161_v;
        double offsetY = myself instanceof EntityVehicleBase ? (double)((EntityVehicleBase)myself).getVehicleYOffset() : 0.0;
        Vec3 vt = PooledVec3.create((double)(px - myself.field_70165_t), (double)(py + 0.5 - (myself.field_70163_u + offsetY)), (double)(pz - myself.field_70161_v));
        HitResult[] hitResults = this.getCollisionPoints(vt, myself, exclusionParts);
        this.hit = hitResults;
        boolean hitted = false;
        for (HitResult result : hitResults) {
            AxisAlignedBB hitAABB;
            if (result == null || !(hitAABB = result.face.toBox(myself)).func_72326_a(playerAABB)) continue;
            boxList.add(hitAABB);
            hitted = true;
        }
        if (!hitted || myself instanceof EntityVehicleBase) {
            // empty if block
        }
    }

    private void applyVehicleCollision(Entity target, EntityVehicleBase vehicle) {
        Vec3 vec = PooledVec3.create((double)0.0, (double)0.0, (double)vehicle.getSpeed());
        vec = vec.rotateAroundY(NGTMath.wrapAngle((float)vehicle.field_70177_z));
        target.field_70159_w += vec.getX();
        target.field_70179_y += vec.getZ();
    }

    public HitResult[] getCollisionPoints(Vec3 vt, Entity myself, @Nullable List<String> exclusionParts) {
        vt = vt.rotateAroundX(-myself.field_70125_A);
        vt = vt.rotateAroundY(-myself.field_70177_z);
        Vec3 pointX = null;
        Vec3 pointY = null;
        Vec3 pointZ = null;
        ColFace faceX = null;
        ColFace faceY = null;
        ColFace faceZ = null;
        for (int idx = 0; idx < this.partsList.size(); ++idx) {
            ColParts parts = this.partsList.get(idx);
            if (exclusionParts != null && exclusionParts.contains(parts.name)) continue;
            for (int i = 0; i < parts.faces.size(); ++i) {
                boolean hitY;
                ColFace face = parts.faces.get(i);
                Vec3 hit = face.getCollisionVec(vt, 0.5f);
                if (hit.equals((Object)Vec3.ZERO)) continue;
                boolean[] flags = this.checkActiveHitDir(hit, vt);
                boolean bl = hitY = face.normal.getY() > (double)Y_LIMIT;
                if (flags[0] && !hitY && (pointX == null || Math.abs(vt.getX() - hit.getX()) < Math.abs(vt.getX() - pointX.getX()))) {
                    pointX = hit;
                    faceX = face;
                    face.color = 0xFF0000;
                }
                if (flags[1] && hitY && (pointY == null || Math.abs(vt.getY() - hit.getY()) < Math.abs(vt.getY() - pointY.getY()))) {
                    pointY = hit;
                    faceY = face;
                    face.color = 65280;
                }
                if (!flags[2] || hitY || pointZ != null && !(Math.abs(vt.getZ() - hit.getZ()) < Math.abs(vt.getZ() - pointZ.getZ()))) continue;
                pointZ = hit;
                faceZ = face;
                face.color = 255;
            }
        }
        HitResult[] result = new HitResult[]{pointX != null ? this.applyRotation(pointX, faceX, myself) : null, pointY != null ? this.applyRotation(pointY, faceY, myself) : null, pointZ != null ? this.applyRotation(pointZ, faceZ, myself) : null};
        return result;
    }

    private HitResult applyRotation(Vec3 point, ColFace face, Entity myself) {
        point = point.rotateAroundY(myself.field_70177_z);
        point = point.rotateAroundX(myself.field_70125_A);
        face = face.rotateAroundY(myself.field_70177_z);
        face = face.rotateAroundX(myself.field_70125_A);
        return new HitResult(point, face);
    }

    private boolean[] checkActiveHitDir(Vec3 hit, Vec3 target) {
        double difX = target.getX() - hit.getX();
        double difY = target.getY() - hit.getY();
        double difZ = target.getZ() - hit.getZ();
        Vec3 difN = PooledVec3.create((double)difX, (double)difY, (double)difZ).normalize();
        double limit = 0.5;
        return new boolean[]{Math.abs(difN.getX()) > limit, Math.abs(difN.getY()) > limit, Math.abs(difN.getZ()) > limit};
    }

    public AxisAlignedBB getSizeBox() {
        return this.box;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkAndRenderCollision(EntityPlayer player, Entity myself, List<String> exclusionParts) {
        this.aabbList.clear();
        AxisAlignedBB box = player.func_174813_aQ();
        this.rendering = true;
        this.applyCollison((Entity)player, myself, box, this.aabbList, exclusionParts);
        this.rendering = false;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        float prevPointSize = GL11.glGetFloat((int)2833);
        float prevLineWidth = GL11.glGetFloat((int)2849);
        GL11.glPointSize((float)10.0f);
        GL11.glLineWidth((float)5.0f);
        GL11.glPushMatrix();
        this.renderFrame(myself, exclusionParts);
        float pitch = myself.field_70127_C;
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        float yaw = myself.field_70126_B;
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderHits();
        this.renderCollisionBox(myself);
        GL11.glPopMatrix();
        GL11.glPointSize((float)prevPointSize);
        GL11.glLineWidth((float)prevLineWidth);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFrame(Entity myself, List<String> exclusionParts) {
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        for (ColParts parts : this.partsList) {
            if (exclusionParts.contains(parts.name)) continue;
            for (ColFace face : parts.faces) {
                face.renderFrame(tessellator, true);
                face.renderNormal(tessellator);
            }
        }
        tessellator.draw();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderHits() {
        if (this.hit == null) {
            return;
        }
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        int color = 0xFF0000;
        float size = 0.5f;
        for (HitResult result : this.hit) {
            if (result != null) {
                float x = (float)result.point.getX();
                float y = (float)result.point.getY();
                float z = (float)result.point.getZ();
                tessellator.setColorRGBA_I(color, 255);
                tessellator.addVertex(x - size, y, z);
                tessellator.addVertex(x + size, y, z);
                tessellator.addVertex(x, y - size, z);
                tessellator.addVertex(x, y + size, z);
                tessellator.addVertex(x, y, z - size);
                tessellator.addVertex(x, y, z + size);
                result.face.color = color;
                result.face.renderFrame(tessellator, true);
            }
            color = color >> 8 & 0xFFFFFF;
        }
        tessellator.draw();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderCollisionBox(Entity myself) {
        double py = myself.field_70163_u;
        int color = 0xA0A0A0;
        for (AxisAlignedBB aabb : this.aabbList) {
            NGTRenderer.renderFrame((float)((float)(aabb.field_72340_a - myself.field_70165_t)), (float)((float)(aabb.field_72338_b - py)), (float)((float)(aabb.field_72339_c - myself.field_70161_v)), (float)((float)(aabb.field_72336_d - aabb.field_72340_a)), (float)((float)(aabb.field_72337_e - aabb.field_72338_b)), (float)((float)(aabb.field_72334_f - aabb.field_72339_c)), (int)color, (int)255);
        }
    }

    public class HitResult {
        public final Vec3 point;
        public final ColFace face;

        public HitResult(Vec3 par1, ColFace par2) {
            this.point = par1;
            this.face = par2;
        }
    }
}

