/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import com.google.common.collect.BiMap;
import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.ClientProxy;
import jp.ngt.rtm.block.tt.TimeTable;
import jp.ngt.rtm.block.tt.TrainTimeTable;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.gui.camera.Camera;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiIngameCustom
extends GuiScreen {
    private static final ResourceLocation TEX_CAB = new ResourceLocation("minecraft", "textures/gui/cab.png");
    private static final ResourceLocation TEX_SCOPE = new ResourceLocation("rtm", "textures/gui/scope.png");
    private static final ResourceLocation TEX_NVD = new ResourceLocation("rtm", "textures/gui/nvd.png");
    private TrainTimeTable timeTable;

    public GuiIngameCustom(Minecraft par1) {
        this.field_146297_k = par1;
        this.field_73735_i = -100.0f;
    }

    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            if (!this.field_146297_k.field_71439_g.func_184218_aH() || this.field_146297_k.field_71474_y.field_74320_O != 0) {
                return;
            }
            this.setScale(event.getResolution());
            Entity ridingEntity = this.field_146297_k.field_71439_g.func_184187_bx();
            if (ridingEntity instanceof EntityVehicleBase) {
                this.renderVehicleGui((EntityVehicleBase)ridingEntity);
            } else if (ridingEntity instanceof EntityArtillery) {
                this.renderArtilleryGui((EntityArtillery)ridingEntity);
            }
            NGTUtilClient.bindTexture((ResourceLocation)field_110324_m);
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            byte viewMode = ClientProxy.getViewMode((EntityPlayer)this.field_146297_k.field_71439_g);
            if (viewMode >= 0) {
                int w = event.getResolution().func_78326_a();
                int h = event.getResolution().func_78328_b();
                if (viewMode == 3) {
                    this.renderNVD(w, h);
                } else if (viewMode == 1 || viewMode == 2) {
                    this.renderScope(w, h);
                }
                event.setCanceled(true);
            }
            if (viewMode == 4) {
                Camera.INSTANCE.render(this.field_146297_k, (RenderGameOverlayEvent)event, event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
            } else {
                Camera.INSTANCE.off();
            }
        }
    }

    private void renderVehicleGui(EntityVehicleBase vehicle) {
        ModelSetVehicleBase modelSet = (ModelSetVehicleBase)vehicle.getResourceState().getResourceSet();
        if (modelSet != null && !((VehicleBaseConfig)modelSet.getConfig()).notDisplayCab) {
            NGTUtilClient.bindTexture((ResourceLocation)(modelSet.guiTexture != null ? modelSet.guiTexture : TEX_CAB));
            if (modelSet.guiSE != null) {
                ScriptUtil.doScriptIgnoreError((ScriptEngine)modelSet.guiSE, (String)"renderGui", (Object[])new Object[]{vehicle, this});
            } else if (vehicle instanceof EntityTrainBase) {
                this.renderDefaultTrainGui((EntityTrainBase)vehicle);
                this.renderTimeTable((EntityTrainBase)vehicle);
            }
        }
    }

    private void renderDefaultTrainGui(EntityTrainBase train) {
        int halfW = this.getWidth() / 2;
        this.func_73729_b(halfW - 208, this.getHeight() - 48, 0, 0, 416, 48);
        this.drawMeterAndLever(train);
        this.drawWatch();
        FontRenderer fontrenderer = this.field_146297_k.field_71466_p;
        fontrenderer.func_175063_a(String.valueOf(this.getSpeed(train)), (float)(halfW - 138), (float)(this.field_146295_m - 11), 65280);
        fontrenderer.func_175063_a(String.valueOf(this.getBrake(train)), (float)(halfW - 178), (float)(this.field_146295_m - 11), 65280);
        fontrenderer.func_175063_a(String.valueOf(this.getWorldTime()), (float)(halfW + 130), (float)(this.field_146295_m - 40), 65280);
        fontrenderer.func_175063_a(this.getTime(), (float)(halfW + 130), (float)(this.field_146295_m - 30), 65280);
    }

    private void renderTimeTable(EntityTrainBase train) {
        int y;
        String trainName = train.getResourceState().getName();
        if (this.timeTable == null || !trainName.equals(this.timeTable.train)) {
            this.timeTable = new TrainTimeTable(trainName);
        }
        if (this.timeTable.colIndex < 0) {
            return;
        }
        TimeTable.TTEntry[][] tt = this.timeTable.timeTable.ttData;
        int fontH = 15;
        int x0 = 5;
        int w1 = 50;
        int w2 = 20;
        int w3 = 20;
        int y0 = 5;
        int maxH = y0 + (tt.length + 2) * fontH;
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0xFFFFFF, 255);
        NGTRenderHelper.addQuadGuiFace((float)x0, (float)y0, (float)(x0 + w1 + w2 + w3), (float)maxH, (float)this.field_73735_i);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_I(0, 255);
        NGTRenderHelper.addQuadGuiFrame((float)x0, (float)y0, (float)(x0 + w1 + w2 + w3), (float)maxH, (float)this.field_73735_i);
        tessellator.addVertex((float)(x0 + w1), (float)y0, this.field_73735_i);
        tessellator.addVertex((float)(x0 + w1), (float)maxH, this.field_73735_i);
        tessellator.addVertex((float)(x0 + w1 + w2), (float)(y0 + fontH), this.field_73735_i);
        tessellator.addVertex((float)(x0 + w1 + w2), (float)maxH, this.field_73735_i);
        for (int i = 0; i < tt.length + 1; ++i) {
            y = y0 + (i + 1) * fontH;
            tessellator.addVertex((float)x0, (float)y, this.field_73735_i);
            tessellator.addVertex((float)(x0 + w1 + w2 + w3), (float)y, this.field_73735_i);
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
        FontRenderer renderer = this.field_146297_k.field_71466_p;
        y = 10;
        int x = 10;
        renderer.func_78276_b(this.timeTable.train, x, y, 0);
        renderer.func_78276_b(train.getFormation().entries.length + "\u4e21", x + w1, y, 0xFF1000);
        int color = 0x808080;
        renderer.func_78276_b("\u505c\u8eca\u5834\u540d", x, y += fontH, color);
        renderer.func_78276_b("\u7740", x + w1, y, color);
        renderer.func_78276_b("\u767a", x + w1 + w2, y, color);
        BiMap map = this.timeTable.timeTable.stationAxis.inverse();
        y += fontH;
        color = 0;
        for (int i = 0; i < tt.length; ++i) {
            TimeTable.TTEntry entry = tt[i][this.timeTable.colIndex];
            renderer.func_78276_b((String)map.get((Object)i), x, y + fontH * i, color);
            renderer.func_78276_b(entry.data[1], x + w1, y + fontH * i, color);
            renderer.func_78276_b(entry.data[2], x + w1 + w2, y + fontH * i, color);
        }
    }

    private void renderArtilleryGui(EntityArtillery artillery) {
        FontRenderer renderer = this.field_146297_k.field_71466_p;
        renderer.func_175063_a("Yaw : " + artillery.getBarrelYaw(), 2.0f, (float)(this.field_146295_m - 40), 0xFFFFFF);
        renderer.func_175063_a("Pitch : " + -artillery.getBarrelPitch(), 2.0f, (float)(this.field_146295_m - 30), 0xFFFFFF);
    }

    public int getWidth() {
        return this.field_146294_l;
    }

    public int getHeight() {
        return this.field_146295_m;
    }

    public int getSpeed(EntityVehicleBase train) {
        return (int)(train.getSpeed() * 72.0f + 0.5f);
    }

    public int getBrake(EntityTrainBase train) {
        return train.brakeCount * 3;
    }

    public int getWorldTime() {
        return (int)this.field_146297_k.field_71439_g.field_70170_p.func_72820_D() % 24000;
    }

    public String getTime() {
        int t0 = this.getWorldTime();
        int hour = (t0 / 1000 + 6) % 24;
        int minute = (int)((float)(t0 % 1000) * 0.06f);
        StringBuilder sb = new StringBuilder(String.valueOf(hour)).append(":").append(minute);
        return sb.toString();
    }

    private void setScale(ScaledResolution par1) {
        this.field_146294_l = par1.func_78326_a();
        this.field_146295_m = par1.func_78328_b();
    }

    private void drawMeterAndLever(EntityTrainBase train) {
        int halfW = this.getWidth() / 2;
        float rMax = 240.0f;
        int startX = halfW - 176;
        int startY = this.field_146295_m - 29;
        float r1 = rMax * (float)train.brakeAirCount / 2880.0f;
        this.drawMeter(startX, startY, 32, 32, 48, r1, 512);
        float r2 = rMax * (float)this.getBrake(train) / 432.0f;
        this.drawMeter(startX, startY, 32, 0, 48, r2, 512);
        float max = ((TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig()).maxSpeed[4];
        float r0 = 270.0f * train.getSpeed() / max;
        this.drawMeter(halfW - 136, this.field_146295_m - 29, 32, 64, 48, r0, 512);
        this.drawLever(train);
    }

    private void drawLever(EntityTrainBase train) {
        int halfW = this.field_146294_l / 2;
        float d = 0.001953125f;
        int notch = train.getNotch() * 3;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(halfW - 104), (float)((float)(this.field_146295_m + notch) - 19.5f), (float)0.0f);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(4.0f, 1.5f, this.field_73735_i, 8.0f * d, 83.0f * d);
        tessellator.addVertexWithUV(4.0f, -1.5f, this.field_73735_i, 8.0f * d, 80.0f * d);
        tessellator.addVertexWithUV(-4.0f, -1.5f, this.field_73735_i, 0.0f, 80.0f * d);
        tessellator.addVertexWithUV(-4.0f, 1.5f, this.field_73735_i, 0.0f, 83.0f * d);
        tessellator.draw();
        GL11.glPopMatrix();
    }

    private void drawWatch() {
        int startX = this.field_146294_l / 2 + 112;
        int startY = this.field_146295_m - 16;
        int t0 = this.getWorldTime();
        int t1 = (t0 / 1000 + 6) % 12;
        float hour = 360.0f * (float)t1 / 12.0f;
        this.drawMeter(startX, startY, 32, 96, 48, hour + 135.0f, 512);
        int t2 = (int)((float)(t0 % 1000) * 0.06f);
        float minute = 360.0f * (float)t2 / 60.0f;
        this.drawMeter(startX, startY, 32, 128, 48, minute + 135.0f, 512);
    }

    public void func_73729_b(int x, int y, int u, int v, int w, int h) {
        this.drawRectangle(x, y, u, v, w, h, 512);
    }

    public void drawRectangle(int x, int y, int u, int v, int w, int h, int texSize) {
        this.drawRectangle(x, y, 0, 0, w, h, u, v, texSize);
    }

    public void drawRectangle(int startX, int startY, int offsetX, int offsetY, int w, int h, int u, int v, int texSize) {
        float fu = 1.0f / (float)texSize;
        float fv = 1.0f / (float)texSize;
        int x = startX + offsetX;
        int y = startY + offsetY;
        float z = this.field_73735_i;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((float)x, (float)(y + h), z, (float)(u + 0) * fu, (float)(v + h) * fv);
        tessellator.addVertexWithUV((float)(x + w), (float)(y + h), z, (float)(u + w) * fu, (float)(v + h) * fv);
        tessellator.addVertexWithUV((float)(x + w), (float)y, z, (float)(u + w) * fu, (float)(v + 0) * fv);
        tessellator.addVertexWithUV((float)x, (float)y, z, (float)(u + 0) * fu, (float)(v + 0) * fv);
        tessellator.draw();
    }

    public void drawMeter(int startX, int startY, int size, int u, int v, float rotation, int texSize) {
        int offset = -(size / 2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)startX, (float)startY, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.drawRectangle(0, 0, offset, offset, size, size, u, v, texSize);
        GL11.glPopMatrix();
    }

    protected void renderScope(int w, int h) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        float d0 = (float)(w - h) / 2.0f;
        float d1 = -90.0f;
        NGTUtilClient.bindTexture((ResourceLocation)TEX_SCOPE);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(d0, (float)h, d1, 0.0f, 1.0f);
        tessellator.addVertexWithUV(d0 + (float)h, (float)h, d1, 1.0f, 1.0f);
        tessellator.addVertexWithUV(d0 + (float)h, 0.0f, d1, 1.0f, 0.0f);
        tessellator.addVertexWithUV(d0, 0.0f, d1, 0.0f, 0.0f);
        tessellator.draw();
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0);
        tessellator.addVertexWithUV(0.0f, (float)h, d1, 0.0f, 1.0f);
        tessellator.addVertexWithUV(d0, (float)h, d1, 1.0f, 1.0f);
        tessellator.addVertexWithUV(d0, 0.0f, d1, 1.0f, 0.0f);
        tessellator.addVertexWithUV(0.0f, 0.0f, d1, 0.0f, 0.0f);
        tessellator.addVertexWithUV(d0 + (float)h, (float)h, d1, 0.0f, 1.0f);
        tessellator.addVertexWithUV((float)w, (float)h, d1, 1.0f, 1.0f);
        tessellator.addVertexWithUV((float)w, 0.0f, d1, 1.0f, 0.0f);
        tessellator.addVertexWithUV(d0 + (float)h, 0.0f, d1, 0.0f, 0.0f);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderNVD(int w, int h) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)1, (int)1, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        float d0 = (float)(w - h) / 2.0f;
        float d1 = -90.0f;
        NGTTessellator tessellator = NGTTessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x309030);
        tessellator.addVertexWithUV(0.0f, (float)h, d1, 0.0f, 1.0f);
        tessellator.addVertexWithUV((float)w, (float)h, d1, 1.0f, 1.0f);
        tessellator.addVertexWithUV((float)w, 0.0f, d1, 1.0f, 0.0f);
        tessellator.addVertexWithUV(0.0f, 0.0f, d1, 0.0f, 0.0f);
        tessellator.draw();
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NGTUtilClient.bindTexture((ResourceLocation)TEX_NVD);
        tessellator.startDrawingQuads();
        float f0 = (float)h / (float)w * 0.5f;
        tessellator.addVertexWithUV(0.0f, (float)h, d1, 0.0f, 0.5f + f0);
        tessellator.addVertexWithUV((float)w, (float)h, d1, 1.0f, 0.5f + f0);
        tessellator.addVertexWithUV((float)w, 0.0f, d1, 1.0f, 0.5f - f0);
        tessellator.addVertexWithUV(0.0f, 0.0f, d1, 0.0f, 0.5f - f0);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

