/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.io.IOException;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.ColorUtil;
import jp.ngt.rtm.item.PaintProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiPaintTool
extends GuiScreenCustom {
    private static ResourceLocation texture = new ResourceLocation("rtm", "textures/gui/paint_tool.png");
    private final EntityPlayer player;
    private final ItemStack paintItem;
    private PaintProperty prop;
    private int color;
    private int paintTypeIndex;
    private GuiTextField colorR;
    private GuiTextField colorG;
    private GuiTextField colorB;
    private GuiTextField colorHex;
    private GuiTextField alpha;
    private GuiTextField radius;
    private GuiButton type;

    public GuiPaintTool(EntityPlayer par1) {
        this.player = par1;
        this.paintItem = par1.field_71071_by.func_70448_g();
        this.prop = PaintProperty.getProperty(this.paintItem);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.paintTypeIndex = this.prop.type;
        int halfW = this.field_146294_l / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, halfW - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, halfW + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.type = new GuiButtonPenType(100, halfW + 40, 20);
        this.field_146292_n.add(this.type);
        this.textFields.clear();
        this.colorR = this.setTextField(halfW - 80, 20, 60, 20, "");
        this.colorG = this.setTextField(halfW - 80, 40, 60, 20, "");
        this.colorB = this.setTextField(halfW - 80, 60, 60, 20, "");
        this.colorHex = this.setTextField(halfW - 80, 85, 60, 20, "");
        this.alpha = this.setTextField(halfW - 80, 110, 60, 20, String.valueOf(this.prop.alpha));
        this.radius = this.setTextField(halfW + 28, 60, 40, 20, String.valueOf(this.prop.radius));
        this.setColor(this.prop.color, 15);
    }

    private void setColor(int c, int flag) {
        this.color = c;
        this.prop.color = c;
        if ((flag & 1) != 0) {
            this.colorR.func_146180_a(String.valueOf(ColorUtil.getR((int)this.color)));
        }
        if ((flag & 2) != 0) {
            this.colorG.func_146180_a(String.valueOf(ColorUtil.getG((int)this.color)));
        }
        if ((flag & 4) != 0) {
            this.colorB.func_146180_a(String.valueOf(ColorUtil.getB((int)this.color)));
        }
        if ((flag & 8) != 0) {
            this.colorHex.func_146180_a(ColorUtil.toString((int)this.color));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.sendPacket();
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 100) {
            ++this.paintTypeIndex;
            if (this.paintTypeIndex >= PaintProperty.EnumPaintType.values().length) {
                this.paintTypeIndex = 0;
            }
            this.prop.type = this.paintTypeIndex;
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.currentTextField != null) {
            try {
                if (this.currentTextField == this.colorR) {
                    int r = Integer.valueOf(this.colorR.func_146179_b());
                    int c = ColorUtil.encode((int)r, (int)ColorUtil.getG((int)this.color), (int)ColorUtil.getB((int)this.color));
                    this.setColor(c, 14);
                } else if (this.currentTextField == this.colorG) {
                    int g = Integer.valueOf(this.colorG.func_146179_b());
                    int c = ColorUtil.encode((int)ColorUtil.getR((int)this.color), (int)g, (int)ColorUtil.getB((int)this.color));
                    this.setColor(c, 13);
                } else if (this.currentTextField == this.colorB) {
                    int b = Integer.valueOf(this.colorB.func_146179_b());
                    int c = ColorUtil.encode((int)ColorUtil.getR((int)this.color), (int)ColorUtil.getG((int)this.color), (int)b);
                    this.setColor(c, 11);
                } else if (this.currentTextField == this.colorHex) {
                    int c = ColorUtil.toInteger((String)this.colorHex.func_146179_b());
                    this.setColor(c, 7);
                } else if (this.currentTextField == this.alpha) {
                    int a;
                    this.prop.alpha = a = Integer.valueOf(this.alpha.func_146179_b()).intValue();
                } else if (this.currentTextField == this.radius) {
                    int r;
                    this.prop.radius = r = Integer.valueOf(this.radius.func_146179_b()).intValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void sendPacket() {
        this.prop.setProperty(this.paintItem);
        PacketNBT.sendToServer((EntityPlayer)this.player, (ItemStack)this.paintItem);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        int halfW = this.field_146294_l / 2;
        this.func_73732_a(this.field_146289_q, "R", halfW - 90, 25, 0xFF0000);
        this.func_73732_a(this.field_146289_q, "G", halfW - 90, 45, 65280);
        this.func_73732_a(this.field_146289_q, "B", halfW - 90, 65, 255);
        this.func_73732_a(this.field_146289_q, "Hex", halfW - 90, 90, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Alpha", halfW - 95, 115, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Radius", halfW + 12, 65, 0xFFFFFF);
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(this.color, 255);
        tessellator.addVertex((float)(halfW + 8), 20.0f, this.field_73735_i);
        tessellator.addVertex((float)(halfW + 8), 52.0f, this.field_73735_i);
        tessellator.addVertex((float)(halfW + 40), 52.0f, this.field_73735_i);
        tessellator.addVertex((float)(halfW + 40), 20.0f, this.field_73735_i);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    private class GuiButtonPenType
    extends GuiButton {
        public GuiButtonPenType(int id, int xPos, int yPos) {
            super(id, xPos, yPos, 32, 32, "");
        }

        public void func_191745_a(Minecraft mc, int x, int y, float ptick) {
            if (this.field_146125_m) {
                PaintProperty.EnumPaintType pType = PaintProperty.EnumPaintType.values()[GuiPaintTool.this.paintTypeIndex];
                mc.func_110434_K().func_110577_a(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, pType.iconU, pType.iconV, this.field_146120_f, this.field_146121_g);
                this.func_146119_b(mc, x, y);
            }
        }
    }
}

