/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.electric.SignalConverterType;
import jp.ngt.rtm.electric.TileEntitySignalConverter;
import jp.ngt.rtm.network.PacketSignalConverter;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSignalConverter
extends GuiScreenCustom {
    private final TileEntitySignalConverter tileEntity;
    private final SignalConverterType scType;
    private GuiButton button;
    private GuiTextField[] signalValues;
    private int comparatorIndex = 0;

    public GuiSignalConverter(TileEntitySignalConverter par1) {
        this.tileEntity = par1;
        this.scType = SignalConverterType.getType(par1.func_145832_p());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        int i0 = 0;
        if (this.scType == SignalConverterType.RSOut) {
            TileEntitySignalConverter.ComparatorType type = this.tileEntity.getComparator();
            this.comparatorIndex = type.id;
            this.button = new GuiButton(100, this.field_146294_l / 2 - 36, 60, 30, 20, type.operator);
            this.field_146292_n.add(this.button);
            i0 = 16;
        }
        int[] ia = this.tileEntity.getSignalLevel();
        this.textFields.clear();
        this.signalValues = new GuiTextField[this.scType == SignalConverterType.RSOut ? 1 : 2];
        this.signalValues[0] = this.setTextField(this.field_146294_l / 2 - 20 + i0, 60, 40, 20, String.valueOf(ia[0]));
        if (this.scType == SignalConverterType.RSIn || this.scType == SignalConverterType.Wireless) {
            this.signalValues[1] = this.setTextField(this.field_146294_l / 2 - 20 + i0, 100, 40, 20, String.valueOf(ia[1]));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(null);
            this.sendPacket();
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 100) {
            this.comparatorIndex = (this.comparatorIndex + 1) % TileEntitySignalConverter.ComparatorType.values().length;
            this.button.field_146126_j = TileEntitySignalConverter.ComparatorType.getType((int)this.comparatorIndex).operator;
        }
        super.func_146284_a(button);
    }

    private void sendPacket() {
        int[] ia = this.formatSignalLevel();
        if (this.scType != SignalConverterType.RSIn && this.scType != SignalConverterType.Wireless) {
            ia[1] = 0;
        }
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSignalConverter(this.tileEntity, this.comparatorIndex, ia[0], ia[1]));
    }

    private int[] formatSignalLevel() {
        int[] ia = new int[2];
        for (int i = 0; i < this.signalValues.length; ++i) {
            int max = Short.MAX_VALUE;
            if (this.scType == SignalConverterType.Wireless) {
                if (i == 1) {
                    max = 25;
                }
            } else {
                max = 127;
            }
            int i0 = NGTMath.getIntFromString((String)this.signalValues[i].func_146179_b(), (int)0, (int)max, (int)0);
            this.signalValues[i].func_146180_a(String.valueOf(i0));
            ia[i] = i0;
        }
        return ia;
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.currentTextField != null && (par2 >= 2 && par2 <= 11 || par2 >= 200 && par2 <= 205 || par2 == 12 || par2 == 14 || par2 == 211)) {
            this.currentTextField.func_146201_a(par1, par2);
        }
        if (par2 == 28) {
            this.formatSignalLevel();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        if (this.scType == SignalConverterType.RSIn) {
            this.func_73732_a(this.field_146289_q, "Output signal level", this.field_146294_l / 2, 30, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "RS_ON", this.field_146294_l / 2, 45, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "RS_OFF", this.field_146294_l / 2, 85, 0xFFFFFF);
        } else if (this.scType == SignalConverterType.RSOut) {
            this.func_73732_a(this.field_146289_q, "Input signal level", this.field_146294_l / 2, 40, 0xFFFFFF);
        } else if (this.scType == SignalConverterType.Wireless) {
            this.func_73732_a(this.field_146289_q, "Channel", this.field_146294_l / 2, 45, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "Chunk Load Range", this.field_146294_l / 2, 85, 0xFFFFFF);
        }
    }
}

