/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.gui.GuiTextFieldCustom;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tt.SignboardText;
import jp.ngt.rtm.gui.GuiButtonSelectTexture;
import jp.ngt.rtm.gui.GuiSelectTexture;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.cfg.SignboardConfig;
import jp.ngt.rtm.modelpack.modelset.TextureSetSignboard;
import jp.ngt.rtm.modelpack.state.ResourceStateSignboard;
import jp.ngt.rtm.network.PacketSelectResource;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSignboard
extends GuiScreenCustom {
    private static final int COLOR_ON = 0xFFFFFF;
    private static final int COLOR_OFF = 0xA0A0A0;
    private static final float SELECT_TICKNESS = 3.0f;
    private final IResourceSelector<TextureSetSignboard> selector;
    private ResourceStateSignboard state;
    private SignboardText currentTextObj;
    private GuiTextFieldCustom fieldText;
    private GuiButton buttonFont;
    private GuiTextFieldCustom fieldColor;
    private GuiButton buttonBold;
    private GuiButton buttonItalic;
    private GuiTextFieldCustom fieldTextSize;
    private GuiTextFieldCustom fieldTextWidth;
    private GuiTextFieldCustom fieldTextPosU;
    private GuiTextFieldCustom fieldTextPosV;
    private GuiButton buttonAnimeType;
    private GuiTextFieldCustom fieldAnimeSpeed;
    private GuiTextFieldCustom fieldStationSetting;
    private GuiButton dummyButton;
    private int style;
    private int animeTypeIndex;
    private float scale;
    private boolean resetState;
    private boolean draging;
    private int dragState;
    private int prevDragX;
    private int prevDragY;

    public GuiSignboard(IResourceSelector par1) {
        this.selector = par1;
        this.resetState = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.resetState) {
            this.state = (ResourceStateSignboard)this.selector.getResourceState();
            this.resetState = false;
        }
        int hw = this.field_146294_l / 2;
        int buttonArea = 130;
        int ba1 = this.field_146294_l - buttonArea;
        int ba2 = ba1 + 5;
        int h2 = this.field_146295_m - 30;
        this.field_146292_n.clear();
        TextureSetSignboard set = (TextureSetSignboard)this.state.getResourceSet();
        float sbw = ((SignboardConfig)set.getConfig()).width;
        if (((SignboardConfig)set.getConfig()).backTexture == 1) {
            sbw *= 2.0f;
        }
        float ratioTex = ((SignboardConfig)set.getConfig()).height / sbw;
        float ratioGui = (float)h2 / (float)ba1;
        int sizeX = 0;
        int sizeY = 0;
        if (ratioTex > ratioGui) {
            sizeX = (int)((float)h2 / ratioTex);
            sizeY = h2;
        } else {
            sizeX = ba1;
            sizeY = (int)((float)ba1 * ratioTex);
        }
        this.scale = (float)sizeY / ((SignboardConfig)set.getConfig()).height;
        this.dummyButton = new GuiButtonSelectTexture(300, 0, 0, sizeX, sizeY, RTMResource.SIGNBOARD, set);
        this.func_189646_b(new GuiButton(0, hw - 155, this.field_146295_m - 25, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(1, hw + 5, this.field_146295_m - 25, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(100, ba2, 5, 120, 20, "Select texture"));
        this.func_189646_b(new GuiButton(101, ba2, 25, 30, 20, "Add"));
        this.func_189646_b(new GuiButton(102, ba2 + 30, 25, 30, 20, "Copy"));
        this.func_189646_b(new GuiButton(103, ba2 + 60, 25, 30, 20, "Del"));
        this.func_189646_b(new GuiButton(104, ba2 + 90, 25, 30, 20, "Redraw"));
        List<SignboardText> list = this.state.texts;
        if (this.currentTextObj == null && !list.isEmpty()) {
            this.currentTextObj = list.get(0);
        }
        if (this.currentTextObj != null) {
            this.fieldText = this.setTextField(ba2, 48, 120, 20, this.currentTextObj.getRawText());
            this.fieldText.addTips("If use timetable -> tt(col=<colmun_num>,offset=<offset_num>)");
            this.fieldText.addTips("  col=-1 -> display train name");
            this.buttonFont = this.func_189646_b(new GuiButton(200, ba2, 70, 120, 20, this.currentTextObj.getText().getFont()));
            String colorCode = "0x" + Integer.toHexString(this.currentTextObj.getText().getColor());
            this.fieldColor = this.setTextField(ba2, 100, 80, 20, colorCode);
            this.buttonBold = this.func_189646_b(new GuiButton(201, ba2 + 80, 100, 20, 20, "B"));
            this.buttonItalic = this.func_189646_b(new GuiButton(202, ba2 + 100, 100, 20, 20, "I"));
            this.fieldTextSize = this.setTextField(ba2, 130, 60, 20, String.valueOf(this.currentTextObj.size));
            this.fieldTextWidth = this.setTextField(ba2 + 60, 130, 60, 20, String.valueOf(this.currentTextObj.width));
            this.fieldTextPosU = this.setTextField(ba2, 160, 60, 20, String.valueOf(this.currentTextObj.posU));
            this.fieldTextPosV = this.setTextField(ba2 + 60, 160, 60, 20, String.valueOf(this.currentTextObj.posV));
            this.buttonAnimeType = this.func_189646_b(new GuiButton(203, ba2, 190, 60, 20, this.currentTextObj.animeType.toString()));
            this.fieldAnimeSpeed = this.setTextField(ba2 + 60, 190, 60, 20, String.valueOf(this.currentTextObj.animeSpeed));
            this.fieldStationSetting = this.setTextField(ba2, 220, 120, 20, this.state.getTTSetting());
            this.fieldStationSetting.addTips("tt=<file_name>,station=<station_name>,track=<track_num>");
            this.animeTypeIndex = this.currentTextObj.animeType.ordinal();
            this.style = this.currentTextObj.getText().getStyle();
            this.buttonBold.packedFGColour = (this.style & 1) != 0 ? 0xFFFFFF : 0xA0A0A0;
            this.buttonItalic.packedFGColour = (this.style & 2) != 0 ? 0xFFFFFF : 0xA0A0A0;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.dummyButton.func_191745_a(this.field_146297_k, par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
        for (SignboardText text : this.state.texts) {
            float x = text.posU * this.scale;
            float y = text.posV * this.scale;
            text.render(x, y, this.field_73735_i, this.scale);
            if (text != this.currentTextObj) continue;
            this.drawSelectedText(text, x, y, par1, par2);
        }
        if (this.currentTextObj != null) {
            int buttonArea = 130;
            int ba1 = this.field_146294_l - buttonArea;
            int ba2 = ba1 + 5;
            this.func_73731_b(this.field_146289_q, " Color               Style", ba2, 91, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, " height         Width", ba2, 121, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, " PosU           PosV", ba2, 151, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, " AnimeType      AnimeSpeed", ba2, 181, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, " StationSetting", ba2, 211, 0xFFFFFF);
        }
        if (this.draging) {
            this.updateDragState(par1, par2);
        }
    }

    private void drawSelectedText(SignboardText text, float x, float y, int mouseX, int mouseY) {
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        tessellator.setColorOpaque_I(0xFF0000);
        NGTRenderHelper.addQuadGuiFrameWithSize((float)x, (float)y, (float)(text.width * this.scale), (float)(text.size * this.scale), (float)this.field_73735_i);
        tessellator.draw();
        int state = this.getClickState(text, mouseX, mouseY);
        boolean moveNX = (state & 8) > 0;
        boolean movePX = (state & 4) > 0;
        boolean moveNY = (state & 2) > 0;
        boolean movePY = (state & 1) > 0;
        float hSize = 3.0f;
        float minX = text.posU * this.scale;
        float minY = text.posV * this.scale;
        float maxX = text.width * this.scale + minX;
        float maxY = text.size * this.scale + minY;
        if (moveNX && moveNY || moveNX && movePY || movePX && moveNY || movePX && movePY) {
            tessellator.startDrawing(7);
            tessellator.setColorOpaque_I(0xFF0000);
            NGTRenderHelper.addQuadGuiFace((float)(minX - hSize), (float)(minY - hSize), (float)(minX + hSize), (float)(minY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(maxX - hSize), (float)(minY - hSize), (float)(maxX + hSize), (float)(minY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(minX - hSize), (float)(maxY - hSize), (float)(minX + hSize), (float)(maxY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(maxX - hSize), (float)(maxY - hSize), (float)(maxX + hSize), (float)(maxY + hSize), (float)this.field_73735_i);
            tessellator.draw();
        } else if (moveNX || movePX || moveNY || movePY) {
            float centerX = (minX + maxX) * 0.5f;
            float centerY = (minY + maxY) * 0.5f;
            tessellator.startDrawing(7);
            tessellator.setColorOpaque_I(0xFF0000);
            NGTRenderHelper.addQuadGuiFace((float)(minX - hSize), (float)(centerY - hSize), (float)(minX + hSize), (float)(centerY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(maxX - hSize), (float)(centerY - hSize), (float)(maxX + hSize), (float)(centerY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(centerX - hSize), (float)(minY - hSize), (float)(centerX + hSize), (float)(minY + hSize), (float)this.field_73735_i);
            NGTRenderHelper.addQuadGuiFace((float)(centerX - hSize), (float)(maxY - hSize), (float)(centerX + hSize), (float)(maxY + hSize), (float)this.field_73735_i);
            tessellator.draw();
        }
        GL11.glEnable((int)3553);
    }

    private void updateDragState(int x, int y) {
        if (!Mouse.isButtonDown((int)0)) {
            this.draging = false;
        }
        if (this.currentTextObj != null) {
            float difX = (float)(x - this.prevDragX) / this.scale;
            float difY = (float)(y - this.prevDragY) / this.scale;
            if (this.dragState == 0) {
                this.currentTextObj.posU += difX;
                this.currentTextObj.posV += difY;
            } else {
                boolean movePY;
                boolean moveNX = (this.dragState & 8) > 0;
                boolean movePX = (this.dragState & 4) > 0;
                boolean moveNY = (this.dragState & 2) > 0;
                boolean bl = movePY = (this.dragState & 1) > 0;
                if (moveNX) {
                    this.currentTextObj.posU += difX;
                    this.currentTextObj.width -= difX;
                }
                if (movePX) {
                    this.currentTextObj.width += difX;
                }
                if (moveNY) {
                    this.currentTextObj.posV += difY;
                    this.currentTextObj.size -= difY;
                }
                if (movePY) {
                    this.currentTextObj.size += difY;
                }
            }
            this.fieldTextPosU.func_146180_a(String.valueOf(this.currentTextObj.posU));
            this.fieldTextPosV.func_146180_a(String.valueOf(this.currentTextObj.posV));
            this.fieldTextSize.func_146180_a(String.valueOf(this.currentTextObj.size));
            this.fieldTextWidth.func_146180_a(String.valueOf(this.currentTextObj.width));
            this.prevDragX = x;
            this.prevDragY = y;
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        boolean selected;
        super.func_73864_a(x, y, button);
        SignboardText clickedObj = null;
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        for (SignboardText text : this.state.texts) {
            minX = text.posU * this.scale;
            minY = text.posV * this.scale;
            maxX = text.width * this.scale + minX;
            maxY = text.size * this.scale + minY;
            if (!((float)x >= minX - 3.0f) || !((float)x <= maxX + 3.0f) || !((float)y >= minY - 3.0f) || !((float)y <= maxY + 3.0f)) continue;
            clickedObj = text;
            break;
        }
        boolean bl = selected = this.currentTextObj != null && this.currentTextObj == clickedObj;
        if (clickedObj != null) {
            this.updateText();
            this.currentTextObj = clickedObj;
            this.func_73866_w_();
            if (selected) {
                this.draging = true;
                this.prevDragX = x;
                this.prevDragY = y;
                this.dragState = this.getClickState(clickedObj, x, y);
            }
        }
    }

    private int getClickState(SignboardText text, int x, int y) {
        int state = 0;
        float minX = text.posU * this.scale;
        float minY = text.posV * this.scale;
        float maxX = text.width * this.scale + minX;
        float maxY = text.size * this.scale + minY;
        if (this.inRange(x, minX, 3.0f)) {
            state += 8;
        }
        if (this.inRange(x, maxX, 3.0f)) {
            state += 4;
        }
        if (this.inRange(y, minY, 3.0f)) {
            state += 2;
        }
        if (this.inRange(y, maxY, 3.0f)) {
            ++state;
        }
        return state;
    }

    private boolean inRange(float target, float center, float tickness) {
        return target >= center - tickness && target <= center + tickness;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.saveState();
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 100) {
            this.saveState();
            this.resetState = true;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectTexture(this.selector, (GuiScreen)this));
        } else if (button.field_146127_k == 101) {
            this.updateText();
            this.currentTextObj = new SignboardText(true, this.state.geTimeTable());
            this.state.texts.add(this.currentTextObj);
            this.func_73866_w_();
        } else if (button.field_146127_k == 102) {
            if (this.currentTextObj != null) {
                this.updateText();
                this.currentTextObj = this.currentTextObj.copy();
                this.state.texts.add(this.currentTextObj);
                this.func_73866_w_();
            }
        } else if (button.field_146127_k == 103) {
            if (this.currentTextObj != null) {
                this.state.texts.remove(this.currentTextObj);
                this.currentTextObj = null;
                this.func_73866_w_();
            }
        } else if (button.field_146127_k == 104) {
            this.updateText();
        } else if (button.field_146127_k == 200) {
            this.openFontGui(this.currentTextObj.getText().getFont());
        } else if (button.field_146127_k == 201) {
            this.style ^= 1;
            this.buttonBold.packedFGColour = (this.style & 1) != 0 ? 0xFFFFFF : 0xA0A0A0;
        } else if (button.field_146127_k == 202) {
            this.style ^= 2;
            this.buttonItalic.packedFGColour = (this.style & 2) != 0 ? 0xFFFFFF : 0xA0A0A0;
        } else if (button.field_146127_k == 203) {
            this.animeTypeIndex = (this.animeTypeIndex + 1) % SignboardText.AnimeType.values().length;
            this.buttonAnimeType.field_146126_j = SignboardText.AnimeType.values()[this.animeTypeIndex].toString();
        }
        super.func_146284_a(button);
    }

    public void setFont(String name) {
        this.buttonFont.field_146126_j = name;
    }

    private void saveState() {
        if (this.currentTextObj != null) {
            this.state.setTTSetting(this.fieldStationSetting.func_146179_b());
        }
        if (this.selector.closeGui(this.state)) {
            RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSelectResource(this.selector));
        }
    }

    private void updateText() {
        if (this.currentTextObj == null) {
            return;
        }
        String text = this.fieldText.func_146179_b();
        String font = this.buttonFont.field_146126_j;
        int color = Integer.decode(this.fieldColor.func_146179_b());
        this.currentTextObj.posU = Float.valueOf(this.fieldTextPosU.func_146179_b()).floatValue();
        this.currentTextObj.posV = Float.valueOf(this.fieldTextPosV.func_146179_b()).floatValue();
        this.currentTextObj.size = Float.valueOf(this.fieldTextSize.func_146179_b()).floatValue();
        this.currentTextObj.width = Float.valueOf(this.fieldTextWidth.func_146179_b()).floatValue();
        this.currentTextObj.animeType = SignboardText.AnimeType.values()[this.animeTypeIndex];
        this.currentTextObj.animeSpeed = Float.valueOf(this.fieldAnimeSpeed.func_146179_b()).floatValue();
        this.currentTextObj.setText(text, font, this.style, color, true);
    }

    private void openFontGui(String prevFont) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        int index = 0;
        for (int i = 0; i < fonts.length; ++i) {
            if (!prevFont.equals(fonts[i].getFontName())) continue;
            index = i;
            break;
        }
        JComboBox<Font> box = new JComboBox<Font>(fonts);
        box.setSelectedIndex(index);
        box.setRenderer(new ComboItemFont());
        this.openListGui("Select Font", box, event -> {
            String fontName = ((Font)box.getSelectedItem()).getName();
            this.setFont(fontName);
        });
    }

    private <E> void openListGui(String name, JComboBox<E> box, ActionListener ok) {
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(0);
        frame.setSize(320, 180);
        frame.setLocationByPlatform(true);
        frame.setResizable(false);
        JPanel panelSelectFont = new JPanel();
        panelSelectFont.add(box);
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(event -> {
            ok.actionPerformed(event);
            frame.dispose();
        });
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(event -> frame.dispose());
        JPanel panelButton = new JPanel();
        panelButton.setLayout(new BoxLayout(panelButton, 0));
        panelButton.add(buttonOK);
        panelButton.add(buttonCancel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(panelSelectFont);
        panel.add(panelButton);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
    }

    public class ComboItemFont
    extends JLabel
    implements ListCellRenderer {
        public ComboItemFont() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font = (Font)value;
            this.setText(font.getName());
            this.setFont(new Font(font.getName(), font.getStyle(), 12));
            if (isSelected) {
                this.setForeground(Color.white);
                this.setBackground(Color.black);
            } else {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
            }
            return this;
        }
    }
}

