/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui.camera;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.ColorUtil;
import jp.ngt.rtm.gui.camera.CameraKey;
import jp.ngt.rtm.gui.camera.CameraKeySet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL43;

public final class Camera {
    public static final Camera INSTANCE = new Camera();
    private static final int DELAY = 10;
    private static final int GAUS_MAX = 24;
    private static final int DEPTH_SPLIT = 8;
    private static final float GAUS_COEF = 20.0f;
    private static final float MIN_DEPTH = 0.75f;
    private final float[] gaussianWeights = new float[24];
    private final FloatBuffer gaussianWeightsBuf = GLAllocation.func_74529_h((int)24);
    private final int[] gaussianFBO = new int[]{-1, -1, -1};
    private final int[] gaussianTex = new int[]{-1, -1, -1};
    private final int[] mcScreenTex = new int[]{-1, -1};
    @Deprecated
    private int mcDepthTex = -1;
    private int dofShader = -1;
    private FloatBuffer depthBuffer;
    private IntBuffer depthColorBuffer;
    private boolean isActive;
    private boolean mcTexRendered;
    private float scale = 1.0f;
    private float sensitivity = 1.0f;
    private float focus = 0.5f;
    private int focusMode;
    private float fovModification = 1.0f;
    private float frameBufU = 1.0f;
    private float frameBufV = 1.0f;
    private int tickCount;

    private Camera() {
        int i;
        for (i = 0; i < this.gaussianFBO.length; ++i) {
            this.gaussianFBO[i] = GL30.glGenFramebuffers();
            this.gaussianTex[i] = GL11.glGenTextures();
        }
        for (i = 0; i < 2; ++i) {
            this.mcScreenTex[i] = GL11.glGenTextures();
        }
        this.mcDepthTex = GL11.glGenTextures();
    }

    private void init(int w, int h) {
        int i;
        for (i = 0; i < this.gaussianFBO.length; ++i) {
            this.initTexture(this.gaussianTex[i], w, h);
            GL30.glBindFramebuffer((int)36160, (int)this.gaussianFBO[i]);
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.gaussianTex[i], (int)0);
            GL30.glBindFramebuffer((int)36160, (int)0);
        }
        for (i = 0; i < 2; ++i) {
            this.initTexture(this.mcScreenTex[i], w, h);
        }
        try {
            String vsh = NGTText.getText((ResourceLocation)new ResourceLocation("rtm", "shaders/dof.vsh"), (boolean)true);
            String fsh = NGTText.getText((ResourceLocation)new ResourceLocation("rtm", "shaders/dof.fsh"), (boolean)true);
            this.dofShader = GLHelper.getShaderProgram((String)vsh, (String)fsh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.depthBuffer == null || this.depthBuffer.capacity() < w * h) {
            this.depthBuffer = GLAllocation.func_74529_h((int)(w * h));
            this.depthColorBuffer = GLAllocation.func_74527_f((int)(w * h));
        }
    }

    private void initTexture(int texture, int w, int h) {
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)w, (int)h, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glBindTexture((int)3553, (int)0);
    }

    public void onRenderGameOverlayPre() {
        if (!this.isActive) {
            return;
        }
        if (this.sensitivity < 1.0f && this.sensitivity < 1.0f) {
            if (this.tickCount >= 10) {
                this.tickCount = 0;
                this.copyScreenBuf(0);
            }
            ++this.tickCount;
        }
    }

    public void onRenderWorldPost() {
        if (!this.isActive) {
            return;
        }
        if (this.focusMode > 0) {
            this.copyDepthBuffer();
            this.copyScreenBuf(1);
        }
    }

    private void copyScreenBuf(int texId) {
        this.mcTexRendered = true;
        Minecraft mc = Minecraft.func_71410_x();
        int w = mc.func_147110_a().field_147622_a;
        int h = mc.func_147110_a().field_147620_b;
        GL43.glCopyImageSubData((int)mc.func_147110_a().field_147617_g, (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.mcScreenTex[texId], (int)3553, (int)0, (int)0, (int)0, (int)0, (int)w, (int)h, (int)1);
        this.frameBufU = (float)mc.func_147110_a().field_147621_c / (float)mc.func_147110_a().field_147622_a;
        this.frameBufV = (float)mc.func_147110_a().field_147618_d / (float)mc.func_147110_a().field_147620_b;
    }

    private void copyDepthBuffer() {
        Minecraft mc = Minecraft.func_71410_x();
        int w = mc.func_147110_a().field_147622_a;
        int h = mc.func_147110_a().field_147620_b;
        this.depthBuffer.clear();
        GL11.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6402, (int)5126, (FloatBuffer)this.depthBuffer);
        this.depthColorBuffer.clear();
        for (int i = 0; i < this.depthBuffer.capacity(); ++i) {
            float depth = this.depthBuffer.get(i);
            this.depthColorBuffer.put(this.depth2Color(depth));
        }
        this.depthColorBuffer.flip();
        GL11.glBindTexture((int)3553, (int)this.gaussianTex[2]);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (IntBuffer)this.depthColorBuffer);
        if (this.focusMode == 1) {
            int index = h / 2 * w + w / 2;
            int g = ColorUtil.getG((int)this.depthColorBuffer.get(index));
            this.focus = (float)g / 255.0f;
        }
    }

    private int depth2Color(float depth) {
        int c0 = (int)(this.fixDepth(depth) * 255.0f);
        return ColorUtil.encode((int)c0, (int)c0, (int)c0);
    }

    private float fixDepth(float depth) {
        if (depth >= 0.75f) {
            double d0 = (depth - 0.75f) / 0.25f;
            if (d0 >= 1.0) {
                return 1.0f;
            }
            d0 *= d0;
            d0 *= d0;
            d0 *= d0;
            return (float)(-Math.sqrt(1.0 - d0) + 1.0);
        }
        return 0.0f;
    }

    public void off() {
        if (this.isActive) {
            this.isActive = false;
            this.mcTexRendered = false;
            this.tickCount = 0;
        }
    }

    public void render(Minecraft mc, RenderGameOverlayEvent event, int guiW, int guiH) {
        int w = mc.field_71443_c;
        int h = mc.field_71440_d;
        if (!this.isActive) {
            this.isActive = true;
            this.init(w, h);
        }
        GL11.glDisable((int)2929);
        if (this.sensitivity < 1.0f) {
            this.renderDelayFrame(mc, guiW, guiH);
        }
        if (this.focusMode > 0 && this.dofShader > 0) {
            this.checkScreenshot(w, h, "ss_depth");
            this.renderDOF(mc, guiW, guiH);
        }
        GL11.glEnable((int)2929);
        this.updateKeyState();
        this.renderText(mc, guiW, guiH);
    }

    private void renderDelayFrame(Minecraft mc, int guiW, int guiH) {
        if (!this.mcTexRendered) {
            return;
        }
        int alpha = (int)(255.0f * (1.0f - this.sensitivity));
        GL11.glBindTexture((int)3553, (int)this.mcScreenTex[0]);
        this.renderBuffer(guiW, guiH, alpha, true);
    }

    private void renderDOF(Minecraft mc, int guiW, int guiH) {
        if (!this.mcTexRendered) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)this.dofShader);
        ARBShaderObjects.glUniform1iARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"texture0"), (int)0);
        ARBShaderObjects.glUniform1iARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"texture1"), (int)1);
        ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"width"), (float)guiW);
        ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"height"), (float)guiH);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.gaussianTex[2]);
        for (int frame = 8; frame > 0; --frame) {
            float blurThreshold = (float)frame / 8.0f;
            double blurStrMax = 24.0 * ((double)mc.field_71443_c / 1500.0);
            if (blurStrMax > 24.0) {
                blurStrMax = 24.0;
            }
            float focusDif = Math.abs(blurThreshold - this.focus);
            int range = (int)Math.floor(NGTMath.sigmoid((double)((double)focusDif * 2.0), (double)7.0) * blurStrMax);
            int maxIndex = this.calcGaussian(range);
            ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"threshold"), (float)blurThreshold);
            ARBShaderObjects.glUniform1ARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"weight"), (FloatBuffer)this.gaussianWeightsBuf);
            for (int pass = 0; pass < 2; ++pass) {
                ARBShaderObjects.glUniform1iARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.dofShader, (CharSequence)"pass"), (int)pass);
                GL30.glBindFramebuffer((int)36160, (int)this.gaussianFBO[pass]);
                switch (pass) {
                    case 0: {
                        GL13.glActiveTexture((int)33984);
                        GL11.glBindTexture((int)3553, (int)this.mcScreenTex[1]);
                        break;
                    }
                    case 1: {
                        GL13.glActiveTexture((int)33984);
                        GL11.glBindTexture((int)3553, (int)this.gaussianTex[0]);
                    }
                }
                this.renderBuffer(guiW, guiH, -1, false);
                GL30.glBindFramebuffer((int)36160, (int)0);
            }
        }
        mc.func_147110_a().func_147610_a(false);
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.gaussianTex[1]);
        this.renderBuffer(guiW, guiH, 255, true);
    }

    private int calcGaussian(int range) {
        int i;
        range = NGTMath.clamp((int)range, (int)0, (int)24);
        float[] weight = this.gaussianWeights;
        if (range <= 0) {
            for (int i2 = 0; i2 < weight.length; ++i2) {
                weight[i2] = i2 == 0 ? 1.0f : 0.0f;
            }
            return 0;
        }
        int maxIndex = 0;
        double total = 0.0;
        double variance = 20.0 * ((double)(range * range) / 576.0);
        for (i = 0; i < weight.length; ++i) {
            double r = 1.0 + 2.0 * (double)i;
            double w = Math.exp(-0.5 * (r * r) / variance);
            if (w < 0.00392156862745098) {
                maxIndex = i - 1;
                break;
            }
            weight[i] = (float)w;
            if (i > 0) {
                w *= 2.0;
            }
            total += w;
        }
        this.gaussianWeightsBuf.clear();
        for (i = 0; i < weight.length; ++i) {
            if (i > maxIndex) {
                weight[i] = 0.0f;
            }
            int n = i;
            weight[n] = (float)((double)weight[n] / total);
            this.gaussianWeightsBuf.put(weight[i]);
        }
        this.gaussianWeightsBuf.flip();
        return maxIndex;
    }

    private void renderBuffer(int w, int h, int alpha, boolean flip) {
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        if (alpha > 0) {
            tessellator.setColorRGBA_I(0xFFFFFF, alpha);
        }
        float fx = w;
        float fy = h;
        float fz = -90.0f;
        float minV = flip ? this.frameBufV : 0.0f;
        float maxV = flip ? 0.0f : this.frameBufV;
        tessellator.addVertexWithUV(0.0f, fy, fz, 0.0f, maxV);
        tessellator.addVertexWithUV(fx, fy, fz, this.frameBufU, maxV);
        tessellator.addVertexWithUV(fx, 0.0f, fz, this.frameBufU, minV);
        tessellator.addVertexWithUV(0.0f, 0.0f, fz, 0.0f, minV);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderText(Minecraft mc, int guiW, int guiH) {
        String focusStatus;
        int x = 5;
        int y = 5;
        int fontH = 10;
        int color = 65296;
        switch (this.focusMode) {
            case 0: {
                focusStatus = "NONE";
                break;
            }
            case 1: {
                focusStatus = String.format("AUTO(%.3f)", Float.valueOf(this.focus));
                break;
            }
            case 2: {
                focusStatus = String.format("%.3f", Float.valueOf(this.focus));
                break;
            }
            default: {
                focusStatus = "err";
            }
        }
        String s = String.format("x%.1f S:%d%% F:%s", Float.valueOf(this.scale), (int)(this.sensitivity * 100.0f), focusStatus);
        mc.field_71466_p.func_175063_a(s, (float)x, (float)y, color);
        mc.field_71466_p.func_175063_a(String.format("Zoom:[%c][%c]", Character.valueOf(CameraKey.ZOOM_OUT.chara), Character.valueOf(CameraKey.ZOOM_IN.chara)), (float)x, (float)(y += fontH), color);
        mc.field_71466_p.func_175063_a(String.format("Sensitivity:[%c][%c]", Character.valueOf(CameraKey.SENSIT_DOWN.chara), Character.valueOf(CameraKey.SENSIT_UP.chara)), (float)x, (float)(y += fontH), color);
        mc.field_71466_p.func_175063_a(String.format("Focus:[%c][%c] [%c]", Character.valueOf(CameraKey.FOCUS_OUT.chara), Character.valueOf(CameraKey.FOCUS_IN.chara), Character.valueOf(CameraKey.FOCUS_MODE.chara)), (float)x, (float)(y += fontH), color);
    }

    private void updateKeyState() {
        this.scale = CameraKeySet.ZOOM.updateValue(this.scale);
        float defaultFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        double d0 = Math.tan(NGTMath.toRadians((float)(defaultFov * 0.5f))) / (double)this.scale;
        float fov = (float)NGTMath.toDegrees((double)(Math.atan(d0) * 2.0));
        this.fovModification = fov / defaultFov;
        this.sensitivity = CameraKeySet.SENSITIVITY.updateValue(this.sensitivity);
        if (this.focusMode == 2) {
            this.focus = CameraKeySet.FOCUS.updateValue(this.focus);
        }
        if (CameraKey.FOCUS_MODE.isPressed()) {
            this.focusMode = (this.focusMode + 1) % 3;
        }
    }

    public float getFov() {
        return this.fovModification;
    }

    private void checkScreenshot(int w, int h, String fileName) {
        if (CameraKey.DEBUG.isPressed()) {
            try {
                BufferedImage image = this.getDepthBufT(w, h);
                File file = new File((File)NGTFileLoader.getModsDir().get(0), fileName + ".png");
                ImageIO.write((RenderedImage)image, "png", file);
                NGTLog.showChatMessage((String)"save:%s", (Object[])new Object[]{file.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage getMCScreen(int w, int h) {
        IntBuffer buf = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glBindTexture((int)3553, (int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buf);
        BufferedImage image = new BufferedImage(w, h, 1);
        for (int i = 0; i < buf.capacity(); ++i) {
            int color = buf.get(i);
            image.getRaster().getDataBuffer().setElem(i, color);
        }
        return image;
    }

    private BufferedImage getDepthBufF(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        for (int i = 0; i < this.depthBuffer.capacity(); ++i) {
            float depth = this.depthBuffer.get(i);
            image.getRaster().getDataBuffer().setElem(i, this.depth2Color(depth));
        }
        return image;
    }

    private BufferedImage getDepthBufI(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        for (int i = 0; i < this.depthColorBuffer.capacity(); ++i) {
            int color = this.depthColorBuffer.get(i);
            image.getRaster().getDataBuffer().setElem(i, color);
        }
        return image;
    }

    private BufferedImage getDepthBufT(int w, int h) {
        IntBuffer buf = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glBindTexture((int)3553, (int)this.gaussianTex[2]);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (IntBuffer)buf);
        BufferedImage image = new BufferedImage(w, h, 1);
        for (int i = 0; i < buf.capacity(); ++i) {
            int color = buf.get(i);
            image.getRaster().getDataBuffer().setElem(i, color);
        }
        return image;
    }
}

