/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.SerializableItemType;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tileentity.TileEntityCrossingGate;
import jp.ngt.rtm.block.tileentity.TileEntityFlag;
import jp.ngt.rtm.block.tileentity.TileEntityFluorescent;
import jp.ngt.rtm.block.tileentity.TileEntityLight;
import jp.ngt.rtm.block.tileentity.TileEntityMechanism;
import jp.ngt.rtm.block.tileentity.TileEntityPipe;
import jp.ngt.rtm.block.tileentity.TileEntityPlantOrnament;
import jp.ngt.rtm.block.tileentity.TileEntityPoint;
import jp.ngt.rtm.block.tileentity.TileEntityPole;
import jp.ngt.rtm.block.tileentity.TileEntityRailroadSign;
import jp.ngt.rtm.block.tileentity.TileEntityScaffold;
import jp.ngt.rtm.block.tileentity.TileEntityScaffoldStairs;
import jp.ngt.rtm.block.tileentity.TileEntitySignBoard;
import jp.ngt.rtm.block.tileentity.TileEntityTurnstile;
import jp.ngt.rtm.electric.Connection;
import jp.ngt.rtm.electric.IBlockConnective;
import jp.ngt.rtm.electric.TileEntityConnector;
import jp.ngt.rtm.electric.TileEntityInsulator;
import jp.ngt.rtm.electric.TileEntitySignal;
import jp.ngt.rtm.electric.TileEntitySpeaker;
import jp.ngt.rtm.electric.TileEntityTicketVendor;
import jp.ngt.rtm.entity.EntityATC;
import jp.ngt.rtm.entity.EntityBumpingPost;
import jp.ngt.rtm.entity.EntityInstalledObject;
import jp.ngt.rtm.entity.EntityTrainDetector;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.modelpack.state.ResourceStateSignboard;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInstalledObject
extends ItemWithModel {
    public ItemInstalledObject() {
        this.func_77627_a(true);
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        EnumFacing side = holder.getFacing();
        if (!world.field_72995_K) {
            BlockPos newPos = pos;
            if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && !world.func_175623_d(newPos = pos.func_177972_a(side))) {
                return holder.success();
            }
            int x = newPos.func_177958_n();
            int y = newPos.func_177956_o();
            int z = newPos.func_177952_p();
            int meta = itemStack.func_77952_i();
            int sideIndex = side.func_176745_a();
            Object block = null;
            IstlObjType type = IstlObjType.getType(meta);
            if (type == IstlObjType.FLUORESCENT) {
                int i1 = NGTMath.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                if (player.func_175151_a(newPos, side, itemStack)) {
                    block = RTMBlock.fluorescent;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)meta, (int)3);
                    byte dir = 0;
                    switch (sideIndex) {
                        case 0: {
                            if (i1 == 0 || i1 == 2) {
                                dir = 0;
                                break;
                            }
                            if (i1 != 1 && i1 != 3) break;
                            dir = 4;
                            break;
                        }
                        case 1: {
                            if (i1 == 0 || i1 == 2) {
                                dir = 2;
                                break;
                            }
                            if (i1 != 1 && i1 != 3) break;
                            dir = 6;
                            break;
                        }
                        case 2: {
                            dir = 1;
                            break;
                        }
                        case 3: {
                            dir = 3;
                            break;
                        }
                        case 4: {
                            dir = 5;
                            break;
                        }
                        case 5: {
                            dir = 7;
                        }
                    }
                    TileEntityFluorescent tile = (TileEntityFluorescent)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                    tile.setDir(dir);
                    this.updateResource(tile, itemStack);
                }
            } else if (type == IstlObjType.CROSSING) {
                if (side == EnumFacing.UP) {
                    block = RTMBlock.crossingGate;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                    TileEntityCrossingGate tile = (TileEntityCrossingGate)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                    tile.setRotation(player, 15.0f, true);
                    this.updateResource(tile, itemStack);
                }
            } else if (type == IstlObjType.RAILLOAD_SIGN) {
                if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                    block = RTMBlock.railroadSign;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                    TileEntityRailroadSign tile = (TileEntityRailroadSign)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                    tile.setRotation(player, 15.0f, true);
                    this.updateResource(tile, itemStack);
                }
            } else if (type == IstlObjType.SIGNAL) {
                if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                    IBlockState state = world.func_180495_p(pos);
                    Block target = state.func_177230_c();
                    if (target != RTMBlock.signal) {
                        TileEntity origTile = null;
                        if (target.hasTileEntity(state)) {
                            origTile = world.func_175625_s(pos);
                        }
                        int meta2 = BlockUtil.getMetadata((IBlockAccess)world, (BlockPos)pos);
                        BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMBlock.signal, (int)meta2, (int)3);
                        TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                        if (tile instanceof TileEntitySignal) {
                            TileEntitySignal teSignal = (TileEntitySignal)tile;
                            int dir = sideIndex == 2 ? 2 : (sideIndex == 4 ? 3 : (sideIndex == 3 ? 0 : 1));
                            teSignal.setSignalProperty(this.getModelState(itemStack).getResourceName(), target, dir, player, origTile);
                            block = RTMBlock.signal;
                        }
                    }
                }
            } else if (type == IstlObjType.TURNSTILE) {
                block = RTMBlock.turnstile;
                int dir = NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)player.field_70177_z + 180.0)) / 90.0 + 0.5)) & 3;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)dir, (int)3);
                TileEntityTurnstile tile = (TileEntityTurnstile)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setRotation(player, 90.0f, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.BUMPING_POST) {
                if (side == EnumFacing.UP && this.setEntityOnRail(world, new EntityBumpingPost(world), x, y - 1, z, player, itemStack)) {
                    block = Blocks.field_150348_b;
                }
            } else if (type == IstlObjType.LINEPOLE) {
                block = RTMBlock.linePole;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityPole tile = (TileEntityPole)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.STAIR) {
                block = RTMBlock.scaffoldStairs;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                block.func_180633_a(world, newPos, null, (EntityLivingBase)player, null);
                TileEntityScaffoldStairs tile = (TileEntityScaffoldStairs)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.SCAFFOLD) {
                block = RTMBlock.scaffold;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                block.func_180633_a(world, newPos, null, (EntityLivingBase)player, null);
                TileEntityScaffold tile = (TileEntityScaffold)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.POINT) {
                if (side == EnumFacing.UP) {
                    block = RTMBlock.point;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                    TileEntityPoint tile = (TileEntityPoint)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                    tile.setRotation(player, 15.0f, false);
                    this.updateResource(tile, itemStack);
                }
            } else if (type == IstlObjType.SIGNBOARD) {
                block = RTMBlock.signboard;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)sideIndex, (int)3);
                TileEntitySignBoard tile = (TileEntitySignBoard)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                int playerFacing = NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)player.field_70177_z + 180.0)) / 90.0 + 0.5)) & 3;
                tile.setDirection((byte)playerFacing);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.TICKET_VENDOR) {
                block = RTMBlock.ticketVendor;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityTicketVendor tile = (TileEntityTicketVendor)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setRotation(player, 15.0f, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.LIGHT) {
                block = RTMBlock.light;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)sideIndex, (int)3);
                TileEntityLight tile = (TileEntityLight)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setRotation(player, 15.0f, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.FLAG) {
                block = RTMBlock.flag;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityFlag tile = (TileEntityFlag)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setRotation(player, 15.0f, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.ATC) {
                if (side == EnumFacing.UP && this.setEntityOnRail(world, new EntityATC(world), x, y - 1, z, player, itemStack)) {
                    block = Blocks.field_150348_b;
                }
            } else if (type == IstlObjType.TRAIN_DETECTOR) {
                if (side == EnumFacing.UP && this.setEntityOnRail(world, new EntityTrainDetector(world), x, y - 1, z, player, itemStack)) {
                    block = Blocks.field_150348_b;
                }
            } else if (type == IstlObjType.INSULATOR) {
                block = RTMBlock.insulator;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)sideIndex, (int)3);
                TileEntityInsulator tile = (TileEntityInsulator)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.CONNECTOR_IN || type == IstlObjType.CONNECTOR_OUT) {
                Block target = BlockUtil.getBlock((IBlockAccess)world, (BlockPos)pos);
                if (target instanceof IBlockConnective && ((IBlockConnective)target).canConnect(world, x, y, z)) {
                    if (type == IstlObjType.CONNECTOR_OUT) {
                        sideIndex += 6;
                    }
                    block = RTMBlock.connector;
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)sideIndex, (int)3);
                    TileEntityConnector tile = (TileEntityConnector)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                    this.updateResource(tile, itemStack);
                    tile.setConnectionTo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Connection.ConnectionType.DIRECT, null);
                }
            } else if (type == IstlObjType.PIPE) {
                block = RTMBlock.pipe;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityPipe tile = (TileEntityPipe)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setAttachedSide((byte)side.func_176745_a());
                tile.refresh();
                world.func_175685_c(new BlockPos(x, y, z), block, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.PLANT) {
                block = RTMBlock.plant_ornament;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityPlantOrnament tile = (TileEntityPlantOrnament)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.SPEAKER) {
                block = RTMBlock.speaker;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)sideIndex, (int)3);
                TileEntitySpeaker tile = (TileEntitySpeaker)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setRotation(player, 15.0f, true);
                this.updateResource(tile, itemStack);
            } else if (type == IstlObjType.MECHANISM) {
                block = RTMBlock.mechanism;
                BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)3);
                TileEntityMechanism tile = (TileEntityMechanism)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
                tile.setSide(sideIndex);
                this.updateResource(tile, itemStack);
            }
            if (block != null) {
                SoundType soundtype = block.getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                RTMCore.proxy.playSound((Entity)player, "block.stone.place", (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemStack.func_190918_g(1);
            }
        }
        return holder.success();
    }

    private void updateResource(IResourceSelector selector, ItemStack stack) {
        selector.getResourceState().readFromNBT(this.getModelState(stack).writeToNBT());
        selector.updateResourceState();
    }

    private boolean setEntityOnRail(World world, EntityInstalledObject entity, int x, int y, int z, EntityPlayer player, ItemStack stack) {
        RailMap rm0 = TileEntityLargeRailBase.getRailMapFromCoordinates(world, null, x, y, z);
        if (rm0 == null) {
            return false;
        }
        int split = 128;
        int i0 = rm0.getNearlestPoint(split, (double)x + 0.5, (double)z + 0.5);
        double posX = rm0.getRailPos(split, i0)[1];
        double posY = rm0.getRailHeight(split, i0) + 0.0625;
        double posZ = rm0.getRailPos(split, i0)[0];
        float yaw = rm0.getRailRotation(split, i0);
        float yaw2 = -player.field_70177_z + 180.0f;
        float dif = NGTMath.wrapAngle((float)(yaw - yaw2));
        boolean invert = false;
        if (Math.abs(dif) > 90.0f) {
            yaw += 180.0f;
            invert = true;
        }
        ResourceState itemState = this.getModelState(stack);
        entity.func_70107_b(posX, posY, posZ);
        entity.field_70177_z = yaw;
        entity.field_70125_A = -rm0.getRailPitch(split, i0) * (invert ? -1.0f : 1.0f);
        entity.rotationRoll = rm0.getCant(split, i0) * (invert ? -1.0f : 1.0f);
        world.func_72838_d((Entity)entity);
        entity.getResourceState().readFromNBT(itemState.writeToNBT());
        entity.updateResourceState();
        return true;
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + "." + itemStack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (IstlObjType type : IstlObjType.values()) {
            if (type == IstlObjType.NONE) continue;
            list.add((Object)new ItemStack((Item)this, 1, (int)type.id));
        }
    }

    @Override
    protected ResourceType getModelType(ItemStack itemStack) {
        return IstlObjType.getType((int)itemStack.func_77952_i()).type;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        int meta = stack.func_77952_i();
        IstlObjType type = IstlObjType.getType(meta);
        if (type == IstlObjType.RAILLOAD_SIGN || type == IstlObjType.FLAG) {
            return RTMCore.guiIdSelectItemTexture;
        }
        if (type == IstlObjType.SIGNBOARD) {
            return RTMCore.guiIdSignboard;
        }
        return RTMCore.guiIdSelectItemModel;
    }

    protected ResourceState getNewState(ItemStack itemStack, ResourceType type) {
        IstlObjType type2 = IstlObjType.getType(itemStack.func_77952_i());
        if (type2 == IstlObjType.SIGNBOARD) {
            return new ResourceStateSignboard(type, null);
        }
        return new ResourceState(type, null);
    }

    public static enum IstlObjType implements SerializableItemType
    {
        FLUORESCENT(0, RTMResource.ORNAMENT_LAMP),
        PLANT(1, RTMResource.ORNAMENT_PLANT),
        INSULATOR(3, RTMResource.CONNECTOR_RELAY),
        PIPE(4, RTMResource.ORNAMENT_PIPE),
        CROSSING(5, RTMResource.MACHINE_GATE),
        RAILLOAD_SIGN(6, RTMResource.RRS),
        SIGNAL(7, RTMResource.SIGNAL),
        CONNECTOR_IN(8, RTMResource.CONNECTOR_INPUT),
        CONNECTOR_OUT(9, RTMResource.CONNECTOR_OUTPUT),
        ATC(10, RTMResource.MACHINE_ANTENNA_SEND),
        TRAIN_DETECTOR(11, RTMResource.MACHINE_ANTENNA_RECEIVE),
        TURNSTILE(12, RTMResource.MACHINE_TURNSTILE),
        BUMPING_POST(13, RTMResource.MACHINE_BUMPINGPOST),
        LINEPOLE(14, RTMResource.ORNAMENT_POLE),
        POINT(16, RTMResource.MACHINE_POINT),
        SIGNBOARD(17, RTMResource.SIGNBOARD),
        TICKET_VENDOR(18, RTMResource.MACHINE_VENDOR),
        LIGHT(19, RTMResource.MACHINE_LIGHT),
        FLAG(20, RTMResource.FLAG),
        STAIR(21, RTMResource.ORNAMENT_STAIR),
        SCAFFOLD(22, RTMResource.ORNAMENT_SCAFFOLD),
        SPEAKER(23, RTMResource.MACHINE_SPEAKER),
        MECHANISM(24, RTMResource.MECHANISM),
        NONE(-1, null);

        public final byte id;
        public final ResourceType type;

        private IstlObjType(int par1, ResourceType par2) {
            this.id = (byte)par1;
            this.type = par2;
        }

        public static IstlObjType getType(int id) {
            for (IstlObjType type : IstlObjType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return NONE;
        }

        public int getId() {
            return this.id;
        }
    }
}

