/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tileentity.MechanismType;
import jp.ngt.rtm.block.tileentity.TileEntityMechanism;
import jp.ngt.rtm.entity.vehicle.EntityCar;
import jp.ngt.rtm.entity.vehicle.EntityLift;
import jp.ngt.rtm.entity.vehicle.EntityPlane;
import jp.ngt.rtm.entity.vehicle.EntityShip;
import jp.ngt.rtm.entity.vehicle.EntityTrolley;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.LiftMotion;
import jp.ngt.rtm.entity.vehicle.VehicleType;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.block.BlockRailBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVehicle
extends ItemWithModel {
    @Override
    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        BlockPos pos;
        RayTraceResult mop;
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        if (itemStack.func_77952_i() == VehicleType.SHIP.id && (mop = BlockUtil.getMOPFromPlayer((EntityPlayer)player, (double)5.0, (boolean)true)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(pos = mop.func_178782_a()).func_185904_a().func_76224_d()) {
            if (!world.field_72995_K) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                this.setVehicle(itemStack, world, player, new EntityShip(world), x, y, z);
            }
            return holder.success();
        }
        return super.onItemRightClick(holder);
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        BlockPos pos = holder.getBlockPos();
        EntityPlayer player = holder.getPlayer();
        if (!world.field_72995_K) {
            TileEntityMechanism mecha;
            TileEntity tileEntity;
            int damage = itemStack.func_77952_i();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (damage == VehicleType.CAR.id) {
                if (holder.getFacing() == EnumFacing.UP) {
                    this.setVehicle(itemStack, world, player, new EntityCar(world), x, y, z);
                }
            } else if (damage == VehicleType.PLANE.id) {
                if (holder.getFacing() == EnumFacing.UP) {
                    this.setVehicle(itemStack, world, player, new EntityPlane(world), x, y, z);
                }
            } else if (damage == VehicleType.TROLLEY.id) {
                if (holder.getFacing() == EnumFacing.UP && world.func_180495_p(pos).func_177230_c() instanceof BlockRailBase) {
                    EntityTrolley entity = new EntityTrolley(world);
                    this.setTrolley(itemStack, world, player, entity, x, y, z);
                }
            } else if (damage == VehicleType.LIFT.id && world.func_180495_p(pos).func_177230_c() == RTMBlock.mechanism && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityMechanism && (mecha = (TileEntityMechanism)tileEntity).getType() == MechanismType.PULLEY) {
                this.setLift(itemStack, world, player, new EntityLift(world), mecha);
            }
        }
        return holder.success();
    }

    protected void setVehicle(ItemStack itemStack, World world, EntityPlayer player, EntityVehicle vehicle, int x, int y, int z) {
        if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editVehicle")) {
            vehicle.func_70107_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
            vehicle.field_70177_z = NGTMath.wrapAngle((float)(-player.field_70177_z));
            world.func_72838_d((Entity)vehicle);
            vehicle.getResourceState().readFromNBT(this.getModelState(itemStack).writeToNBT());
            vehicle.updateResourceState();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
    }

    protected void setTrolley(ItemStack itemStack, World world, EntityPlayer player, EntityTrolley vehicle, int x, int y, int z) {
        if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editVehicle")) {
            vehicle.func_70107_b((double)x + 0.5, (double)y + 0.0625, (double)z + 0.5);
            world.func_72838_d((Entity)vehicle);
            vehicle.getResourceState().readFromNBT(this.getModelState(itemStack).writeToNBT());
            vehicle.updateResourceState();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
    }

    protected void setLift(ItemStack itemStack, World world, EntityPlayer player, EntityLift vehicle, TileEntityMechanism mecha) {
        if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editVehicle")) {
            LiftMotion motion = mecha.getMotion(vehicle, 0.0, 0);
            vehicle.func_70107_b(motion.pos.getX(), motion.pos.getY(), motion.pos.getZ());
            vehicle.field_70177_z = motion.yaw;
            vehicle.field_70125_A = motion.pitch;
            vehicle.setMecha(motion.mecha);
            world.func_72838_d((Entity)vehicle);
            vehicle.getResourceState().readFromNBT(this.getModelState(itemStack).writeToNBT());
            vehicle.updateResourceState();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
    }

    public String func_77667_c(ItemStack par1) {
        return this.func_77658_a() + "." + par1.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (VehicleType type : VehicleType.values()) {
            list.add((Object)new ItemStack((Item)this, 1, type.id));
        }
    }

    @Override
    protected ResourceType getModelType(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        for (VehicleType type : VehicleType.values()) {
            if (type.id != damage) continue;
            return type.type;
        }
        return RTMResource.VEHICLE_CAR;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        return RTMCore.guiIdSelectItemModel;
    }

    protected ResourceState getNewState(ItemStack itemStack, ResourceType type) {
        return new ResourceState(type, null);
    }
}

