/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.rtm.modelpack.ModelPackException;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class RTMResourceManager
implements IResourceManager {
    private final Map<ResourceLocation, IResource> resourceCache = new HashMap<ResourceLocation, IResource>();
    private final MetadataSerializer serializer;
    private final File domain;

    public RTMResourceManager(MetadataSerializer par1, File par2) {
        this.serializer = par1;
        this.domain = par2;
    }

    public Set func_135055_a() {
        return null;
    }

    public IResource func_110536_a(ResourceLocation par1) throws IOException {
        if (this.domain == null) {
            throw new FileNotFoundException(par1.toString());
        }
        if (this.resourceCache.containsKey(par1)) {
            return this.resourceCache.get(par1);
        }
        String absPath = this.domain.getAbsolutePath();
        if (absPath.contains(par1.func_110624_b())) {
            File resource;
            InputStream stream = null;
            String suffix = NGTFileLoader.getArchiveSuffix((String)absPath);
            if (!suffix.isEmpty()) {
                String zipPath = NGTFileLoader.getArchivePath((String)absPath, (String)suffix);
                String s = par1.func_110623_a();
                try {
                    ZipFile zip = NGTFileLoader.getArchive((File)new File(zipPath), (String)"");
                    Enumeration<? extends ZipEntry> enu = zip.entries();
                    while (enu.hasMoreElements()) {
                        File fileInZip;
                        ZipEntry ze = enu.nextElement();
                        if (ze.isDirectory() || !s.contains((fileInZip = new File(zipPath, ze.getName())).getName())) continue;
                        stream = zip.getInputStream(ze);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                resource = new File(this.domain, par1.func_110623_a());
                stream = new FileInputStream(resource);
            }
            if (stream != null) {
                resource = new SimpleResource("RTMCustom", par1, stream, null, this.serializer);
                this.resourceCache.put(par1, (IResource)resource);
                return resource;
            }
        }
        throw new ModelPackException("[RTMResourceManager] Can't get input stream", par1.func_110623_a());
    }

    public List func_135056_b(ResourceLocation par1) throws IOException {
        ArrayList list = Lists.newArrayList();
        list.add(this.func_110536_a(par1));
        if (!list.isEmpty()) {
            return list;
        }
        throw new FileNotFoundException(par1.toString());
    }
}

