/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.modelset;

import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.render.ModelObject;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ModelSetTrain
extends ModelSetVehicleBase<TrainConfig> {
    @SideOnly(value=Side.CLIENT)
    public ModelObject[] bogieModels;

    public ModelSetTrain() {
    }

    public ModelSetTrain(TrainConfig par1) {
        super(par1);
    }

    @Override
    public void constructOnServer() {
        super.constructOnServer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void constructOnClient() {
        super.constructOnClient();
        if (this.isDummy()) {
            this.bogieModels = new ModelObject[2];
            this.bogieModels[0] = this.bogieModels[1] = ModelObject.getDummy();
        } else {
            this.bogieModels = this.registerBogieModel();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ModelObject[] registerBogieModel() {
        ModelObject[] modelBogies = new ModelObject[2];
        for (int i = 0; i < 2; ++i) {
            modelBogies[i] = new ModelObject(((TrainConfig)this.getConfig()).getBogieModel(i), this, null, "isBogie");
        }
        return modelBogies;
    }

    @Override
    public TrainConfig getDummyConfig() {
        return TrainConfig.getDummyConfig();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderPartsInGui(Minecraft par1) {
        TrainConfig cfg = (TrainConfig)this.cfg;
        for (int i = 0; i < 2; ++i) {
            GL11.glPushMatrix();
            float[] fa = cfg.getBogiePos()[i];
            GL11.glTranslatef((float)fa[0], (float)fa[1], (float)fa[2]);
            GL11.glRotatef((float)(180.0f * (float)i), (float)0.0f, (float)1.0f, (float)0.0f);
            this.bogieModels[i].render(null, cfg, 0, 0.0f);
            GL11.glPopMatrix();
        }
    }
}

