/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.state;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.rtm.entity.util.CollisionObj;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.DataMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;

public class ResourceState<T extends ResourceSet> {
    public final ResourceType type;
    public final DataMap dataMap = new DataMap();
    public final List<String> exclusionParts = new ArrayList<String>();
    public int version;
    private String name;
    private String modelName;
    private T modelSet;
    public int color = 0xFFFFFF;

    public ResourceState(ResourceType type, @Nullable Object entity) {
        this.type = type;
        this.modelName = type.defaultName;
        this.dataMap.setEntity(entity);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.version = nbt.func_74762_e("Version");
        this.setName(nbt.func_74779_i("Name"));
        this.setResourceName(nbt.func_74779_i("ResourceName"));
        this.color = nbt.func_74762_e("Color");
        this.getResourceSet();
        this.dataMap.readFromNBT(nbt.func_74775_l("DataMap"));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Name", this.getName());
        nbt.func_74768_a("Version", 43);
        nbt.func_74778_a("ResourceName", this.modelName);
        nbt.func_74768_a("Color", this.color);
        nbt.func_74782_a("DataMap", (NBTBase)this.dataMap.writeToNBT());
        return nbt;
    }

    public String getName() {
        this.setName(this.name);
        return this.name;
    }

    public void setName(String par1) {
        if (par1 == null || par1.isEmpty()) {
            par1 = "no_name";
        }
        this.name = par1;
    }

    public String getArg() {
        return this.dataMap.getArg();
    }

    public void setArg(String par1, boolean overwrite) {
        this.dataMap.setArg(par1, overwrite);
    }

    public String getResourceName() {
        return this.modelName;
    }

    public void setResourceName(String par1) {
        if (!par1.isEmpty()) {
            this.modelName = par1;
            this.modelSet = null;
        }
    }

    public void setResourceToDefault() {
        this.setResourceName(this.type.defaultName);
    }

    public T getResourceSet() {
        if (this.modelSet == null || ((ResourceSet)this.modelSet).isDummy()) {
            this.modelSet = ModelPackManager.INSTANCE.getResourceSet(this.type, this.modelName);
            if (!((ResourceSet)this.modelSet).isDummy()) {
                ((ResourceSet)this.modelSet).dataFormatter.initDataMap(this.dataMap);
            }
        }
        return this.modelSet;
    }

    public DataMap getDataMap() {
        this.getResourceSet();
        return this.dataMap;
    }

    public void applyCollison(Entity target, Entity myself, AxisAlignedBB playerAABB, List<AxisAlignedBB> list) {
        CollisionObj obj;
        if (this.modelSet instanceof ModelSetBase && (obj = ((ModelSetBase)this.modelSet).getCollisionObj()) != null) {
            obj.applyCollison(target, myself, playerAABB, list, this.exclusionParts);
        }
    }

    public void addExclusionParts(String ... names) {
        for (String name : names) {
            if (this.exclusionParts.contains(name)) continue;
            this.exclusionParts.add(name);
        }
    }

    public void removeExclusionParts(String ... names) {
        for (String name : names) {
            if (!this.exclusionParts.contains(name)) continue;
            this.exclusionParts.remove(name);
        }
    }
}

