/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.entity.util.ColFace;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCollisionObj
implements IMessage,
IMessageHandler<PacketCollisionObj, IMessage> {
    private ResourceType type;
    private String modelName;
    private String partsName;
    private ColFace face;
    private byte status;

    public PacketCollisionObj() {
    }

    public PacketCollisionObj(ResourceType type, String model, String parts, ColFace face, byte status) {
        this.type = type;
        this.modelName = model;
        this.partsName = parts;
        this.face = face;
        this.status = status;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.type.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.modelName);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.partsName);
        buffer.writeByte((int)this.status);
        buffer.writeInt(this.face.vertices.length);
        for (Vec3 vec : this.face.vertices) {
            buffer.writeFloat((float)vec.getX());
            buffer.writeFloat((float)vec.getY());
            buffer.writeFloat((float)vec.getZ());
        }
        buffer.writeFloat((float)this.face.normal.getX());
        buffer.writeFloat((float)this.face.normal.getY());
        buffer.writeFloat((float)this.face.normal.getZ());
    }

    public void fromBytes(ByteBuf buffer) {
        String typeName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.type = ModelPackManager.INSTANCE.getType(typeName);
        this.modelName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.partsName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.status = buffer.readByte();
        int vtxCount = buffer.readInt();
        this.face = new ColFace();
        this.face.vertices = new Vec3[vtxCount];
        for (int j = 0; j < vtxCount; ++j) {
            float x = buffer.readFloat();
            float y = buffer.readFloat();
            float z = buffer.readFloat();
            this.face.vertices[j] = new Vec3((double)x, (double)y, (double)z);
        }
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        this.face.normal = new Vec3((double)x, (double)y, (double)z);
        this.face.init();
    }

    public IMessage onMessage(PacketCollisionObj message, MessageContext ctx) {
        Object set = ModelPackManager.INSTANCE.getResourceSet(message.type, message.modelName);
        if (set instanceof ModelSetBase) {
            ((ModelSetBase)set).addColFace(message.partsName, message.face, message.status);
        }
        return null;
    }
}

