/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.event.TickProcessQueue;
import jp.ngt.ngtlib.network.PacketCustom;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketLargeRailBase
extends PacketCustom
implements IMessageHandler<PacketLargeRailBase, IMessage> {
    public static final byte RETRY = 50;
    public static final byte INTERVAL = 5;
    private int sX;
    private int sY;
    private int sZ;

    public PacketLargeRailBase() {
    }

    public PacketLargeRailBase(TileEntityLargeRailBase tileEntity) {
        super((TileEntity)tileEntity);
        this.sX = tileEntity.getStartPoint()[0];
        this.sY = tileEntity.getStartPoint()[1];
        this.sZ = tileEntity.getStartPoint()[2];
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.sX);
        buffer.writeInt(this.sY);
        buffer.writeInt(this.sZ);
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.sX = buffer.readInt();
        this.sY = buffer.readInt();
        this.sZ = buffer.readInt();
    }

    public IMessage onMessage(PacketLargeRailBase message, MessageContext ctx) {
        this.receivePacket(message);
        return null;
    }

    private void receivePacket(final PacketLargeRailBase message) {
        TickProcessQueue.getInstance((Side)Side.CLIENT).add(new TickProcessEntry(){

            public boolean process(World world) {
                TileEntity tile = message.getTileEntity(world);
                if (tile instanceof TileEntityLargeRailBase) {
                    ((TileEntityLargeRailBase)tile).setStartPoint(message.sX, message.sY, message.sZ);
                    return true;
                }
                return false;
            }
        }, 50, 5);
    }
}

