/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.modelpack.IResourceSelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSelectResource
implements IMessage,
IMessageHandler<PacketSelectResource, IMessage> {
    private int[] pos;
    private NBTTagCompound data;

    public PacketSelectResource() {
    }

    public PacketSelectResource(IResourceSelector selector) {
        this.pos = selector.getSelectorPos();
        this.data = selector.getResourceState().writeToNBT();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pos[0]);
        buffer.writeInt(this.pos[1]);
        buffer.writeInt(this.pos[2]);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.data);
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = new int[3];
        this.pos[0] = buffer.readInt();
        this.pos[1] = buffer.readInt();
        this.pos[2] = buffer.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public IMessage onMessage(PacketSelectResource message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        IResourceSelector selector = null;
        if (message.pos[1] >= 0) {
            try {
                TileEntity tile = BlockUtil.getTileEntity((IBlockAccess)world, (int)message.pos[0], (int)message.pos[1], (int)message.pos[2]);
                if (tile instanceof IResourceSelector) {
                    selector = (IResourceSelector)tile;
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        } else {
            Entity entity = world.func_73045_a(message.pos[0]);
            if (entity instanceof IResourceSelector) {
                selector = (IResourceSelector)entity;
            }
        }
        if (selector != null) {
            if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "changeModel")) {
                selector.getResourceState().readFromNBT(message.data);
                selector.updateResourceState();
            } else {
                selector.updateResourceState();
            }
        }
        return null;
    }
}

