/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.IRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.renderer.VertexArray2;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderRailBlock {
    private static final float SNOW_THICKNESS = 0.125f;
    private final List<int[]> blockPosList = new ArrayList<int[]>();

    public void renderRailBlocksVA(TileEntityLargeRailCore tileEntity, double par2, double par4, double par6, float par8) {
        boolean hasGLList = GLHelper.isValid((GLObject)tileEntity.railBlocks);
        if (!hasGLList) {
            tileEntity.railBlocks = GLHelper.generateVA();
        } else if (tileEntity.shouldRerenderBlock) {
            hasGLList = false;
        }
        if (!hasGLList) {
            if (this.renderBlocks(tileEntity, (IRenderer)tileEntity.railBlocks)) {
                tileEntity.shouldRerenderBlock = false;
                hasGLList = true;
            } else {
                tileEntity.shouldRerenderBlock = true;
                hasGLList = false;
            }
        }
        if (hasGLList) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)(par2 - (double)tileEntity.getX())), (float)((float)(par4 - (double)tileEntity.getY())), (float)((float)(par6 - (double)tileEntity.getZ())));
            NGTUtilClient.bindTexture((ResourceLocation)TextureMap.field_110575_b);
            ((VertexArray2)tileEntity.railBlocks).render();
            GL11.glPopMatrix();
        }
    }

    public void renderRailBlocks(TileEntityLargeRailCore tileEntity, double par2, double par4, double par6, float par8) {
        boolean hasGLList = GLHelper.isValid((GLObject)tileEntity.railBlocks);
        if (!hasGLList) {
            tileEntity.railBlocks = GLHelper.generateGLList((GLObject)tileEntity.railBlocks);
        } else if (tileEntity.shouldRerenderBlock) {
            hasGLList = false;
        }
        if (!hasGLList) {
            NGTTessellator tessellator = NGTTessellator.instance;
            GLHelper.startCompile((GLObject)tileEntity.railBlocks);
            if (this.renderBlocks(tileEntity, (IRenderer)tessellator)) {
                tileEntity.shouldRerenderBlock = false;
                hasGLList = true;
            } else {
                tileEntity.shouldRerenderBlock = true;
                hasGLList = false;
            }
            GLHelper.endCompile();
        }
        if (hasGLList) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)(par2 - (double)tileEntity.getX())), (float)((float)(par4 - (double)tileEntity.getY())), (float)((float)(par6 - (double)tileEntity.getZ())));
            NGTUtilClient.bindTexture((ResourceLocation)TextureMap.field_110575_b);
            GLHelper.callList((GLObject)tileEntity.railBlocks);
            GL11.glPopMatrix();
        }
    }

    public boolean renderBlocks(TileEntityLargeRailCore rail, IRenderer renderer) {
        RailMap[] rms = rail.getAllRailMaps();
        if (rms == null) {
            return false;
        }
        boolean flag = true;
        for (RailMap rm : rms) {
            List<int[]> list = rm.getRailBlockList(rail.getResourceState(), false);
            this.blockPosList.addAll(list);
        }
        if (this.blockPosList.size() < 2) {
            this.blockPosList.clear();
            return false;
        }
        renderer.startDrawing(7);
        for (int[] ia : this.blockPosList) {
            World world = rail.func_145831_w();
            int x = ia[0];
            int y = ia[1];
            int z = ia[2];
            Block block = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)y, (int)z);
            try {
                if (this.renderWorldBlock(rail, renderer, (IBlockAccess)world, x, y, z, block)) continue;
                rail.rerenderCount = 1;
                this.renderMissingBlock(renderer, (IBlockAccess)world, x, y, z);
            }
            catch (ClassCastException e) {
                flag = false;
            }
        }
        if (renderer instanceof VertexArray2) {
            if (flag) {
                renderer.draw();
            } else {
                ((VertexArray2)renderer).cancel();
            }
        } else {
            renderer.draw();
        }
        this.blockPosList.clear();
        return flag;
    }

    private boolean renderWorldBlock(TileEntityLargeRailCore rail, IRenderer renderer, IBlockAccess world, int x, int y, int z, Block block) {
        float v;
        float maxV;
        float maxU;
        float minU;
        TextureAtlasSprite icon;
        IBlockState sideBlock;
        TileEntityLargeRailBase tile = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (tile == null) {
            return false;
        }
        ResourceStateRail prop = rail.getResourceState();
        if (prop.block == Blocks.field_150350_a) {
            return true;
        }
        float[] fa = tile.getBlockHeights(x, y, z, prop.blockHeight, false);
        float y0 = fa[0];
        float y1 = fa[1];
        float y2 = fa[2];
        float y3 = fa[3];
        BlockPos origPos = tile.func_174877_v();
        int brightness = block.func_185484_c(world.func_180495_p(origPos), world, origPos);
        renderer.setBrightness(brightness);
        if (prop.block.func_149688_o(prop.block.func_176223_P()) == Material.field_151596_z) {
            y0 += 0.125f;
            y1 += 0.125f;
            y2 += 0.125f;
            y3 += 0.125f;
        }
        if (!(sideBlock = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)y, (int)(z + 1))).func_185914_p() && !(sideBlock.func_177230_c() instanceof BlockLargeRailBase)) {
            icon = this.getIcon(prop.block, prop.meta, 3);
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
            maxV = icon.func_94210_h();
            v = maxV - icon.func_94206_g();
            renderer.setColor(204, 204, 204, 255);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + y0, (float)z + 1.0f, minU, maxV - v * this.getV(y0));
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + 0.0f, (float)z + 1.0f, minU, maxV);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + 0.0f, (float)z + 1.0f, maxU, maxV);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + y1, (float)z + 1.0f, maxU, maxV - v * this.getV(y1));
        }
        if (!(sideBlock = BlockUtil.getBlockState((IBlockAccess)world, (int)(x + 1), (int)y, (int)z)).func_185914_p() && !(sideBlock.func_177230_c() instanceof BlockLargeRailBase)) {
            icon = this.getIcon(prop.block, prop.meta, 5);
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
            maxV = icon.func_94210_h();
            v = maxV - icon.func_94206_g();
            renderer.setColor(153, 153, 153, 255);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + y1, (float)z + 1.0f, minU, maxV - v * this.getV(y1));
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + 0.0f, (float)z + 1.0f, minU, maxV);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + 0.0f, (float)z + 0.0f, maxU, maxV);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + y2, (float)z + 0.0f, maxU, maxV - v * this.getV(y2));
        }
        if (!(sideBlock = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)y, (int)(z - 1))).func_185914_p() && !(sideBlock.func_177230_c() instanceof BlockLargeRailBase)) {
            icon = this.getIcon(prop.block, prop.meta, 2);
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
            maxV = icon.func_94210_h();
            v = maxV - icon.func_94206_g();
            renderer.setColor(204, 204, 204, 255);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + y2, (float)z + 0.0f, minU, maxV - v * this.getV(y2));
            renderer.addVertexWithUV((float)x + 1.0f, (float)y + 0.0f, (float)z + 0.0f, minU, maxV);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + 0.0f, (float)z + 0.0f, maxU, maxV);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + y3, (float)z + 0.0f, maxU, maxV - v * this.getV(y3));
        }
        if (!(sideBlock = BlockUtil.getBlockState((IBlockAccess)world, (int)(x - 1), (int)y, (int)z)).func_185914_p() && !(sideBlock.func_177230_c() instanceof BlockLargeRailBase)) {
            icon = this.getIcon(prop.block, prop.meta, 4);
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
            maxV = icon.func_94210_h();
            v = maxV - icon.func_94206_g();
            renderer.setColor(153, 153, 153, 255);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + y3, (float)z + 0.0f, minU, maxV - v * this.getV(y3));
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + 0.0f, (float)z + 0.0f, minU, maxV);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + 0.0f, (float)z + 1.0f, maxU, maxV);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y + y0, (float)z + 1.0f, maxU, maxV - v * this.getV(y0));
        }
        icon = this.getIcon(prop.block, prop.meta, 1);
        minU = icon.func_94209_e();
        maxU = icon.func_94212_f();
        maxV = icon.func_94210_h();
        v = maxV - icon.func_94206_g();
        renderer.setColor(255, 255, 255, 255);
        renderer.addVertexWithUV((float)x + 0.0f, (float)y + y0, (float)z + 1.0f, minU, maxV - v);
        renderer.addVertexWithUV((float)x + 1.0f, (float)y + y1, (float)z + 1.0f, minU, maxV);
        renderer.addVertexWithUV((float)x + 1.0f, (float)y + y2, (float)z + 0.0f, maxU, maxV);
        renderer.addVertexWithUV((float)x + 0.0f, (float)y + y3, (float)z + 0.0f, maxU, maxV - v);
        sideBlock = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        if (!sideBlock.func_185914_p()) {
            icon = this.getIcon(prop.block, prop.meta, 0);
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
            maxV = icon.func_94210_h();
            v = maxV - icon.func_94206_g();
            renderer.setColor(127, 127, 127, 255);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y, (float)z + 0.0f, minU, maxV - v);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y, (float)z + 0.0f, minU, maxV);
            renderer.addVertexWithUV((float)x + 1.0f, (float)y, (float)z + 1.0f, maxU, maxV);
            renderer.addVertexWithUV((float)x + 0.0f, (float)y, (float)z + 1.0f, maxU, maxV - v);
        }
        return true;
    }

    private void renderMissingBlock(IRenderer renderer, IBlockAccess world, int x, int y, int z) {
        TextureAtlasSprite icon = this.getIcon(Blocks.field_150357_h, 0, 1);
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float maxV = icon.func_94210_h();
        float minV = icon.func_94206_g();
        float y0 = 0.0625f;
        renderer.setColor(255, 255, 255, 255);
        renderer.addVertexWithUV((float)x + 0.0f, (float)y + y0, (float)z + 1.0f, minU, minV);
        renderer.addVertexWithUV((float)x + 1.0f, (float)y + y0, (float)z + 1.0f, minU, maxV);
        renderer.addVertexWithUV((float)x + 1.0f, (float)y + y0, (float)z + 0.0f, maxU, maxV);
        renderer.addVertexWithUV((float)x + 0.0f, (float)y + y0, (float)z + 0.0f, maxU, minV);
    }

    private TextureAtlasSprite getIcon(Block block, int meta, int side) {
        IBlockState state = block.func_176203_a(meta);
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    private float getV(float par1) {
        return par1 > 1.0f ? 1.0f : (par1 < 0.0f ? 0.0f : par1);
    }

    @Deprecated
    private boolean checkRailBlock(World world, List<int[]> list) {
        for (int[] pos : list) {
            TileEntityLargeRailBase tile = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)pos[0], (int)pos[1], (int)pos[2]);
            if (tile == null) {
                return false;
            }
            TileEntityLargeRailCore core = tile.getRailCore();
            if (core != null) continue;
            return false;
        }
        return true;
    }
}

