/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.network.PacketLargeRailCore;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapBasic;
import jp.ngt.rtm.rail.util.RailMapCustom;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityLargeRailCore
extends TileEntityLargeRailBase
implements IResourceSelector {
    protected boolean isCollidedTrain = false;
    public boolean colliding = false;
    private int signal = 0;
    private ResourceStateRail state = new ResourceStateRail(RTMResource.RAIL, this);
    public final List<ResourceStateRail> subRails = new ArrayList<ResourceStateRail>();
    protected RailPosition[] railPositions;
    protected RailMap railmap;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    @SideOnly(value=Side.CLIENT)
    public GLObject[] glLists;
    @SideOnly(value=Side.CLIENT)
    public GLObject railBlocks;
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRerenderRail;
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRerenderBlock;
    @SideOnly(value=Side.CLIENT)
    private int brightness;
    @SideOnly(value=Side.CLIENT)
    public int rerenderCount;
    private int count;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readRailStates(nbt);
        this.readRailData(nbt);
    }

    public void readRailStates(NBTTagCompound nbt) {
        this.state.readFromNBT(nbt.func_74775_l("State"));
        if (this.state.version < 1) {
            this.state.readFromNBT(nbt.func_74775_l("Property"));
        }
        this.subRails.clear();
        NBTTagList list = nbt.func_150295_c("SubRails", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            ResourceStateRail state1 = new ResourceStateRail(RTMResource.RAIL, this);
            state1.readFromNBT(nbt1);
            this.subRails.add(state1);
        }
    }

    protected void readRailData(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("StartRP")) {
            return;
        }
        this.railPositions = new RailPosition[2];
        this.railPositions[0] = RailPosition.readFromNBT(nbt.func_74775_l("StartRP"));
        this.railPositions[1] = RailPosition.readFromNBT(nbt.func_74775_l("EndRP"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeRailStates(nbt);
        this.writeRailData(nbt);
        return nbt;
    }

    public void writeRailStates(NBTTagCompound nbt) {
        nbt.func_74782_a("State", (NBTBase)this.state.writeToNBT());
        NBTTagList tagList = new NBTTagList();
        for (ResourceStateRail state1 : this.subRails) {
            tagList.func_74742_a((NBTBase)state1.writeToNBT());
        }
        nbt.func_74782_a("SubRails", (NBTBase)tagList);
    }

    protected void writeRailData(NBTTagCompound nbt) {
        nbt.func_74782_a("StartRP", (NBTBase)this.railPositions[0].writeToNBT());
        nbt.func_74782_a("EndRP", (NBTBase)this.railPositions[1].writeToNBT());
    }

    @Override
    public void setStartPoint(int x, int y, int z) {
        this.startPoint[0] = x;
        this.startPoint[1] = y;
        this.startPoint[2] = z;
    }

    public void createRailMap() {
        if (this.isLoaded()) {
            if (this.getRailPositions()[0].hasScript()) {
                RailPosition rp = this.getRailPositions()[0];
                this.railmap = new RailMapCustom(rp, rp.scriptName, rp.scriptArgs);
            } else {
                this.railmap = new RailMapBasic(this.railPositions[0], this.railPositions[1]);
            }
        }
    }

    public boolean isLoaded() {
        return this.railPositions != null && this.railPositions.length > 0;
    }

    public RailPosition[] getRailPositions() {
        return this.railPositions;
    }

    public void setRailPositions(RailPosition[] par1) {
        this.railPositions = par1;
    }

    public int getSignal() {
        return this.signal;
    }

    public void setSignal(int par1) {
        this.signal = par1;
    }

    @Override
    public TileEntityLargeRailCore getRailCore() {
        return this;
    }

    @Override
    public void sendPacket() {
        if ((this.field_145850_b == null || !this.field_145850_b.field_72995_K) && this.isLoaded()) {
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketLargeRailCore(this, this.getPacketType()));
        }
    }

    public byte getPacketType() {
        return 0;
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            this.deleteGLList();
        }
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K) {
            this.deleteGLList();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void deleteGLList() {
        if (this.glLists != null) {
            for (GLObject glList : this.glLists) {
                GLHelper.deleteGLList((GLObject)glList);
            }
        }
        GLHelper.deleteGLList((GLObject)this.railBlocks);
        this.glLists = new GLObject[this.subRails.size() + 1];
        this.railBlocks = null;
    }

    public void replaceRail(ResourceStateRail state) {
        this.getResourceState().readFromNBT(state.writeToNBT());
        this.subRails.clear();
        this.sendPacket();
    }

    public void addSubRail(ResourceStateRail state) {
        ResourceStateRail newState = new ResourceStateRail(RTMResource.RAIL, this);
        newState.readFromNBT(state.writeToNBT());
        ResourceStateRail oldState = null;
        for (ResourceStateRail state1 : this.subRails) {
            if (!state1.getResourceName().equals(newState.getResourceName())) continue;
            oldState = state1;
            break;
        }
        if (oldState == null) {
            if (!this.getResourceState().getResourceName().equals(newState.getResourceName())) {
                this.subRails.add(newState);
            }
        } else {
            this.subRails.remove(oldState);
        }
        this.sendPacket();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.isCollidedTrain = this.colliding;
            this.colliding = false;
        } else {
            if (this.count >= 200) {
                this.updateBrightness();
                this.count = 0;
            }
            ++this.count;
            if (this.rerenderCount > 0) {
                ++this.rerenderCount;
                if (this.rerenderCount >= 100) {
                    this.shouldRerenderBlock = true;
                    this.rerenderCount = 0;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateBrightness() {
        int light = NGTUtil.getSkyLight((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        if (this.brightness != light) {
            this.brightness = light;
            this.shouldRerenderBlock = true;
            this.shouldRerenderRail = true;
        }
    }

    @Override
    public RailMap getRailMap(Entity entity) {
        if (this.railmap == null) {
            this.createRailMap();
        }
        return this.railmap;
    }

    @Nullable
    public RailMap[] getAllRailMaps() {
        RailMap[] railMapArray;
        RailMap rm = this.getRailMap(null);
        if (rm != null) {
            RailMap[] railMapArray2 = new RailMap[1];
            railMapArray = railMapArray2;
            railMapArray2[0] = rm;
        } else {
            railMapArray = null;
        }
        return railMapArray;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return NGTUtil.getChunkLoadDistanceSq();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isLoaded()) {
            return INFINITE_EXTENT_AABB;
        }
        if (this.renderAABB == null) {
            this.renderAABB = this.getRenderAABB();
            if (this.renderAABB == null) {
                return INFINITE_EXTENT_AABB;
            }
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    protected AxisAlignedBB getRenderAABB() {
        AABBInt box = this.getRailSize();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(box.minX - 1), (double)box.minY, (double)(box.minZ - 1), (double)(box.maxX + 2), (double)(box.maxY + 2), (double)(box.maxZ + 2));
        if (aabb.field_72336_d - aabb.field_72340_a <= 3.0 && aabb.field_72334_f - aabb.field_72339_c <= 3.0) {
            return null;
        }
        return aabb;
    }

    public AABBInt getRailSize() {
        int startX = this.railPositions[0].blockX;
        int startY = this.railPositions[0].blockY;
        int startZ = this.railPositions[0].blockZ;
        int endX = this.railPositions[1].blockX;
        int endY = this.railPositions[1].blockY;
        int endZ = this.railPositions[1].blockZ;
        int minX = startX <= endX ? startX : endX;
        int maxX = startX >= endX ? startX : endX;
        int minY = startY <= endY ? startY : endY;
        int maxY = startY >= endY ? startY : endY;
        int minZ = startZ <= endZ ? startZ : endZ;
        int maxZ = startZ >= endZ ? startZ : endZ;
        return new AABBInt(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void setPos(int x, int y, int z, int prevX, int prevY, int prevZ) {
        int difX = x - prevX;
        int difY = y - prevY;
        int difZ = z - prevZ;
        for (RailPosition rp : this.railPositions) {
            rp.movePos(difX, difY, difZ);
        }
        super.setPos(x, y, z, prevX, prevY, prevZ);
    }

    @Override
    public void updateResourceState() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.sendPacket();
        }
        this.shouldRerenderRail = true;
        this.shouldRerenderBlock = true;
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    public ResourceStateRail getResourceState() {
        return this.state;
    }

    public abstract String getRailShapeName();
}

