/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.rail.util.SwitchType;
import net.minecraft.world.World;

public final class RailMaker {
    private World worldObj;
    private List<RailPosition> rpList;

    public RailMaker(World world, List<RailPosition> par2) {
        this.worldObj = world;
        this.rpList = par2;
    }

    public RailMaker(World world, RailPosition[] par2) {
        this.worldObj = world;
        this.rpList = new ArrayList<RailPosition>();
        for (RailPosition rp : par2) {
            this.rpList.add(rp);
        }
    }

    private SwitchType getSwitchType() {
        if (this.rpList.size() == 3) {
            int i0 = 0;
            for (RailPosition rp : this.rpList) {
                i0 += rp.switchType == 1 ? 1 : 0;
            }
            if (i0 == 1) {
                return new SwitchType.SwitchBasic();
            }
        } else if (this.rpList.size() == 4) {
            int i0 = 0;
            for (RailPosition rp : this.rpList) {
                i0 += rp.switchType == 1 ? 1 : 0;
            }
            if (i0 == 2) {
                return new SwitchType.SwitchSingleCross();
            }
            if (i0 == 4) {
                for (int i = 0; i < this.rpList.size(); ++i) {
                    for (int j = i + 1; j < this.rpList.size(); ++j) {
                        if (this.rpList.get((int)i).direction != this.rpList.get((int)j).direction) continue;
                        return new SwitchType.SwitchScissorsCross();
                    }
                }
                return new SwitchType.SwitchDiamondCross();
            }
        }
        return null;
    }

    public SwitchType getSwitch() {
        SwitchType type = this.getSwitchType();
        if (type != null) {
            ArrayList<RailPosition> switchList = new ArrayList<RailPosition>();
            ArrayList<RailPosition> normalList = new ArrayList<RailPosition>();
            for (RailPosition rp : this.rpList) {
                if (rp.switchType == 1) {
                    switchList.add(rp);
                    continue;
                }
                normalList.add(rp);
            }
            if (type.init(switchList, normalList)) {
                return type;
            }
        }
        if (this.worldObj != null && !this.worldObj.field_72995_K) {
            RailPosition rp = this.rpList.get(0);
            NGTLog.sendChatMessageToAll((String)"message.rail.switch_type", (Object[])new Object[]{rp.blockX, rp.blockY, rp.blockZ});
        }
        return null;
    }
}

