/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.modelpack.cfg.RailConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import jp.ngt.rtm.rail.BlockMarker;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class RailMap {
    protected final List<int[]> rails = new ArrayList<int[]>();

    public boolean equals(Object obj) {
        if (obj instanceof RailMap) {
            RailMap rm = (RailMap)obj;
            return this.getStartRP().equals(rm.getStartRP());
        }
        return false;
    }

    public abstract RailPosition getStartRP();

    public abstract RailPosition getEndRP();

    public abstract double getLength();

    public abstract int getNearlestPoint(int var1, double var2, double var4);

    public abstract double[] getRailPos(int var1, int var2);

    public abstract double getRailHeight(int var1, int var2);

    public abstract float getRailYaw(int var1, int var2);

    @Deprecated
    public final float getRailRotation(int split, int index) {
        return this.getRailYaw(split, index);
    }

    public abstract float getRailPitch(int var1, int var2);

    public abstract float getRailRoll(int var1, int var2);

    @Deprecated
    public final float getCant(int split, int index) {
        return this.getRailRoll(split, index);
    }

    public boolean canConnect(RailMap railMap) {
        if (railMap == null) {
            return false;
        }
        if (this.equals(railMap)) {
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] p1;
                double[] p0 = this.getRailPos(10, i * 10);
                if (!NGTMath.compare((double)p0[0], (double)(p1 = railMap.getRailPos(10, j * 10))[0], (int)5) || !NGTMath.compare((double)p0[1], (double)p1[1], (int)5)) continue;
                return true;
            }
        }
        return false;
    }

    protected void createRailList(ResourceStateRail prop) {
        ModelSetRail modelSet = (ModelSetRail)prop.getResourceSet();
        int halfWidth = ((RailConfig)modelSet.getConfig()).ballastWidth >> 1;
        this.rails.clear();
        int split = (int)(this.getLength() * 4.0);
        double halfPi = 1.5707963267948966;
        for (int j = 1; j < split - 1; ++j) {
            double[] point = this.getRailPos(split, j);
            double x = point[1];
            double z = point[0];
            double slope = NGTMath.toRadians((float)this.getRailYaw(split, j));
            double height = this.getRailHeight(split, j);
            int y = (int)height;
            for (int i = 0; i <= halfWidth; ++i) {
                double d0 = (double)i + 0.25;
                int x1 = NGTMath.floor((double)(x + Math.sin(slope + halfPi) * d0));
                int z1 = NGTMath.floor((double)(z + Math.cos(slope + halfPi) * d0));
                this.addRailBlock(x1, y, z1);
                int x2 = NGTMath.floor((double)(x + Math.sin(slope - halfPi) * d0));
                int z2 = NGTMath.floor((double)(z + Math.cos(slope - halfPi) * d0));
                this.addRailBlock(x2, y, z2);
            }
            int x0 = NGTMath.floor((double)x);
            int z0 = NGTMath.floor((double)z);
            this.addRailBlock(x0, y, z0);
        }
    }

    protected void addRailBlock(int x, int y, int z) {
        for (int i = 0; i < this.rails.size(); ++i) {
            int[] ia = this.rails.get(i);
            if (ia[0] != x || ia[2] != z) continue;
            if (ia[1] <= y) {
                return;
            }
            this.rails.remove(i);
            --i;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!pos.equals((Object)this.getStartRP().getNeighborBlockPos()) && !pos.equals((Object)this.getEndRP().getNeighborBlockPos())) {
            this.rails.add(new int[]{x, y, z});
        }
    }

    public void setRail(World world, Block block, int x0, int y0, int z0, ResourceStateRail prop) {
        this.createRailList(prop);
        this.setBaseBlock(world, x0, y0, z0);
        for (int i = 0; i < this.rails.size(); ++i) {
            int z;
            int y;
            int x = this.rails.get(i)[0];
            Block block2 = BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y = this.rails.get(i)[1]), (int)(z = this.rails.get(i)[2]));
            if (block2 instanceof BlockLargeRailBase && block2 != block) continue;
            BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)block, (int)0, (int)2);
            TileEntityLargeRailBase tile = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
            tile.setStartPoint(x0, y0, z0);
        }
        this.rails.clear();
    }

    private void setBaseBlock(World world, int x0, int y0, int z0) {
        int split = (int)(this.getLength() * 4.0);
        RailPosition rp = this.getStartRP();
        int minWidth = NGTMath.floor((float)(rp.constLimitWN + 0.5f));
        int maxWidth = NGTMath.floor((float)(rp.constLimitWP + 0.5f));
        int minHeight = NGTMath.floor((float)rp.constLimitHN);
        int maxHeight = NGTMath.floor((float)rp.constLimitHP);
        IBlockState[][] template = new IBlockState[maxHeight - minHeight + 1][maxWidth - minWidth + 1];
        for (int k = 0; k < split - 1; ++k) {
            double[] point = this.getRailPos(split, k);
            double x = point[1];
            double z = point[0];
            double y = this.getRailHeight(split, k);
            float yaw = NGTMath.wrapAngle((float)this.getRailYaw(split, k));
            for (int i = 0; i < template.length; ++i) {
                int h = minHeight + i;
                for (int j = 0; j < template[i].length; ++j) {
                    int w = minWidth + j;
                    Vec3 vec = new Vec3((double)w, (double)h, 0.0);
                    vec = vec.rotateAroundY(yaw);
                    BlockPos pos = new BlockPos(x + vec.getX(), y + vec.getY(), z + vec.getZ());
                    if (k == 0) {
                        IBlockState state = world.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (block instanceof BlockMarker || block instanceof BlockLargeRailBase) continue;
                        template[i][j] = state;
                        continue;
                    }
                    if (template[i][j] == null || world.func_180495_p(pos).func_177230_c() instanceof BlockLargeRailBase) continue;
                    world.func_175656_a(pos, template[i][j]);
                }
            }
        }
    }

    public void breakRail(World world, ResourceStateRail prop, TileEntityLargeRailCore core) {
        this.createRailList(prop);
        for (int i = 0; i < this.rails.size(); ++i) {
            TileEntityLargeRailCore core2;
            TileEntityLargeRailBase rail;
            int z;
            int y;
            int x = this.rails.get(i)[0];
            if (!(BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y = this.rails.get(i)[1]), (int)(z = this.rails.get(i)[2])) instanceof BlockLargeRailBase) || (rail = (TileEntityLargeRailBase)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z)) == core || (core2 = rail.getRailCore()) != null && core2 != core) continue;
            world.func_175698_g(new BlockPos(x, y, z));
        }
        world.func_175698_g(core.func_174877_v());
        this.rails.clear();
    }

    public boolean canPlaceRail(World world, boolean isCreative, ResourceStateRail prop) {
        this.createRailList(prop);
        boolean flag = true;
        for (int i = 0; i < this.rails.size(); ++i) {
            boolean b0;
            int z;
            int y;
            int x = this.rails.get(i)[0];
            IBlockState state = world.func_180495_p(new BlockPos(x, y = this.rails.get(i)[1], z = this.rails.get(i)[2]));
            Block block = state.func_177230_c();
            boolean bl = b0 = block.func_149688_o(state) == Material.field_151579_a || block == RTMBlock.marker || block == RTMBlock.markerSwitch || block instanceof BlockLargeRailBase && !((BlockLargeRailBase)block).isCore();
            if (!isCreative && !b0) {
                NGTLog.sendChatMessageToAll((String)"message.rail.obstacle", (Object[])new Object[]{":" + x + "," + y + "," + z});
                return false;
            }
            flag = b0 && flag;
        }
        return isCreative || flag;
    }

    public List<int[]> getRailBlockList(ResourceStateRail prop, boolean regenerate) {
        if (this.rails.isEmpty() || regenerate) {
            this.createRailList(prop);
        }
        return new ArrayList<int[]>(this.rails);
    }

    public void showRailProp() {
        NGTLog.sendChatMessageToAll((String)String.format("SP X%5.1f Z%5.1f", this.getStartRP().posX, this.getStartRP().posZ), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("SA L%5.1f Y%5.1f", Float.valueOf(this.getStartRP().anchorLengthHorizontal), Float.valueOf(this.getStartRP().anchorYaw)), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("EP X%5.1f Z%5.1f", this.getEndRP().posX, this.getEndRP().posZ), (Object[])new Object[0]);
        NGTLog.sendChatMessageToAll((String)String.format("EA L%5.1f Y%5.1f", Float.valueOf(this.getEndRP().anchorLengthHorizontal), Float.valueOf(this.getEndRP().anchorYaw)), (Object[])new Object[0]);
    }
}

