/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import javax.script.ScriptEngine;
import jp.ngt.ngtlib.io.ScriptUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;

public final class RailMapCustom
extends RailMap {
    private RailPosition startRP;
    private RailPosition endRP;
    private ScriptEngine script;

    public RailMapCustom(RailPosition rp, String scriptName, String args) {
        this.startRP = rp;
        this.init(scriptName, args);
    }

    private void init(String scriptName, String args) {
        this.script = ScriptUtil.doScript((String)ModelPackManager.INSTANCE.getScript(scriptName));
        int split = (int)(this.getLength() * 4.0);
        double[] dzx = this.getRailPos(split, split);
        double dy = this.getRailHeight(split, split);
        float yaw = this.getRailYaw(split, split);
        int x = NGTMath.floor((double)dzx[1]);
        int y = NGTMath.floor((double)dy);
        int z = NGTMath.floor((double)dzx[0]);
        int dir = NGTMath.floor((float)((yaw + 360.0f) % 360.0f / 45.0f));
        this.endRP = new RailPosition(x, y, z, dir, 0);
    }

    public static String getDefaultArgs(String scriptName) {
        return RailMapCustom.getDefaultArgs(ScriptUtil.doScript((String)ModelPackManager.INSTANCE.getScript(scriptName)));
    }

    public static String getDefaultArgs(ScriptEngine se) {
        return (String)ScriptUtil.doScriptFunction((ScriptEngine)se, (String)"getDefaultArgs", (Object[])new Object[0]);
    }

    @Override
    public RailPosition getStartRP() {
        return this.startRP;
    }

    @Override
    public RailPosition getEndRP() {
        return this.endRP;
    }

    @Override
    public double getLength() {
        return (Double)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getLength", (Object[])new Object[0]);
    }

    @Override
    public int getNearlestPoint(int split, double x, double z) {
        return (Integer)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getNearlestPoint", (Object[])new Object[]{split, x, z});
    }

    @Override
    public double[] getRailPos(int split, int index) {
        return (double[])ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getPos", (Object[])new Object[]{split, index});
    }

    @Override
    public double getRailHeight(int split, int index) {
        return (Double)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getHeight", (Object[])new Object[]{split, index});
    }

    @Override
    public float getRailYaw(int split, int index) {
        float yaw = ((Float)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getYaw", (Object[])new Object[]{split, index})).floatValue();
        return yaw + this.startRP.anchorYaw;
    }

    @Override
    public float getRailPitch(int split, int index) {
        return ((Float)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getPitch", (Object[])new Object[]{split, index})).floatValue();
    }

    @Override
    public float getRailRoll(int split, int index) {
        return ((Float)ScriptUtil.doScriptFunction((ScriptEngine)this.script, (String)"getRoll", (Object[])new Object[]{split, index})).floatValue();
    }
}

