/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.rail.util.RailDir;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class RailPosition {
    protected static final float Anchor_Correction_Value = 0.5522848f;
    public static final float[][] REVISION = new float[][]{{0.0f, -0.5f}, {-0.5f, -0.5f}, {-0.5f, 0.0f}, {-0.5f, 0.499999f}, {0.0f, 0.499999f}, {0.499999f, 0.499999f}, {0.499999f, 0.0f}, {0.499999f, -0.5f}};
    public int blockX;
    public int blockY;
    public int blockZ;
    public final byte switchType;
    public byte direction;
    public byte height;
    public float anchorYaw;
    public float anchorPitch;
    public float anchorLengthHorizontal;
    public float anchorLengthVertical;
    public float cantCenter;
    public float cantEdge;
    public float cantRandom;
    public float constLimitHP;
    public float constLimitHN;
    public float constLimitWP;
    public float constLimitWN;
    public double posX;
    public double posY;
    public double posZ;
    public String scriptName;
    public String scriptArgs;

    public RailPosition(int x, int y, int z, int dir, int type) {
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.direction = (byte)dir;
        this.switchType = (byte)type;
        this.height = 0;
        this.anchorYaw = NGTMath.wrapAngle((float)((float)dir * 45.0f));
        this.anchorLengthHorizontal = -1.0f;
        this.constLimitHP = 3.99f;
        this.constLimitHN = 0.0f;
        this.constLimitWP = 1.49f;
        this.constLimitWN = -1.49f;
        this.init();
    }

    public void init() {
        this.posX = (double)this.blockX + 0.5 + (double)REVISION[this.direction][0];
        this.posY = (double)this.blockY + (double)(this.height + 1) * 0.0625;
        this.posZ = (double)this.blockZ + 0.5 + (double)REVISION[this.direction][1];
    }

    public void addHeight(double par1) {
        int h2 = (int)(par1 / 0.0625);
        this.height = (byte)(this.height + h2);
    }

    public static RailPosition readFromNBT(NBTTagCompound nbt) {
        int[] pos = nbt.func_74759_k("BlockPos");
        byte b0 = nbt.func_74771_c("Direction");
        byte b2 = nbt.func_74771_c("SwitchType");
        RailPosition rp = new RailPosition(pos[0], pos[1], pos[2], b0, b2);
        rp.setHeight(nbt.func_74771_c("Height"));
        rp.anchorYaw = nbt.func_74760_g("A_Direction");
        rp.anchorPitch = nbt.func_74760_g("A_Pitch");
        rp.anchorLengthHorizontal = nbt.func_74760_g("A_Length");
        rp.anchorLengthVertical = nbt.func_74760_g("A_LenV");
        rp.cantCenter = nbt.func_74760_g("C_Center");
        rp.cantEdge = nbt.func_74760_g("C_Edge");
        rp.cantRandom = nbt.func_74760_g("C_Random");
        rp.constLimitHP = nbt.func_74760_g("Const_Limit_HP");
        rp.constLimitHN = nbt.func_74760_g("Const_Limit_HN");
        rp.constLimitWP = nbt.func_74760_g("Const_Limit_WP");
        rp.constLimitWN = nbt.func_74760_g("Const_Limit_WN");
        if (nbt.func_74764_b("Script")) {
            rp.scriptName = nbt.func_74779_i("Script");
            rp.scriptArgs = nbt.func_74779_i("Args");
        }
        return rp;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("BlockPos", new int[]{this.blockX, this.blockY, this.blockZ});
        nbt.func_74774_a("SwitchType", this.switchType);
        nbt.func_74774_a("Direction", this.direction);
        nbt.func_74774_a("Height", this.height);
        nbt.func_74776_a("A_Direction", this.anchorYaw);
        nbt.func_74776_a("A_Pitch", this.anchorPitch);
        nbt.func_74776_a("A_Length", this.anchorLengthHorizontal);
        nbt.func_74776_a("A_LenV", this.anchorLengthVertical);
        nbt.func_74776_a("C_Center", this.cantCenter);
        nbt.func_74776_a("C_Edge", this.cantEdge);
        nbt.func_74776_a("C_Random", this.cantRandom);
        nbt.func_74776_a("Const_Limit_HP", this.constLimitHP);
        nbt.func_74776_a("Const_Limit_HN", this.constLimitHN);
        nbt.func_74776_a("Const_Limit_WP", this.constLimitWP);
        nbt.func_74776_a("Const_Limit_WN", this.constLimitWN);
        if (this.hasScript()) {
            nbt.func_74778_a("Script", this.scriptName);
            nbt.func_74778_a("Args", this.scriptArgs);
        }
        return nbt;
    }

    public void setHeight(byte par1) {
        this.height = par1;
        this.posY = (double)this.blockY + (double)(par1 + 1) * 0.0625;
    }

    public void movePos(int x, int y, int z) {
        this.blockX += x;
        this.blockY += y;
        this.blockZ += z;
        this.posX += (double)x;
        this.posY += (double)y;
        this.posZ += (double)z;
    }

    public RailDir getDir(RailPosition p1, RailPosition p2) {
        double dif1z = p1.posZ - this.posZ;
        double dif2x = p2.posX - this.posX;
        double dif1x = p1.posX - this.posX;
        double dif2z = p2.posZ - this.posZ;
        double d0 = dif1z * dif2x - dif1x * dif2z;
        return d0 > 0.0 ? RailDir.LEFT : (d0 < 0.0 ? RailDir.RIGHT : RailDir.NONE);
    }

    public boolean checkRSInput(World world) {
        return world.func_175687_A(new BlockPos(this.blockX, this.blockY, this.blockZ)) > 0;
    }

    public BlockPos getNeighborBlockPos() {
        int x2 = NGTMath.floor((double)(this.posX + (double)REVISION[this.direction][0]));
        int y2 = this.blockY;
        int z2 = NGTMath.floor((double)(this.posZ + (double)REVISION[this.direction][1]));
        return new BlockPos(x2, y2, z2);
    }

    public boolean hasScript() {
        return this.scriptName != null && this.scriptName.length() > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RailPosition) {
            RailPosition rp = (RailPosition)obj;
            return rp.blockX == this.blockX && rp.blockY == this.blockY && rp.blockZ == this.blockZ;
        }
        return false;
    }
}

